/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.generation;

import com.intellij.ide.fileTemplates.JavaCreateFromTemplateHandler;
import com.intellij.jsf.generation.EntityGenerateInfo;
import com.intellij.jsf.generation.FacesGenerationTemplateUtil;
import com.intellij.jsf.generation.FacesGenerationTemplatesFactory;
import com.intellij.jsf.generation.GenerateSettings;
import com.intellij.jsf.model.xml.FacesConfig;
import com.intellij.jsf.model.xml.converter.JsfDomConverter;
import com.intellij.jsf.model.xml.managedBeans.BeanScope;
import com.intellij.jsf.model.xml.managedBeans.ManagedBean;
import com.intellij.jsf.model.xml.navigationRules.NavigationCase;
import com.intellij.jsf.model.xml.navigationRules.NavigationRule;
import com.intellij.jsf.resources.FacesBundle;
import com.intellij.jsf.utils.FacesConfigUtils;
import com.intellij.jsf.utils.JsfCommonUtils;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.io.ReadOnlyAttributeUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FacesGenerationUtil {
    private static final Logger LOG = Logger.getInstance(FacesGenerationUtil.class);
    private static final String EDIT_NAME = "Edit";
    private static final String VIEW_NAME = "View";
    private static final String LIST_NAME = "List";
    private static final String CREATE_NAME = "Create";
    private static final String INDEX_FILE_NAME = "index.jsp";
    @NonNls
    private static final String ENTITIES = "Entities";

    public static void generateFacesPages(@NotNull GenerateSettings settings, @NotNull List<EntityGenerateInfo> entityInfos) {
        if (settings == null) {
            FacesGenerationUtil.$$$reportNull$$$0(0);
        }
        if (entityInfos == null) {
            FacesGenerationUtil.$$$reportNull$$$0(1);
        }
        CommonRewriteInfo rewriteAll = new CommonRewriteInfo();
        WriteCommandAction.writeCommandAction((Project)settings.getProject()).run(() -> {
            FacesGenerationUtil.generatePages(settings, entityInfos, rewriteAll);
            FacesGenerationUtil.generateClasses(settings, entityInfos, rewriteAll);
        });
    }

    @Nullable
    private static NavigationRule getOrCreteNavigationRule(GenerateSettings settings) {
        XmlFile xmlFile = settings.getFacesConfig();
        if (xmlFile == null) {
            return null;
        }
        FacesConfig facesConfig = FacesConfigUtils.getFacesConfig(xmlFile);
        if (facesConfig == null) {
            return null;
        }
        for (NavigationRule rule : facesConfig.getNavigationRules()) {
            if (!"*".equals(rule.getFromViewId().getStringValue())) continue;
            return rule;
        }
        NavigationRule navigationRule = facesConfig.addNavigationRule();
        navigationRule.getFromViewId().setStringValue("*");
        return navigationRule;
    }

    private static void createNavigationCases(NavigationRule rule, GenerateSettings settings, VirtualFile file, String action) {
        if (rule == null || file == null) {
            return;
        }
        String relatedPath = JsfCommonUtils.getRelatedPath(settings.getProject(), file);
        if (relatedPath != null) {
            NavigationCase navigationCase = FacesGenerationUtil.getOrCreateNavigationCase(rule, relatedPath, action);
            navigationCase.getToViewId().setStringValue(relatedPath);
            navigationCase.getFromOutcome().setValue((Object)action);
        }
    }

    private static NavigationCase getOrCreateNavigationCase(NavigationRule rule, String relatedPath, String action) {
        for (NavigationCase aCase : rule.getNavigationCases()) {
            if (!relatedPath.equals(aCase.getToViewId().getStringValue()) || !action.equals(aCase.getFromOutcome().getStringValue())) continue;
            return aCase;
        }
        return rule.addNavigationCase();
    }

    private static void createManagedBeanDefinition(FacesConfig facesConfig, String managedBeanName, PsiClass psiClass) {
        if (facesConfig == null) {
            return;
        }
        ManagedBean bean = FacesGenerationUtil.getOrCreateManagedBean(facesConfig, managedBeanName);
        bean.getManagedBeanName().setValue((Object)managedBeanName);
        bean.getManagedBeanClass().setValue((Object)psiClass);
        bean.getManagedBeanScope().setValue((Object)BeanScope.SESSION);
    }

    private static void createConverterDefinition(FacesConfig facesConfig, String forClass, PsiClass psiClass) {
        if (facesConfig == null) {
            return;
        }
        JsfDomConverter converter = FacesGenerationUtil.getOrCreateConverter(facesConfig, forClass);
        converter.getConverterForClass().setStringValue(forClass);
        converter.getConverterClass().setValue((Object)psiClass);
    }

    private static ManagedBean getOrCreateManagedBean(FacesConfig facesConfig, String managedBeanName) {
        for (ManagedBean managedBean : facesConfig.getManagedBeans()) {
            if (!managedBeanName.equals(managedBean.getManagedBeanName().getStringValue())) continue;
            return managedBean;
        }
        return facesConfig.addPropertyBean();
    }

    private static JsfDomConverter getOrCreateConverter(FacesConfig facesConfig, String forClass) {
        for (JsfDomConverter converter : facesConfig.getConverters()) {
            if (!forClass.equals(converter.getConverterForClass().getStringValue())) continue;
            return converter;
        }
        return facesConfig.addConverter();
    }

    private static void generateClasses(@NotNull GenerateSettings settings, List<EntityGenerateInfo> entityInfos, CommonRewriteInfo rewriteAll) throws IncorrectOperationException {
        if (settings == null) {
            FacesGenerationUtil.$$$reportNull$$$0(2);
        }
        PsiDirectory[] psiDirectories = settings.getManagedBeanPackage().getDirectories();
        FacesConfig facesConfig = FacesConfigUtils.getFacesConfig(settings.getFacesConfig());
        PsiDirectory psiDirectory = null;
        for (PsiDirectory psiDir : psiDirectories) {
            Module module = ModuleUtilCore.findModuleForFile((VirtualFile)psiDir.getVirtualFile(), (Project)settings.getProject());
            if (module == null || !module.equals(settings.getModule())) continue;
            psiDirectory = psiDir;
            break;
        }
        if (psiDirectory == null) {
            return;
        }
        for (EntityGenerateInfo entityInfo : entityInfos) {
            PsiClass createdConverterClass;
            if (!entityInfo.isEnabled()) continue;
            PsiClass createdManagedBeanClass = FacesGenerationUtil.createClassFromTemplate(entityInfo, settings, entityInfo.getManagedBeanTemplate(), psiDirectory, FacesGenerationTemplateUtil.getManagedBeanClassName(entityInfo, settings), rewriteAll);
            if (createdManagedBeanClass != null) {
                FacesGenerationUtil.createManagedBeanDefinition(facesConfig, entityInfo.getManagedBeanName(), createdManagedBeanClass);
            }
            if ((createdConverterClass = FacesGenerationUtil.createClassFromTemplate(entityInfo, settings, "converter_template.java", psiDirectory, FacesGenerationTemplateUtil.getConverterClassName(entityInfo, settings), rewriteAll)) == null) continue;
            FacesGenerationUtil.createConverterDefinition(facesConfig, ((PsiClass)entityInfo.getEntity().getClazz().getValue()).getQualifiedName(), createdConverterClass);
        }
    }

    @Nullable
    private static PsiClass createClassFromTemplate(EntityGenerateInfo entityInfo, GenerateSettings settings, String template, PsiDirectory psiDirectory, String className, CommonRewriteInfo rewriteAll) throws IncorrectOperationException {
        String text = FacesGenerationTemplateUtil.createTemplateText(entityInfo, settings, template);
        String extension = FacesGenerationTemplatesFactory.getTemplate(template).getExtension();
        PsiFile psiFile = psiDirectory.findFile(className + "." + extension);
        if (psiFile != null) {
            if (FacesGenerationUtil.isSaveText(true, className + "." + extension, rewriteAll)) {
                psiFile.delete();
            } else {
                return null;
            }
        }
        return JavaCreateFromTemplateHandler.createClassOrInterface((Project)settings.getProject(), (PsiDirectory)psiDirectory, (String)text, (boolean)true, (String)extension);
    }

    private static void generatePages(@NotNull GenerateSettings settings, List<EntityGenerateInfo> entityInfos, CommonRewriteInfo rewriteAll) {
        if (settings == null) {
            FacesGenerationUtil.$$$reportNull$$$0(3);
        }
        try {
            for (EntityGenerateInfo entityGenerateInfo : entityInfos) {
                if (!entityGenerateInfo.isEnabled()) continue;
                VirtualFile directory = FacesGenerationUtil.getDirectory(settings.getPagesGenerateDirectory(), settings, entityGenerateInfo);
                VirtualFile editFile = FacesGenerationUtil.createFileFromTemplate(directory, FacesGenerationUtil.createName(EDIT_NAME, entityGenerateInfo, entityGenerateInfo.getEditTemplate(), settings), FacesGenerationTemplateUtil.createTemplateText(entityGenerateInfo, settings, entityGenerateInfo.getEditTemplate()), rewriteAll);
                VirtualFile viewFile = FacesGenerationUtil.createFileFromTemplate(directory, FacesGenerationUtil.createName(VIEW_NAME, entityGenerateInfo, entityGenerateInfo.getViewTemplate(), settings), FacesGenerationTemplateUtil.createTemplateText(entityGenerateInfo, settings, entityGenerateInfo.getViewTemplate()), rewriteAll);
                VirtualFile createFile = FacesGenerationUtil.createFileFromTemplate(directory, FacesGenerationUtil.createName(CREATE_NAME, entityGenerateInfo, entityGenerateInfo.getCreateTemplate(), settings), FacesGenerationTemplateUtil.createTemplateText(entityGenerateInfo, settings, entityGenerateInfo.getCreateTemplate()), rewriteAll);
                VirtualFile listFile = FacesGenerationUtil.createFileFromTemplate(directory, FacesGenerationUtil.createName(LIST_NAME, entityGenerateInfo, entityGenerateInfo.getListTemplate(), settings), FacesGenerationTemplateUtil.createTemplateText(entityGenerateInfo, settings, entityGenerateInfo.getListTemplate()), rewriteAll);
                NavigationRule rule = FacesGenerationUtil.getOrCreteNavigationRule(settings);
                if (rule == null) continue;
                FacesGenerationUtil.createNavigationCases(rule, settings, editFile, entityGenerateInfo.getEditAction());
                FacesGenerationUtil.createNavigationCases(rule, settings, viewFile, entityGenerateInfo.getViewAction());
                FacesGenerationUtil.createNavigationCases(rule, settings, listFile, entityGenerateInfo.getListAction());
                FacesGenerationUtil.createNavigationCases(rule, settings, createFile, entityGenerateInfo.getCreateAction());
            }
            if (settings.isGenerateIndexPage()) {
                ArrayList<EntityGenerateInfo> generated = new ArrayList<EntityGenerateInfo>();
                for (EntityGenerateInfo entityInfo : entityInfos) {
                    if (!entityInfo.isEnabled()) continue;
                    generated.add(entityInfo);
                }
                HashMap<String, Object> hashMap = FacesGenerationTemplateUtil.getDefaultGenerateProperties(settings, settings);
                hashMap.put(ENTITIES, generated);
                String templateText = FacesGenerationTemplateUtil.createTemplateText("index_page_template.jsp", hashMap);
                FacesGenerationUtil.createFileFromTemplate(settings.getPagesGenerateDirectory(), INDEX_FILE_NAME, templateText, rewriteAll);
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private static VirtualFile getDirectory(VirtualFile directory, GenerateSettings settings, EntityGenerateInfo entityInfo) throws IOException {
        if (!settings.isCreateSubdirectories()) {
            return directory;
        }
        String directoryName = StringUtil.decapitalize((String)entityInfo.getName());
        VirtualFile child = directory.findChild(directoryName);
        if (child != null) {
            return child;
        }
        return directory.createChildDirectory(FacesGenerationUtil.class, directoryName);
    }

    private static String createName(String prefix, EntityGenerateInfo entityInfo, String template, GenerateSettings settings) {
        return prefix + (settings.isAutoCreateNames() || !settings.isCreateSubdirectories() ? entityInfo.getName() : "") + "." + FacesGenerationTemplatesFactory.getTemplate(template).getExtension();
    }

    @Nullable
    private static VirtualFile createFileFromTemplate(VirtualFile directory, String fileName, String templateText, CommonRewriteInfo rewriteAll) throws IOException {
        VirtualFile virtualFile;
        VirtualFile child = directory.findChild(fileName);
        VirtualFile virtualFile2 = virtualFile = child != null ? child : directory.createChildData(FacesGenerationUtil.class, fileName);
        if (virtualFile != null && FacesGenerationUtil.isSaveText(child != null, fileName, rewriteAll)) {
            if (!virtualFile.isWritable()) {
                ReadOnlyAttributeUtil.setReadOnlyAttribute((VirtualFile)virtualFile, (boolean)false);
            }
            VfsUtil.saveText((VirtualFile)virtualFile, (String)templateText);
        }
        return virtualFile;
    }

    private static boolean isSaveText(boolean isExist, String fileName, CommonRewriteInfo rewriteAll) {
        if (!isExist || rewriteAll.getValue() == CommonRewriteInfo.YES_TO_ALL) {
            return true;
        }
        if (rewriteAll.getValue() == CommonRewriteInfo.NO_TO_ALL) {
            return false;
        }
        String message = FacesBundle.message("faces.generation.dialog.rewrite.confirmation", fileName);
        String title = FacesBundle.message("faces.generation.dialog.rewrite.confirmation.title", new Object[0]);
        int result = Messages.showDialog((String)message, (String)title, (String[])new String[]{FacesBundle.message("dialog.yes", new Object[0]), FacesBundle.message("dialog.no", new Object[0]), FacesBundle.message("yes.to.all", new Object[0]), FacesBundle.message("no.to.all", new Object[0])}, (int)0, (Icon)Messages.getQuestionIcon());
        switch (result) {
            case 0: {
                return true;
            }
            case 1: {
                return false;
            }
            case 2: {
                rewriteAll.setValue(CommonRewriteInfo.YES_TO_ALL);
                return true;
            }
            case 3: {
                rewriteAll.setValue(CommonRewriteInfo.NO_TO_ALL);
                return false;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entityInfos";
                break;
            }
        }
        objectArray2[1] = "com/intellij/jsf/generation/FacesGenerationUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "generateFacesPages";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "generateClasses";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "generatePages";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class CommonRewriteInfo {
        public static int UNKNOWN = 0;
        public static int YES_TO_ALL = 1;
        public static int NO_TO_ALL = 2;
        private int myValue = UNKNOWN;

        CommonRewriteInfo() {
        }

        public int getValue() {
            return this.myValue;
        }

        public void setValue(int value) {
            this.myValue = value;
        }
    }
}

