/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.generation;

import com.intellij.jsf.generation.EntityGenerateInfo;
import com.intellij.jsf.generation.FacesGenerationTemplateUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.persistence.model.PersistentAttribute;
import com.intellij.persistence.model.PersistentEntity;
import com.intellij.persistence.model.PersistentRelationshipAttribute;
import com.intellij.persistence.model.RelationshipType;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AttributeGenerateInfo {
    public static String VALUE = "VALUE";
    public static String UNKNOWN = "UNKNOWN";
    public static String MANY_TO_MANY = "MANY_TO_MANY";
    public static String MANY_TO_ONE = "MANY_TO_ONE";
    public static String ONE_TO_MANY = "ONE_TO_MANY";
    public static String ONE_TO_ONE = "ONE_TO_ONE";
    private final EntityGenerateInfo myEntity;
    private final PersistentAttribute myAttribute;
    private AttributeGenerateInfo myParent;
    private boolean myEmbedded;

    public AttributeGenerateInfo(EntityGenerateInfo entity, PersistentAttribute attribute) {
        this(entity, attribute, null, false);
    }

    public AttributeGenerateInfo(EntityGenerateInfo entity, PersistentAttribute attribute, boolean embedded) {
        this(entity, attribute, null, embedded);
    }

    public AttributeGenerateInfo(EntityGenerateInfo entity, PersistentAttribute attribute, AttributeGenerateInfo parent, boolean embedded) {
        this.myEntity = entity;
        this.myAttribute = attribute;
        this.myParent = parent;
        this.myEmbedded = embedded;
    }

    public PersistentAttribute getAttribute() {
        return this.myAttribute;
    }

    public String getName() {
        String value = this.getAttribute().getName().getStringValue();
        return value == null ? "" : value;
    }

    public String getAttributeType() {
        PsiType type = this.getAttribute().getPsiType();
        return type == null ? "UNKNOWN_TYPE" : type.getCanonicalText();
    }

    public boolean isFieldAccesed() {
        return this.getAttribute().getPsiMember() instanceof PsiField;
    }

    public String getSetterName() {
        return "set" + StringUtil.capitalize((String)this.getName());
    }

    public String getManagedBeanReference() {
        return "#{" + this.myEntity.getManagedBeanName() + ".entity." + this.getReferenceName() + "}";
    }

    public String getReferenceName() {
        String stringValue;
        Object result = this.getAttribute().getName().getStringValue();
        if (result == null) {
            return "unknown_attribute";
        }
        for (AttributeGenerateInfo parent = this.getParent(); parent != null && (stringValue = parent.getAttribute().getName().getStringValue()) != null; parent = parent.getParent()) {
            result = stringValue + "." + (String)result;
        }
        return result;
    }

    @Nullable
    public EntityGenerateInfo getTargetEntityInfo() {
        PersistentEntity entity = this.getTargetEntity();
        if (entity != null) {
            return new EntityGenerateInfo(entity, this.myEntity.getModule(), this.myEntity.getBrowser());
        }
        return null;
    }

    @NotNull
    public String getReferencedManagedBeanName() {
        EntityGenerateInfo generateInfo = this.getTargetEntityInfo();
        if (generateInfo != null) {
            String string = FacesGenerationTemplateUtil.getManagedBeanName(generateInfo.getManagedBeanName());
            if (string == null) {
                AttributeGenerateInfo.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = UNKNOWN;
        if (string == null) {
            AttributeGenerateInfo.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    private PersistentEntity getTargetEntity() {
        if (this.getAttribute() instanceof PersistentRelationshipAttribute) {
            return (PersistentEntity)this.myEntity.getBrowser().queryTargetPersistentObjects((PersistentRelationshipAttribute)this.getAttribute()).findFirst();
        }
        return null;
    }

    public String getType() {
        if (this.getAttribute() instanceof PersistentRelationshipAttribute) {
            RelationshipType type = ((PersistentRelationshipAttribute)this.getAttribute()).getAttributeModelHelper().getRelationshipType();
            switch (type) {
                case MANY_TO_MANY: {
                    return MANY_TO_MANY;
                }
                case MANY_TO_ONE: {
                    return MANY_TO_ONE;
                }
                case ONE_TO_MANY: {
                    return ONE_TO_MANY;
                }
                case ONE_TO_ONE: {
                    return ONE_TO_ONE;
                }
            }
        }
        return this.getAttributeType();
    }

    public boolean isEmbedded() {
        return this.myEmbedded;
    }

    public void setEmbedded(boolean embedded) {
        this.myEmbedded = embedded;
    }

    public AttributeGenerateInfo getParent() {
        return this.myParent;
    }

    public void setParent(AttributeGenerateInfo parent) {
        this.myParent = parent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/generation/AttributeGenerateInfo", "getReferencedManagedBeanName"));
    }
}

