/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.facet;

import com.intellij.javaee.model.xml.ParamValue;
import com.intellij.javaee.web.WebRoot;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.javaee.web.model.xml.Servlet;
import com.intellij.javaee.web.model.xml.ServletMapping;
import com.intellij.javaee.web.model.xml.WebApp;
import com.intellij.jsf.resources.FacesBundle;
import com.intellij.jsf.utils.JsfCommonUtils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.deployment.DeploymentUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.descriptors.ConfigFile;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AddFacesSupportUtil {
    @NonNls
    private static final String FACES_CONFIG_DEFAULT_RELATIVE_PATH = "/WEB-INF/faces-config.xml";
    @NonNls
    private static final String FACES_SERVLET = "Faces Servlet";
    @NonNls
    private static final String[] FACES_URL_PATTERNS = new String[]{"*.xhtml"};
    @NonNls
    private static final String JAVAX_FACES_WEBAPP_FACES_SERVLET = "javax.faces.webapp.FacesServlet";

    private AddFacesSupportUtil() {
    }

    @Nullable
    public static VirtualFile createFacesConfig(WebFacet webFacet, @Nullable String version, @NotNull @NonNls String configFilePath) throws IOException {
        VirtualFile file;
        File configFile;
        if (configFilePath == null) {
            AddFacesSupportUtil.$$$reportNull$$$0(0);
        }
        if (!(configFile = new File(FileUtil.toSystemDependentName((String)configFilePath))).exists()) {
            String text = JsfCommonUtils.getFacesConfigTemplateText(version);
            FileUtil.createIfDoesntExist((File)configFile);
            file = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(configFile);
            WriteAction.run(() -> VfsUtil.saveText((VirtualFile)file, (String)text));
        } else {
            file = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(configFile);
        }
        AddFacesSupportUtil.write2WebXml(webFacet, file);
        return file;
    }

    public static void write2WebXml(@NotNull WebFacet webFacet, @NotNull VirtualFile file) {
        if (webFacet == null) {
            AddFacesSupportUtil.$$$reportNull$$$0(1);
        }
        if (file == null) {
            AddFacesSupportUtil.$$$reportNull$$$0(2);
        }
        DumbService.getInstance((Project)webFacet.getModule().getProject()).runWhenSmart(() -> {
            WebRoot webRoot = WebUtil.findParentWebRoot((VirtualFile)file, (List)webFacet.getWebRoots());
            if (webRoot != null) {
                String relativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)webRoot.getFile(), (char)'/');
                WebApp root = webFacet.getRoot();
                if (relativePath != null && root != null) {
                    AddFacesSupportUtil.patchWebXml(webFacet.getModule().getProject(), webRoot, relativePath, root);
                }
            }
        });
    }

    private static void patchWebXml(Project project, WebRoot webRoot, String relativePath, WebApp root) {
        WriteCommandAction.runWriteCommandAction((Project)project, () -> {
            PsiFile containingFile;
            String uri = webRoot.getURI();
            String path = DeploymentUtil.appendToPath((String)uri, (String)relativePath);
            if (!FACES_CONFIG_DEFAULT_RELATIVE_PATH.equals(path)) {
                ParamValue param = AddFacesSupportUtil.findOrCreateContextParam(root);
                String value = (String)param.getParamValue().getValue();
                if (StringUtil.isEmpty((String)value)) {
                    param.getParamValue().setValue((Object)path);
                } else if (!AddFacesSupportUtil.containsPath(value, path)) {
                    param.getParamValue().setValue((Object)(value + "," + path));
                }
            }
            if ((containingFile = root.getContainingFile()) != null && ReadonlyStatusHandler.ensureFilesWritable((Project)containingFile.getProject(), (VirtualFile[])new VirtualFile[]{containingFile.getVirtualFile()})) {
                AddFacesSupportUtil.addFacesServlet(root);
                AddFacesSupportUtil.addFacesMapping(root);
            }
        });
    }

    private static void addFacesMapping(WebApp root) {
        for (ServletMapping mapping : root.getServletMappings()) {
            if (!FACES_SERVLET.equals(mapping.getServletName().getStringValue())) continue;
            return;
        }
        for (String urlPattern : FACES_URL_PATTERNS) {
            ServletMapping mapping = root.addServletMapping();
            mapping.getServletName().setStringValue(FACES_SERVLET);
            mapping.addUrlPattern().setValue((Object)urlPattern);
        }
    }

    private static void addFacesServlet(WebApp root) {
        List servlets = root.getServlets();
        for (Servlet servlet : servlets) {
            if (!FACES_SERVLET.equals(servlet.getServletName().getValue())) continue;
            return;
        }
        Servlet servlet = root.addServlet();
        servlet.getServletName().setValue((Object)FACES_SERVLET);
        servlet.getServletClass().setStringValue(JAVAX_FACES_WEBAPP_FACES_SERVLET);
        servlet.getLoadOnStartup().setValue((Object)1);
    }

    private static boolean containsPath(String value, String path) {
        StringTokenizer tokenizer = new StringTokenizer(value, ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            if (!path.equals(token)) continue;
            return true;
        }
        return false;
    }

    private static ParamValue findOrCreateContextParam(WebApp root) {
        List list = root.getContextParams();
        for (ParamValue paramValue : list) {
            if (!"javax.faces.CONFIG_FILES".equals(paramValue.getParamName().getValue())) continue;
            return paramValue;
        }
        ParamValue paramValue = root.addContextParam();
        paramValue.getParamName().setValue((Object)"javax.faces.CONFIG_FILES");
        return paramValue;
    }

    @Nullable
    public static VirtualFile getDefaultDirectoryForFacesConfig(@NotNull Module module) {
        if (module == null) {
            AddFacesSupportUtil.$$$reportNull$$$0(3);
        }
        for (WebFacet webFacet : WebFacet.getInstances((Module)module)) {
            List webRoots = webFacet.getWebRoots();
            for (WebRoot webRoot : webRoots) {
                if (!webRoot.getURI().equals("/WEB-INF")) continue;
                return webRoot.getFile();
            }
            if (webRoots.isEmpty()) continue;
            return ((WebRoot)webRoots.get(0)).getFile();
        }
        return ProjectUtil.guessModuleDir((Module)module);
    }

    public static void createFacesConfigInWriteCommandAction(WebFacet webFacet, @Nullable String version, String configFilePath) {
        Project project = webFacet.getModule().getProject();
        WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])AddFacesSupportUtil.getWebXmlFile(webFacet)).run(() -> {
            try {
                AddFacesSupportUtil.createFacesConfig(webFacet, version, configFilePath);
            }
            catch (IOException e) {
                ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((Project)project, (String)e.getMessage(), (String)FacesBundle.message("error.cannot.create.faces.config.title", new Object[0])));
            }
        });
    }

    private static PsiFile[] getWebXmlFile(WebFacet webFacet) {
        PsiFile psiFile;
        ConfigFile deploymentDescriptor;
        if (webFacet != null && (deploymentDescriptor = webFacet.getWebXmlDescriptor()) != null && (psiFile = deploymentDescriptor.getPsiFile()) != null) {
            return new PsiFile[]{psiFile};
        }
        return PsiFile.EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFilePath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "webFacet";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        objectArray2[1] = "com/intellij/jsf/facet/AddFacesSupportUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createFacesConfig";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "write2WebXml";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getDefaultDirectoryForFacesConfig";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

