/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.facelets;

import com.intellij.ProjectTopics;
import com.intellij.jsf.JsfProjectComponent;
import com.intellij.jsf.facelets.lang.FaceletsFileViewProvider;
import com.intellij.jsf.utils.JsfCommonUtils;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.module.impl.ModuleEx;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.Function;
import com.intellij.util.messages.MessageBusConnection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class FaceletsManager
extends SimpleModificationTracker {
    private static final Key<CachedValue<Boolean>> KEY = new Key("faceletsEnabled");
    private final CachedValueProvider<Boolean> myCachedValueProvider = () -> {
        if (module.isDisposed()) {
            return null;
        }
        JsfProjectComponent component = JsfProjectComponent.getInstance(module.getProject());
        boolean value = false;
        switch (component.getState().faceletsSupport) {
            case AUTO: {
                value = JsfCommonUtils.isJsfSupported(module);
                break;
            }
            case ENABLED: {
                value = true;
                break;
            }
            case DISABLED: {
                value = false;
            }
        }
        return CachedValueProvider.Result.create((Object)value, (Object[])new Object[]{this, component});
    };

    public FaceletsManager(Module module) {
        ((ModuleEx)module).getDeprecatedModuleLevelMessageBus().connect().subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                FaceletsManager.this.doChange();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/jsf/facelets/FaceletsManager$1", "rootsChanged"));
            }
        });
        MessageBusConnection busConnection = module.getProject().getMessageBus().connect((Disposable)module);
        busConnection.subscribe(ProjectTopics.MODULES, (Object)new ModuleListener(){

            public void moduleAdded(@NotNull Project project, @NotNull Module module) {
                if (project == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (module == null) {
                    2.$$$reportNull$$$0(1);
                }
                FaceletsManager.this.doChange();
            }

            public void moduleRemoved(@NotNull Project project, @NotNull Module module) {
                if (project == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (module == null) {
                    2.$$$reportNull$$$0(3);
                }
                FaceletsManager.this.doChange();
            }

            public void modulesRenamed(@NotNull Project project, @NotNull List<? extends Module> modules, @NotNull Function<? super Module, String> oldNameProvider) {
                if (project == null) {
                    2.$$$reportNull$$$0(4);
                }
                if (modules == null) {
                    2.$$$reportNull$$$0(5);
                }
                if (oldNameProvider == null) {
                    2.$$$reportNull$$$0(6);
                }
                FaceletsManager.this.doChange();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "module";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "modules";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "oldNameProvider";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/jsf/facelets/FaceletsManager$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "moduleAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "moduleRemoved";
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "modulesRenamed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        busConnection.subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void enteredDumbMode() {
                FaceletsManager.this.doChange();
            }

            public void exitDumbMode() {
                FaceletsManager.this.doChange();
            }
        });
    }

    private void doChange() {
        this.incModificationCount();
    }

    public static boolean isFaceletFile(@NotNull PsiFile file) {
        if (file == null) {
            FaceletsManager.$$$reportNull$$$0(0);
        }
        return file.getViewProvider() instanceof FaceletsFileViewProvider;
    }

    public static boolean isFaceletsEnabled(Project project, VirtualFile file) {
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
        if (module == null || module.isDisposed()) {
            return false;
        }
        return FaceletsManager.isFaceletsEnabled(module);
    }

    public static boolean isFaceletsEnabled(Module module) {
        FaceletsManager manager = (FaceletsManager)((Object)module.getService(FaceletsManager.class));
        return (Boolean)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, KEY, manager.myCachedValueProvider, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/jsf/facelets/FaceletsManager", "isFaceletFile"));
    }
}

