/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.composite.references;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.jsf.composite.CompositeUtil;
import com.intellij.jsf.model.jam.JsfJamComponent;
import com.intellij.jsf.model.jam.JsfJamModel;
import com.intellij.jsf.references.JsfXmlAttributeReferencesProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.position.NamespaceFilter;
import com.intellij.psi.filters.position.ParentElementFilter;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CompositeComponentTypeReferenceProvider
extends JsfXmlAttributeReferencesProvider {
    private static final String COMPONENT_TYPE_ATTRIBUTE_NAME = "componentType";

    @Override
    public ElementFilter getElementFilter() {
        return new ParentElementFilter((ElementFilter)new NamespaceFilter(CompositeUtil.COMPOSITE_NAMESPACES), 2);
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{COMPONENT_TYPE_ATTRIBUTE_NAME};
    }

    @Override
    protected PsiReference[] createReferences(@NotNull XmlAttributeValue xmlAttributeValue, ProcessingContext context) {
        Module module;
        String componentType;
        if (xmlAttributeValue == null) {
            CompositeComponentTypeReferenceProvider.$$$reportNull$$$0(0);
        }
        if (!StringUtil.isEmptyOrSpaces((String)(componentType = xmlAttributeValue.getValue())) && (module = ModuleUtilCore.findModuleForPsiElement((PsiElement)xmlAttributeValue)) != null) {
            PsiReferenceBase<XmlAttributeValue> psiReference = new PsiReferenceBase<XmlAttributeValue>(xmlAttributeValue, true){

                public PsiElement resolve() {
                    List<JsfJamComponent> components = JsfJamModel.getModel(module).getComponents(true);
                    for (JsfJamComponent component : components) {
                        if (!componentType.equals(component.getComponentName())) continue;
                        return component.getIdentifyingPsiElement();
                    }
                    return null;
                }

                @NotNull
                public Object[] getVariants() {
                    HashSet<LookupElementBuilder> set = new HashSet<LookupElementBuilder>();
                    List<JsfJamComponent> components = JsfJamModel.getModel(module).getComponents(true);
                    for (JsfJamComponent component : components) {
                        String componentName = component.getComponentName();
                        if (StringUtil.isEmptyOrSpaces((String)componentName)) continue;
                        set.add(LookupElementBuilder.create((Object)component.getIdentifyingPsiElement(), (String)componentName));
                    }
                    Object[] objectArray = ArrayUtil.toObjectArray(set);
                    if (objectArray == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return objectArray;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/composite/references/CompositeComponentTypeReferenceProvider$1", "getVariants"));
                }
            };
            return new PsiReference[]{psiReference};
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlAttributeValue", "com/intellij/jsf/composite/references/CompositeComponentTypeReferenceProvider", "createReferences"));
    }
}

