/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.packaging.jlink;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.JpsBuildBundle;
import org.jetbrains.jps.builders.artifacts.ArtifactBuildTaskProvider;
import org.jetbrains.jps.incremental.BuildTask;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.artifact.JpsArtifact;
import org.jetbrains.jps.model.java.JpsJavaSdkType;
import org.jetbrains.jps.model.library.sdk.JpsSdk;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.jps.packaging.jlink.JpsJLinkArtifactType;
import org.jetbrains.jps.packaging.jlink.JpsJLinkProperties;

public final class JLinkArtifactBuildTaskProvider
extends ArtifactBuildTaskProvider {
    public static final String IMAGE_DIR_NAME = "jdk";

    @Override
    @NotNull
    public List<? extends BuildTask> createArtifactBuildTasks(@NotNull JpsArtifact artifact, @NotNull ArtifactBuildTaskProvider.ArtifactBuildPhase buildPhase) {
        if (artifact == null) {
            JLinkArtifactBuildTaskProvider.$$$reportNull$$$0(0);
        }
        if (buildPhase == null) {
            JLinkArtifactBuildTaskProvider.$$$reportNull$$$0(1);
        }
        if (buildPhase != ArtifactBuildTaskProvider.ArtifactBuildPhase.POST_PROCESSING || !(artifact.getArtifactType() instanceof JpsJLinkArtifactType)) {
            List list = Collections.emptyList();
            if (list == null) {
                JLinkArtifactBuildTaskProvider.$$$reportNull$$$0(2);
            }
            return list;
        }
        JpsElement properties = artifact.getProperties();
        if (!(properties instanceof JpsJLinkProperties)) {
            List list = Collections.emptyList();
            if (list == null) {
                JLinkArtifactBuildTaskProvider.$$$reportNull$$$0(3);
            }
            return list;
        }
        List<JLinkBuildTask> list = Collections.singletonList(new JLinkBuildTask(artifact));
        if (list == null) {
            JLinkArtifactBuildTaskProvider.$$$reportNull$$$0(4);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildPhase";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/packaging/jlink/JLinkArtifactBuildTaskProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/packaging/jlink/JLinkArtifactBuildTaskProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createArtifactBuildTasks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createArtifactBuildTasks";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class JLinkBuildTask
    extends BuildTask {
        private static final Logger LOG = Logger.getInstance(JLinkBuildTask.class);
        private final JpsArtifact myArtifact;

        private JLinkBuildTask(@NotNull JpsArtifact artifact) {
            if (artifact == null) {
                JLinkBuildTask.$$$reportNull$$$0(0);
            }
            this.myArtifact = artifact;
        }

        @Override
        public void build(@NotNull CompileContext context) throws ProjectBuildException {
            if (context == null) {
                JLinkBuildTask.$$$reportNull$$$0(1);
            }
            LOG.info("jlink task was started");
            JpsSdk<?> javaSdk = JLinkBuildTask.findValidSdk(context);
            if (javaSdk == null) {
                JLinkBuildTask.error(context, JpsBuildBundle.message("packaging.jlink.build.task.wrong.java.version", new Object[0]));
                return;
            }
            JpsJLinkProperties properties = (JpsJLinkProperties)this.myArtifact.getProperties();
            String artifactOutputPath = this.myArtifact.getOutputPath();
            if (artifactOutputPath == null) {
                JLinkBuildTask.error(context, JpsBuildBundle.message("packaging.jlink.build.task.unknown.artifact.path", new Object[0]));
                return;
            }
            Path runtimeImagePath = Paths.get(artifactOutputPath, JLinkArtifactBuildTaskProvider.IMAGE_DIR_NAME);
            List<String> commands = JLinkBuildTask.buildCommands(context, properties, javaSdk, artifactOutputPath, runtimeImagePath);
            if (commands.isEmpty()) {
                return;
            }
            try {
                FileUtil.delete((Path)runtimeImagePath);
            }
            catch (IOException e) {
                JLinkBuildTask.error(context, JpsBuildBundle.message("packaging.jlink.build.task.run.time.image.deletion.failure", new Object[0]));
                return;
            }
            int errorCode = JLinkBuildTask.startProcess(context, commands, properties);
            if (errorCode != 0) {
                JLinkBuildTask.error(context, JpsBuildBundle.message("packaging.jlink.build.task.failure", new Object[0]));
                return;
            }
            LOG.info("jlink task was finished");
        }

        @Nullable
        private static JpsSdk<?> findValidSdk(@NotNull CompileContext context) {
            if (context == null) {
                JLinkBuildTask.$$$reportNull$$$0(2);
            }
            Set<JpsSdk<?>> sdks = context.getProjectDescriptor().getProjectJavaSdks();
            JpsSdk<?> javaSdk = null;
            for (JpsSdk<?> sdk : sdks) {
                JpsSdkType sdkType = sdk.getSdkType();
                if (!(sdkType instanceof JpsJavaSdkType) || JpsJavaSdkType.getJavaVersion(sdk) < 9) continue;
                javaSdk = sdk;
                break;
            }
            return javaSdk;
        }

        @NotNull
        private static List<String> buildCommands(@NotNull CompileContext context, @NotNull JpsJLinkProperties properties, @NotNull JpsSdk<?> javaSdk, @NotNull String artifactOutputPath, @NotNull Path runtimeImagePath) {
            String modulesSequence;
            if (context == null) {
                JLinkBuildTask.$$$reportNull$$$0(3);
            }
            if (properties == null) {
                JLinkBuildTask.$$$reportNull$$$0(4);
            }
            if (javaSdk == null) {
                JLinkBuildTask.$$$reportNull$$$0(5);
            }
            if (artifactOutputPath == null) {
                JLinkBuildTask.$$$reportNull$$$0(6);
            }
            if (runtimeImagePath == null) {
                JLinkBuildTask.$$$reportNull$$$0(7);
            }
            if (StringUtil.isEmpty((String)(modulesSequence = JLinkBuildTask.getModulesSequence(artifactOutputPath)))) {
                JLinkBuildTask.error(context, JpsBuildBundle.message("packaging.jlink.build.task.modules.not.found", new Object[0]));
                List<String> list = Collections.emptyList();
                if (list == null) {
                    JLinkBuildTask.$$$reportNull$$$0(8);
                }
                return list;
            }
            String sdkHomePath = javaSdk.getHomePath();
            String jLinkPath = Paths.get(sdkHomePath, "bin", "jlink").toString();
            ArrayList<String> commands = new ArrayList<String>();
            commands.add(jLinkPath);
            if (properties.compressionLevel != null && properties.compressionLevel.hasCompression()) {
                JLinkBuildTask.addOption(commands, "--compress", String.valueOf(properties.compressionLevel.myValue));
            }
            if (properties.verbose) {
                commands.add("--verbose");
            }
            commands.add("--module-path");
            commands.add(String.join((CharSequence)File.pathSeparator, artifactOutputPath, Paths.get(sdkHomePath, "jmods").toString()));
            commands.add("--add-modules");
            commands.add(modulesSequence);
            JLinkBuildTask.addOption(commands, "--output", runtimeImagePath.toString());
            LOG.info(String.join((CharSequence)" ", commands));
            ArrayList<String> arrayList = commands;
            if (arrayList == null) {
                JLinkBuildTask.$$$reportNull$$$0(9);
            }
            return arrayList;
        }

        @Nullable
        private static String getModulesSequence(@NotNull String artifactOutputPath) {
            Method name;
            Method descriptor;
            Object allRefs;
            Method findAll;
            Object finder;
            Method of;
            if (artifactOutputPath == null) {
                JLinkBuildTask.$$$reportNull$$$0(10);
            }
            try {
                of = Class.forName("java.lang.module.ModuleFinder").getMethod("of", Path[].class);
            }
            catch (ClassNotFoundException | NoSuchMethodException e) {
                LOG.error("Couldn't get java.lang.module.ModuleFinder#of method");
                return null;
            }
            try {
                finder = of.invoke(null, new Object[]{new Path[]{Paths.get(artifactOutputPath, new String[0])}});
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                LOG.error("Couldn't call java.lang.module.ModuleFinder#of method");
                return null;
            }
            try {
                findAll = Class.forName("java.lang.module.ModuleFinder").getMethod("findAll", new Class[0]);
            }
            catch (ClassNotFoundException | NoSuchMethodException e) {
                LOG.error("Couldn't get java.lang.module.ModuleFinder#findAll method");
                return null;
            }
            try {
                allRefs = findAll.invoke(finder, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                LOG.error("Couldn't call java.lang.module.ModuleFinder#findAll method");
                return null;
            }
            Set moduleRefs = (Set)allRefs;
            if (moduleRefs.isEmpty()) {
                return null;
            }
            try {
                descriptor = Class.forName("java.lang.module.ModuleReference").getMethod("descriptor", new Class[0]);
            }
            catch (ClassNotFoundException | NoSuchMethodException e) {
                LOG.error("Couldn't get java.lang.module.ModuleReference#descriptor method");
                return null;
            }
            try {
                name = Class.forName("java.lang.module.ModuleDescriptor").getMethod("name", new Class[0]);
            }
            catch (ClassNotFoundException | NoSuchMethodException e) {
                LOG.error("Couldn't get java.lang.module.ModuleDescriptor#name method");
                return null;
            }
            StringJoiner result = new StringJoiner(",");
            try {
                for (Object moduleRef : moduleRefs) {
                    String moduleName = (String)ObjectUtils.tryCast((Object)name.invoke(descriptor.invoke(moduleRef, new Object[0]), new Object[0]), String.class);
                    if (moduleName == null) {
                        return null;
                    }
                    result.add(moduleName);
                }
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                LOG.error("Couldn't call java.lang.module.ModuleReference#descriptor or name method");
                return null;
            }
            return result.toString();
        }

        private static int startProcess(final @NotNull CompileContext context, @NotNull List<String> commands, final @NotNull JpsJLinkProperties properties) {
            if (context == null) {
                JLinkBuildTask.$$$reportNull$$$0(11);
            }
            if (commands == null) {
                JLinkBuildTask.$$$reportNull$$$0(12);
            }
            if (properties == null) {
                JLinkBuildTask.$$$reportNull$$$0(13);
            }
            try {
                final AtomicInteger exitCode = new AtomicInteger();
                final @NlsSafe StringBuilder errorOutput = new StringBuilder();
                final ArrayList<@NlsSafe E> delayedInfoOutput = new ArrayList();
                Process process = new ProcessBuilder(CommandLineUtil.toCommandLine(commands)).start();
                BaseOSProcessHandler handler = new BaseOSProcessHandler(process, commands.toString(), null);
                handler.addProcessListener((ProcessListener)new ProcessAdapter(){

                    public void processTerminated(@NotNull ProcessEvent event) {
                        if (event == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        exitCode.set(event.getExitCode());
                    }

                    public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                        if (event == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (outputType == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        String message = StringUtil.trimTrailing((String)event.getText());
                        if (outputType == ProcessOutputTypes.STDERR) {
                            errorOutput.append(event.getText());
                        } else if (properties.verbose) {
                            JLinkBuildTask.info(context, message);
                        } else {
                            delayedInfoOutput.add(message);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "event";
                                break;
                            }
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "outputType";
                                break;
                            }
                        }
                        objectArray2[1] = "org/jetbrains/jps/packaging/jlink/JLinkArtifactBuildTaskProvider$JLinkBuildTask$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "processTerminated";
                                break;
                            }
                            case 1: 
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[2] = "onTextAvailable";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
                handler.startNotify();
                handler.waitFor();
                int result = exitCode.get();
                if (result != 0) {
                    String message = errorOutput.toString();
                    if (!StringUtil.isEmptyOrSpaces((String)message)) {
                        JLinkBuildTask.error(context, message);
                    }
                    for (String info : delayedInfoOutput) {
                        JLinkBuildTask.error(context, info);
                    }
                }
                return result;
            }
            catch (Throwable e) {
                JLinkBuildTask.error(context, e.getMessage());
                LOG.error(e);
                return -1;
            }
        }

        private static void addOption(List<String> commands, @NotNull String key, @Nullable String value) {
            if (key == null) {
                JLinkBuildTask.$$$reportNull$$$0(14);
            }
            if (!StringUtil.isEmpty((String)value)) {
                commands.add(key);
                commands.add(value);
            }
        }

        private static void error(@NotNull CompileContext compileContext, @Nls String message) {
            if (compileContext == null) {
                JLinkBuildTask.$$$reportNull$$$0(15);
            }
            compileContext.processMessage(new CompilerMessage("jlink", BuildMessage.Kind.ERROR, message));
        }

        private static void info(@NotNull CompileContext compileContext, @Nls String message) {
            if (compileContext == null) {
                JLinkBuildTask.$$$reportNull$$$0(16);
            }
            compileContext.processMessage(new CompilerMessage("jlink", BuildMessage.Kind.INFO, message));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 8: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 8: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "artifact";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 4: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "properties";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "javaSdk";
                    break;
                }
                case 6: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "artifactOutputPath";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runtimeImagePath";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/jps/packaging/jlink/JLinkArtifactBuildTaskProvider$JLinkBuildTask";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commands";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 15: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "compileContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/jps/packaging/jlink/JLinkArtifactBuildTaskProvider$JLinkBuildTask";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "buildCommands";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "build";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "findValidSdk";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "buildCommands";
                    break;
                }
                case 8: 
                case 9: {
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "getModulesSequence";
                    break;
                }
                case 11: 
                case 12: 
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "startProcess";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "addOption";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "error";
                    break;
                }
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "info";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 8: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

