/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.messages;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TObjectIntHashMap;
import gnu.trove.TObjectLongHashMap;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;
import org.jetbrains.jps.FreezeDetector;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetIndex;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.builders.impl.BuildTargetChunk;
import org.jetbrains.jps.incremental.BuilderRegistry;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.FSOperations;
import org.jetbrains.jps.incremental.Utils;
import org.jetbrains.jps.incremental.storage.BuildDataManager;
import org.jetbrains.jps.incremental.storage.BuildTargetsState;
import org.jetbrains.jps.service.SharedThreadPool;

public class BuildProgress {
    private static final Logger LOG = Logger.getInstance(BuildProgress.class);
    private final BuildDataManager myDataManager;
    private final BuildTargetIndex myTargetIndex;
    private final TObjectIntHashMap<BuildTargetType<?>> myNumberOfFinishedTargets = new TObjectIntHashMap();
    private final TObjectLongHashMap<BuildTargetType<?>> myExpectedBuildTimeForTarget = new TObjectLongHashMap();
    private final long myExpectedTotalTime;
    private final Map<BuildTarget, Double> myCurrentProgress = new HashMap<BuildTarget, Double>();
    private long myExpectedTimeForFinishedTargets;
    private long myAbsoluteBuildTime;
    private final TObjectIntHashMap<BuildTargetType<?>> myTotalTargets = new TObjectIntHashMap();
    private final TObjectLongHashMap<BuildTargetType<?>> myTotalBuildTimeForFullyRebuiltTargets = new TObjectLongHashMap();
    private final TObjectIntHashMap<BuildTargetType<?>> myNumberOfFullyRebuiltTargets = new TObjectIntHashMap();
    private final FreezeDetector myFreezeDetector;

    public BuildProgress(BuildDataManager dataManager, BuildTargetIndex targetIndex, List<BuildTargetChunk> allChunks, Predicate<? super BuildTargetChunk> isAffected) {
        this.myDataManager = dataManager;
        this.myTargetIndex = targetIndex;
        LinkedHashSet targetTypes = new LinkedHashSet();
        TObjectIntHashMap totalAffectedTargets = new TObjectIntHashMap();
        for (BuildTargetChunk chunk : allChunks) {
            boolean affected = isAffected.test(chunk);
            for (BuildTarget<?> target : chunk.getTargets()) {
                if (this.myTargetIndex.isDummy(target)) continue;
                if (affected) {
                    BuildProgress.increment(totalAffectedTargets, target.getTargetType());
                    targetTypes.add(target.getTargetType());
                }
                BuildProgress.increment(this.myTotalTargets, target.getTargetType());
            }
        }
        long expectedTotalTime = 0L;
        for (BuildTargetType buildTargetType : targetTypes) {
            this.myExpectedBuildTimeForTarget.put((Object)buildTargetType, this.myDataManager.getTargetsState().getAverageBuildTime(buildTargetType));
        }
        for (BuildTargetType buildTargetType : targetTypes) {
            if (this.myExpectedBuildTimeForTarget.get((Object)buildTargetType) != -1L) continue;
            this.myExpectedBuildTimeForTarget.put((Object)buildTargetType, BuildProgress.computeExpectedTimeBasedOnOtherTargets(buildTargetType, targetTypes, this.myExpectedBuildTimeForTarget));
        }
        for (BuildTargetType buildTargetType : targetTypes) {
            expectedTotalTime += this.myExpectedBuildTimeForTarget.get((Object)buildTargetType) * (long)totalAffectedTargets.get((Object)buildTargetType);
        }
        this.myExpectedTotalTime = Math.max(expectedTotalTime, 1L);
        this.myFreezeDetector = new FreezeDetector((ExecutorService)SharedThreadPool.getInstance());
        if (LOG.isDebugEnabled()) {
            LOG.debug("expected total time is " + this.myExpectedTotalTime);
            for (BuildTargetType buildTargetType : targetTypes) {
                LOG.debug(" expected build time for " + buildTargetType.getTypeId() + " is " + this.myExpectedBuildTimeForTarget.get((Object)buildTargetType));
            }
        }
    }

    private static long computeExpectedTimeBasedOnOtherTargets(BuildTargetType<?> type, Set<? extends BuildTargetType<?>> allTypes, TObjectLongHashMap<BuildTargetType<?>> expectedBuildTimeForTarget) {
        BuilderRegistry registry = BuilderRegistry.getInstance();
        int baseTargetsCount = 0;
        long expectedTimeSum = 0L;
        for (BuildTargetType<?> anotherType : allTypes) {
            long realExpectedTime = expectedBuildTimeForTarget.get(anotherType);
            long defaultExpectedTime = registry.getExpectedBuildTimeForTarget(anotherType);
            if (realExpectedTime == -1L || defaultExpectedTime <= 0L) continue;
            ++baseTargetsCount;
            expectedTimeSum += realExpectedTime * registry.getExpectedBuildTimeForTarget(type) / defaultExpectedTime;
        }
        return baseTargetsCount != 0 ? expectedTimeSum / (long)baseTargetsCount : registry.getExpectedBuildTimeForTarget(type);
    }

    private synchronized void notifyAboutTotalProgress(CompileContext context) {
        long expectedTimeForFinishedWork = this.myExpectedTimeForFinishedTargets;
        for (Map.Entry<BuildTarget, Double> entry : this.myCurrentProgress.entrySet()) {
            expectedTimeForFinishedWork = (long)((double)expectedTimeForFinishedWork + (double)this.myExpectedBuildTimeForTarget.get(entry.getKey().getTargetType()) * entry.getValue());
        }
        float done = (float)expectedTimeForFinishedWork / (float)this.myExpectedTotalTime;
        context.setDone(done);
    }

    public synchronized void updateProgress(BuildTarget target, double done, CompileContext context) {
        this.myCurrentProgress.put(target, done);
        this.notifyAboutTotalProgress(context);
    }

    public synchronized void onTargetChunkFinished(BuildTargetChunk chunk, CompileContext context) {
        boolean successful = !Utils.errorsDetected(context) && !context.getCancelStatus().isCanceled();
        int nonDummyTargetsCount = ContainerUtil.count(chunk.getTargets(), it -> !this.myTargetIndex.isDummy((BuildTarget<?>)it));
        for (BuildTarget<?> target : chunk.getTargets()) {
            this.myCurrentProgress.remove(target);
            if (this.myTargetIndex.isDummy(target)) continue;
            BuildTargetType<BuildTarget<?>> targetType = target.getTargetType();
            BuildProgress.increment(this.myNumberOfFinishedTargets, targetType);
            this.myExpectedTimeForFinishedTargets += this.myExpectedBuildTimeForTarget.get(targetType);
            long elapsedTime = this.myFreezeDetector.getAdjustedDuration(context.getCompilationStartStamp(target), System.currentTimeMillis());
            this.myAbsoluteBuildTime += elapsedTime;
            if (!successful || !FSOperations.isMarkedDirty(context, target)) continue;
            long buildTime = elapsedTime / (long)nonDummyTargetsCount;
            if (!this.myTotalBuildTimeForFullyRebuiltTargets.adjustValue(targetType, buildTime)) {
                this.myTotalBuildTimeForFullyRebuiltTargets.put(targetType, buildTime);
            }
            BuildProgress.increment(this.myNumberOfFullyRebuiltTargets, targetType);
        }
        this.notifyAboutTotalProgress(context);
    }

    public void updateExpectedAverageTime() {
        this.myFreezeDetector.stop();
        if (LOG.isDebugEnabled()) {
            LOG.debug("update expected build time for " + this.myTotalBuildTimeForFullyRebuiltTargets.size() + " target types");
        }
        this.myTotalBuildTimeForFullyRebuiltTargets.forEachEntry((type, totalTime) -> {
            BuildTargetsState targetsState = this.myDataManager.getTargetsState();
            long oldAverageTime = targetsState.getAverageBuildTime((BuildTargetType<?>)type);
            long newAverageTime = oldAverageTime == -1L ? totalTime / (long)this.myNumberOfFullyRebuiltTargets.get(type) : (totalTime + (long)(this.myTotalTargets.get(type) - this.myNumberOfFullyRebuiltTargets.get(type)) * oldAverageTime) / (long)this.myTotalTargets.get(type);
            if (LOG.isDebugEnabled()) {
                LOG.debug(" " + type.getTypeId() + ": old=" + oldAverageTime + ", new=" + newAverageTime + " (based on " + this.myNumberOfFullyRebuiltTargets.get(type) + " of " + this.myTotalTargets.get(type) + " targets)");
            }
            targetsState.setAverageBuildTime((BuildTargetType<?>)type, newAverageTime);
            return true;
        });
    }

    public synchronized long getAbsoluteBuildTime() {
        return this.myAbsoluteBuildTime;
    }

    private static <T> void increment(TObjectIntHashMap<T> map, T key) {
        if (!map.increment(key)) {
            map.put(key, 1);
        }
    }
}

