/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.artifacts;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import gnu.trove.TIntObjectHashMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildOutputConsumer;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.FileProcessor;
import org.jetbrains.jps.builders.JpsBuildBundle;
import org.jetbrains.jps.builders.artifacts.ArtifactBuildTaskProvider;
import org.jetbrains.jps.builders.artifacts.impl.ArtifactOutToSourceStorageProvider;
import org.jetbrains.jps.builders.logging.ProjectBuilderLogger;
import org.jetbrains.jps.builders.storage.SourceToOutputMapping;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.BuildOperations;
import org.jetbrains.jps.incremental.BuildTask;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.TargetBuilder;
import org.jetbrains.jps.incremental.artifacts.ArtifactBuildTarget;
import org.jetbrains.jps.incremental.artifacts.ArtifactBuildTargetType;
import org.jetbrains.jps.incremental.artifacts.ArtifactOutputToSourceMapping;
import org.jetbrains.jps.incremental.artifacts.impl.ArtifactSorter;
import org.jetbrains.jps.incremental.artifacts.impl.JarsBuilder;
import org.jetbrains.jps.incremental.artifacts.instructions.ArtifactRootDescriptor;
import org.jetbrains.jps.incremental.artifacts.instructions.DestinationInfo;
import org.jetbrains.jps.incremental.artifacts.instructions.ExplodedDestinationInfo;
import org.jetbrains.jps.incremental.artifacts.instructions.JarDestinationInfo;
import org.jetbrains.jps.incremental.artifacts.instructions.JarInfo;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.incremental.messages.ProgressMessage;
import org.jetbrains.jps.model.artifact.JpsArtifact;
import org.jetbrains.jps.service.JpsServiceManager;

public class IncArtifactBuilder
extends TargetBuilder<ArtifactRootDescriptor, ArtifactBuildTarget> {
    private static final Logger LOG = Logger.getInstance(IncArtifactBuilder.class);
    public static final String BUILDER_ID = "artifacts-builder";

    public IncArtifactBuilder() {
        super(Collections.singletonList(ArtifactBuildTargetType.INSTANCE));
    }

    @Override
    public void build(@NotNull ArtifactBuildTarget target, @NotNull DirtyFilesHolder<ArtifactRootDescriptor, ArtifactBuildTarget> holder, @NotNull BuildOutputConsumer outputConsumer, @NotNull CompileContext context) throws ProjectBuildException {
        if (target == null) {
            IncArtifactBuilder.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            IncArtifactBuilder.$$$reportNull$$$0(1);
        }
        if (outputConsumer == null) {
            IncArtifactBuilder.$$$reportNull$$$0(2);
        }
        if (context == null) {
            IncArtifactBuilder.$$$reportNull$$$0(3);
        }
        List<BuildTask> preprocessingTasks = IncArtifactBuilder.createArtifactTasks(target.getArtifact(), ArtifactBuildTaskProvider.ArtifactBuildPhase.PRE_PROCESSING);
        try {
            if (!holder.hasRemovedFiles() && !holder.hasDirtyFiles() && preprocessingTasks.isEmpty()) {
                return;
            }
        }
        catch (IOException e) {
            throw new ProjectBuildException(e);
        }
        JpsArtifact artifact = target.getArtifact();
        String outputFilePath = artifact.getOutputFilePath();
        if (StringUtil.isEmpty((String)outputFilePath)) {
            context.processMessage(new CompilerMessage(IncArtifactBuilder.getBuilderName(), BuildMessage.Kind.ERROR, JpsBuildBundle.message("build.message.cannot.build.0.artifact.output.path.is.not.specified", artifact.getName())));
            return;
        }
        ProjectDescriptor pd = context.getProjectDescriptor();
        ArtifactSorter sorter = new ArtifactSorter(pd.getModel());
        Map<JpsArtifact, JpsArtifact> selfIncludingNameMap = sorter.getArtifactToSelfIncludingNameMap();
        JpsArtifact selfIncluding = selfIncludingNameMap.get(artifact);
        if (selfIncluding != null) {
            context.processMessage(new CompilerMessage(IncArtifactBuilder.getBuilderName(), BuildMessage.Kind.ERROR, JpsBuildBundle.message("build.message.cannot.build.0.artifact.it.includes.itself", artifact.getName(), selfIncluding.getName(), selfIncluding.equals(artifact) ? 0 : 1)));
            return;
        }
        try {
            final Collection<String> deletedFiles = holder.getRemovedFiles(target);
            String messageText = JpsBuildBundle.message("progress.message.building.artifact.0", artifact.getName());
            context.processMessage(new ProgressMessage(messageText));
            LOG.debug(messageText);
            IncArtifactBuilder.runArtifactTasks(preprocessingTasks, target.getArtifact(), context, ArtifactBuildTaskProvider.ArtifactBuildPhase.PRE_PROCESSING);
            final SourceToOutputMapping srcOutMapping = pd.dataManager.getSourceToOutputMap(target);
            ArtifactOutputToSourceMapping outSrcMapping = pd.dataManager.getStorage(target, ArtifactOutToSourceStorageProvider.INSTANCE);
            final TIntObjectHashMap filesToProcess = new TIntObjectHashMap();
            MultiMap filesToDelete = new MultiMap();
            THashSet deletedOutputPaths = new THashSet(FileUtil.PATH_HASHING_STRATEGY);
            for (String string : deletedFiles) {
                Collection<String> outputPaths = srcOutMapping.getOutputs(string);
                if (outputPaths == null) continue;
                for (String outputPath : outputPaths) {
                    if (!deletedOutputPaths.add(outputPath)) continue;
                    IncArtifactBuilder.collectSourcesCorrespondingToOutput(outputPath, string, deletedFiles, outSrcMapping, (TIntObjectHashMap<Set<String>>)filesToProcess, (MultiMap<String, String>)filesToDelete);
                }
            }
            THashSet changedOutputPaths = new THashSet(FileUtil.PATH_HASHING_STRATEGY);
            holder.processDirtyFiles(new FileProcessor<ArtifactRootDescriptor, ArtifactBuildTarget>((Set)changedOutputPaths, outSrcMapping, filesToDelete){
                final /* synthetic */ Set val$changedOutputPaths;
                final /* synthetic */ ArtifactOutputToSourceMapping val$outSrcMapping;
                final /* synthetic */ MultiMap val$filesToDelete;
                {
                    this.val$changedOutputPaths = set;
                    this.val$outSrcMapping = artifactOutputToSourceMapping;
                    this.val$filesToDelete = multiMap;
                }

                @Override
                public boolean apply(ArtifactBuildTarget target, File file, ArtifactRootDescriptor root) throws IOException {
                    int rootIndex = root.getRootIndex();
                    String sourcePath = FileUtil.toSystemIndependentName((String)file.getPath());
                    IncArtifactBuilder.addFileToProcess((TIntObjectHashMap<Set<String>>)filesToProcess, rootIndex, sourcePath, deletedFiles);
                    Collection<String> outputPaths = srcOutMapping.getOutputs(sourcePath);
                    if (outputPaths != null) {
                        for (String outputPath : outputPaths) {
                            if (!this.val$changedOutputPaths.add(outputPath)) continue;
                            IncArtifactBuilder.collectSourcesCorrespondingToOutput(outputPath, sourcePath, deletedFiles, this.val$outSrcMapping, (TIntObjectHashMap<Set<String>>)filesToProcess, (MultiMap<String, String>)this.val$filesToDelete);
                        }
                    }
                    return true;
                }
            });
            BuildOperations.cleanOutputsCorrespondingToChangedFiles(context, holder);
            for (Object outputPath : changedOutputPaths) {
                outSrcMapping.remove((String)outputPath);
            }
            if (filesToDelete.isEmpty() && filesToProcess.isEmpty()) {
                return;
            }
            IncArtifactBuilder.deleteOutdatedFiles((MultiMap<String, String>)filesToDelete, context, srcOutMapping, outSrcMapping);
            context.checkCanceled();
            context.processMessage(new ProgressMessage(JpsBuildBundle.message("progress.message.building.artifact.0.copying.files", artifact.getName())));
            HashSet<JarInfo> hashSet = new HashSet<JarInfo>();
            for (ArtifactRootDescriptor descriptor : pd.getBuildRootIndex().getTargetRoots(target, context)) {
                context.checkCanceled();
                Set sourcePaths = (Set)filesToProcess.get(descriptor.getRootIndex());
                if (sourcePaths == null) continue;
                for (String sourcePath : sourcePaths) {
                    if (!descriptor.getFilter().shouldBeCopied(sourcePath, pd)) {
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("File " + sourcePath + " will be skipped because it isn't accepted by filter");
                        continue;
                    }
                    DestinationInfo destination = descriptor.getDestinationInfo();
                    if (destination instanceof ExplodedDestinationInfo) {
                        descriptor.copyFromRoot(sourcePath, descriptor.getRootIndex(), destination.getOutputPath(), context, outputConsumer, outSrcMapping);
                        continue;
                    }
                    List<ArtifactOutputToSourceMapping.SourcePathAndRootIndex> sources = outSrcMapping.getState(destination.getOutputFilePath());
                    if (sources != null && (sources.size() <= 0 || sources.get(0).getRootIndex() != descriptor.getRootIndex())) continue;
                    outSrcMapping.update(destination.getOutputFilePath(), Collections.emptyList());
                    hashSet.add(((JarDestinationInfo)destination).getJarInfo());
                }
            }
            context.checkCanceled();
            JarsBuilder builder = new JarsBuilder(hashSet, context, outputConsumer, outSrcMapping);
            builder.buildJars();
            IncArtifactBuilder.runArtifactTasks(IncArtifactBuilder.createArtifactTasks(artifact, ArtifactBuildTaskProvider.ArtifactBuildPhase.FINISHING_BUILD), artifact, context, ArtifactBuildTaskProvider.ArtifactBuildPhase.FINISHING_BUILD);
            IncArtifactBuilder.runArtifactTasks(IncArtifactBuilder.createArtifactTasks(artifact, ArtifactBuildTaskProvider.ArtifactBuildPhase.POST_PROCESSING), artifact, context, ArtifactBuildTaskProvider.ArtifactBuildPhase.POST_PROCESSING);
        }
        catch (IOException e) {
            throw new ProjectBuildException(e);
        }
    }

    private static void collectSourcesCorrespondingToOutput(String outputPath, String sourcePath, Collection<String> deletedFiles, ArtifactOutputToSourceMapping outSrcMapping, TIntObjectHashMap<Set<String>> filesToProcess, MultiMap<String, String> filesToDelete) throws IOException {
        filesToDelete.putValue((Object)outputPath, (Object)sourcePath);
        List<ArtifactOutputToSourceMapping.SourcePathAndRootIndex> sources = outSrcMapping.getState(outputPath);
        if (sources != null) {
            for (ArtifactOutputToSourceMapping.SourcePathAndRootIndex source : sources) {
                IncArtifactBuilder.addFileToProcess(filesToProcess, source.getRootIndex(), source.getPath(), deletedFiles);
            }
        }
    }

    private static List<BuildTask> createArtifactTasks(JpsArtifact artifact, ArtifactBuildTaskProvider.ArtifactBuildPhase phase) {
        ArrayList<BuildTask> result = new ArrayList<BuildTask>();
        for (ArtifactBuildTaskProvider provider : JpsServiceManager.getInstance().getExtensions(ArtifactBuildTaskProvider.class)) {
            result.addAll(provider.createArtifactBuildTasks(artifact, phase));
        }
        return result;
    }

    private static void runArtifactTasks(List<BuildTask> tasks, JpsArtifact artifact, CompileContext context, ArtifactBuildTaskProvider.ArtifactBuildPhase phase) throws ProjectBuildException {
        if (!tasks.isEmpty()) {
            context.processMessage(new ProgressMessage(JpsBuildBundle.message("progress.message.running.0.tasks.for.1.artifact", phase.ordinal(), artifact.getName())));
            for (BuildTask task : tasks) {
                task.build(context);
            }
        }
    }

    private static void addFileToProcess(TIntObjectHashMap<Set<String>> filesToProcess, int rootIndex, String path, Collection<String> deletedFiles) {
        if (deletedFiles.contains(path)) {
            return;
        }
        Set paths = (Set)filesToProcess.get(rootIndex);
        if (paths == null) {
            paths = new THashSet(FileUtil.PATH_HASHING_STRATEGY);
            filesToProcess.put(rootIndex, (Object)paths);
        }
        paths.add(path);
    }

    private static void deleteOutdatedFiles(MultiMap<String, String> filesToDelete, CompileContext context, SourceToOutputMapping srcOutMapping, ArtifactOutputToSourceMapping outSrcMapping) throws IOException {
        ProjectBuilderLogger logger;
        if (filesToDelete.isEmpty()) {
            return;
        }
        context.processMessage(new ProgressMessage(JpsBuildBundle.message("progress.message.deleting.outdated.files", new Object[0])));
        int notDeletedFilesCount = 0;
        THashSet notDeletedPaths = new THashSet(FileUtil.PATH_HASHING_STRATEGY);
        THashSet deletedPaths = new THashSet(FileUtil.PATH_HASHING_STRATEGY);
        for (String filePath : filesToDelete.keySet()) {
            if (notDeletedPaths.contains((Object)filePath)) continue;
            boolean deleted = deletedPaths.contains((Object)filePath);
            if (!deleted) {
                deleted = FileUtil.delete((File)new File(filePath));
            }
            if (deleted) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Outdated output file deleted: " + filePath);
                }
                outSrcMapping.remove(filePath);
                deletedPaths.add((Object)filePath);
                for (String sourcePath : filesToDelete.get((Object)filePath)) {
                    srcOutMapping.removeOutput(sourcePath, filePath);
                }
                continue;
            }
            notDeletedPaths.add((Object)filePath);
            if (notDeletedFilesCount++ > 50) {
                context.processMessage(new CompilerMessage(IncArtifactBuilder.getBuilderName(), BuildMessage.Kind.WARNING, JpsBuildBundle.message("build.message.deletion.of.outdated.files.stopped", new Object[0])));
                break;
            }
            context.processMessage(new CompilerMessage(IncArtifactBuilder.getBuilderName(), BuildMessage.Kind.WARNING, JpsBuildBundle.message("build.message.cannot.delete.file.0", filePath)));
        }
        if ((logger = context.getLoggingManager().getProjectBuilderLogger()).isEnabled()) {
            logger.logDeletedFiles((Collection<String>)deletedPaths);
        }
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = IncArtifactBuilder.getBuilderName();
        if (string == null) {
            IncArtifactBuilder.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nls
    public static String getBuilderName() {
        return JpsBuildBundle.message("builder.name.artifacts.builder", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputConsumer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/incremental/artifacts/IncArtifactBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/incremental/artifacts/IncArtifactBuilder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

