/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FileCollectionFactory;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileSystemLoopException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.BuildRootIndex;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.FileProcessor;
import org.jetbrains.jps.builders.impl.BuildTargetChunk;
import org.jetbrains.jps.builders.java.JavaBuilderUtil;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.GlobalContextKey;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.fs.CompilationRound;
import org.jetbrains.jps.incremental.storage.StampsStorage;
import org.jetbrains.jps.model.java.JpsJavaClasspathKind;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.module.JpsModule;

public final class FSOperations {
    private static final Logger LOG = Logger.getInstance(FSOperations.class);
    public static final GlobalContextKey<Set<File>> ALL_OUTPUTS_KEY = GlobalContextKey.create("_all_project_output_dirs_");
    private static final GlobalContextKey<Set<BuildTarget<?>>> TARGETS_COMPLETELY_MARKED_DIRTY = GlobalContextKey.create("_targets_completely_marked_dirty_");

    public static boolean isMarkedDirty(CompileContext context, CompilationRound round, File file) throws IOException {
        JavaSourceRootDescriptor rd = context.getProjectDescriptor().getBuildRootIndex().findJavaRootDescriptor(context, file);
        if (rd != null) {
            ProjectDescriptor pd = context.getProjectDescriptor();
            return pd.fsState.isMarkedForRecompilation(context, round, rd, file);
        }
        return false;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public static void markDirty(CompileContext context, File file) throws IOException {
        FSOperations.markDirty(context, CompilationRound.NEXT, file);
    }

    public static void markDirty(CompileContext context, CompilationRound round, File file) throws IOException {
        JavaSourceRootDescriptor rd = context.getProjectDescriptor().getBuildRootIndex().findJavaRootDescriptor(context, file);
        if (rd != null) {
            ProjectDescriptor pd = context.getProjectDescriptor();
            pd.fsState.markDirty(context, round, file, rd, pd.getProjectStamps().getStampStorage(), false);
        }
    }

    public static void markDirtyIfNotDeleted(CompileContext context, CompilationRound round, File file) throws IOException {
        JavaSourceRootDescriptor rd = context.getProjectDescriptor().getBuildRootIndex().findJavaRootDescriptor(context, file);
        if (rd != null) {
            ProjectDescriptor pd = context.getProjectDescriptor();
            pd.fsState.markDirtyIfNotDeleted(context, round, file, rd, pd.getProjectStamps().getStampStorage());
        }
    }

    public static <R extends BuildRootDescriptor, T extends BuildTarget<R>> DirtyFilesHolderBuilder<R, T> createDirtyFilesHolderBuilder(final CompileContext context, final CompilationRound round) {
        return new DirtyFilesHolderBuilder<R, T>(){
            private final Map<T, Map<R, Set<File>>> dirtyFiles = new HashMap();

            @Override
            public DirtyFilesHolderBuilder<R, T> markDirtyFile(T target, File file) throws IOException {
                ProjectDescriptor pd = context.getProjectDescriptor();
                Object rd = pd.getBuildRootIndex().findParentDescriptor(file, Collections.singleton(((BuildTarget)target).getTargetType()), context);
                if (rd != null && (pd.fsState.markDirtyIfNotDeleted(context, round, file, (BuildRootDescriptor)rd, pd.getProjectStamps().getStampStorage()) || pd.fsState.isMarkedForRecompilation(context, round, (BuildRootDescriptor)rd, file))) {
                    Set rootFiles;
                    Map targetFiles = this.dirtyFiles.get(target);
                    if (targetFiles == null) {
                        targetFiles = new HashMap();
                        this.dirtyFiles.put(target, targetFiles);
                    }
                    if ((rootFiles = targetFiles.get(rd)) == null) {
                        rootFiles = FileCollectionFactory.createCanonicalFileSet();
                        targetFiles.put(rd, rootFiles);
                    }
                    rootFiles.add(file);
                }
                return this;
            }

            @Override
            public DirtyFilesHolder<R, T> create() {
                return new DirtyFilesHolder<R, T>(){

                    @Override
                    public void processDirtyFiles(@NotNull FileProcessor<R, T> processor) throws IOException {
                        if (processor == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        for (Map.Entry entry : dirtyFiles.entrySet()) {
                            BuildTarget target = (BuildTarget)entry.getKey();
                            for (Map.Entry targetEntry : ((Map)entry.getValue()).entrySet()) {
                                BuildRootDescriptor rd = (BuildRootDescriptor)targetEntry.getKey();
                                for (File file : (Set)targetEntry.getValue()) {
                                    processor.apply(target, file, rd);
                                }
                            }
                        }
                    }

                    @Override
                    public boolean hasDirtyFiles() {
                        return !dirtyFiles.isEmpty();
                    }

                    @Override
                    public boolean hasRemovedFiles() {
                        return false;
                    }

                    @Override
                    @NotNull
                    public Collection<String> getRemovedFiles(@NotNull T target) {
                        if (target == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        List<String> list = Collections.emptyList();
                        if (list == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        return list;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        RuntimeException runtimeException;
                        Object[] objectArray;
                        Object[] objectArray2;
                        int n2;
                        String string;
                        switch (n) {
                            default: {
                                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                break;
                            }
                            case 2: {
                                string = "@NotNull method %s.%s must not return null";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                n2 = 3;
                                break;
                            }
                            case 2: {
                                n2 = 2;
                                break;
                            }
                        }
                        Object[] objectArray3 = new Object[n2];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "processor";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "target";
                                break;
                            }
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "org/jetbrains/jps/incremental/FSOperations$1$1";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "org/jetbrains/jps/incremental/FSOperations$1$1";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getRemovedFiles";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray;
                                objectArray[2] = "processDirtyFiles";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray;
                                objectArray[2] = "getRemovedFiles";
                                break;
                            }
                            case 2: {
                                break;
                            }
                        }
                        String string2 = String.format(string, objectArray);
                        switch (n) {
                            default: {
                                runtimeException = new IllegalArgumentException(string2);
                                break;
                            }
                            case 2: {
                                runtimeException = new IllegalStateException(string2);
                                break;
                            }
                        }
                        throw runtimeException;
                    }
                };
            }
        };
    }

    public static void markDeleted(CompileContext context, File file) throws IOException {
        JavaSourceRootDescriptor rd = context.getProjectDescriptor().getBuildRootIndex().findJavaRootDescriptor(context, file);
        if (rd != null) {
            ProjectDescriptor pd = context.getProjectDescriptor();
            pd.fsState.registerDeleted(context, rd.target, file, pd.getProjectStamps().getStampStorage());
        }
    }

    public static void markDirty(CompileContext context, CompilationRound round, ModuleChunk chunk, @Nullable FileFilter filter) throws IOException {
        for (ModuleBuildTarget target : chunk.getTargets()) {
            FSOperations.markDirty(context, round, target, filter);
        }
    }

    public static void markDirty(CompileContext context, CompilationRound round, ModuleBuildTarget target, @Nullable FileFilter filter) throws IOException {
        ProjectDescriptor pd = context.getProjectDescriptor();
        FSOperations.markDirtyFiles(context, target, round, pd.getProjectStamps().getStampStorage(), true, null, filter);
    }

    public static void markDirtyRecursively(CompileContext context, CompilationRound round, ModuleChunk chunk) throws IOException {
        FSOperations.markDirtyRecursively(context, round, chunk, null);
    }

    public static void markDirtyRecursively(CompileContext context, CompilationRound round, ModuleChunk chunk, @Nullable FileFilter filter) throws IOException {
        Set<JpsModule> modules = chunk.getModules();
        Set<ModuleBuildTarget> targets = chunk.getTargets();
        HashSet<ModuleBuildTarget> dirtyTargets = new HashSet<ModuleBuildTarget>(targets);
        JpsJavaClasspathKind classpathKind = JpsJavaClasspathKind.compile((boolean)chunk.containsTests());
        boolean found = false;
        block0: for (BuildTargetChunk targetChunk : context.getProjectDescriptor().getBuildTargetIndex().getSortedTargetChunks(context)) {
            if (!found) {
                if (!targetChunk.getTargets().equals(chunk.getTargets())) continue;
                found = true;
                continue;
            }
            for (BuildTarget<?> target : targetChunk.getTargets()) {
                Set<JpsModule> deps;
                if (!(target instanceof ModuleBuildTarget) || !ContainerUtil.intersects(deps = FSOperations.getDependentModulesRecursively(((ModuleBuildTarget)target).getModule(), classpathKind), modules)) continue;
                for (BuildTarget<?> buildTarget : targetChunk.getTargets()) {
                    if (!(buildTarget instanceof ModuleBuildTarget)) continue;
                    dirtyTargets.add((ModuleBuildTarget)buildTarget);
                }
                continue block0;
            }
        }
        if (JavaBuilderUtil.isCompileJavaIncrementally(context)) {
            for (ModuleBuildTarget target : targets) {
                if (FSOperations.isMarkedDirty(context, target)) continue;
                context.markNonIncremental(target);
            }
        }
        FSOperations.removeTargetsAlreadyMarkedDirty(context, dirtyTargets);
        StampsStorage<? extends StampsStorage.Stamp> stampsStorage = context.getProjectDescriptor().getProjectStamps().getStampStorage();
        for (ModuleBuildTarget target : dirtyTargets) {
            FSOperations.markDirtyFiles(context, target, round, stampsStorage, true, null, filter);
        }
    }

    private static Set<JpsModule> getDependentModulesRecursively(JpsModule module, JpsJavaClasspathKind kind) {
        return JpsJavaExtensionService.dependencies((JpsModule)module).includedIn(kind).recursivelyExportedOnly().getModules();
    }

    public static void processFilesToRecompile(CompileContext context, ModuleChunk chunk, FileProcessor<JavaSourceRootDescriptor, ? super ModuleBuildTarget> processor) throws IOException {
        for (ModuleBuildTarget target : chunk.getTargets()) {
            FSOperations.processFilesToRecompile(context, target, processor);
        }
    }

    public static void processFilesToRecompile(CompileContext context, @NotNull ModuleBuildTarget target, FileProcessor<JavaSourceRootDescriptor, ? super ModuleBuildTarget> processor) throws IOException {
        if (target == null) {
            FSOperations.$$$reportNull$$$0(0);
        }
        context.getProjectDescriptor().fsState.processFilesToRecompile(context, target, processor);
    }

    static void markDirtyFiles(CompileContext context, BuildTarget<?> target, CompilationRound round, StampsStorage<? extends StampsStorage.Stamp> stampsStorage, boolean forceMarkDirty, @Nullable Set<? super File> currentFiles, @Nullable FileFilter filter) throws IOException {
        boolean completelyMarkedDirty = true;
        for (BuildRootDescriptor rd : context.getProjectDescriptor().getBuildRootIndex().getTargetRoots(target, context)) {
            if (!rd.getRootFile().exists() || rd instanceof JavaSourceRootDescriptor && ((JavaSourceRootDescriptor)rd).isTemp) continue;
            if (filter == null) {
                context.getProjectDescriptor().fsState.clearRecompile(rd);
            }
            completelyMarkedDirty &= FSOperations.traverseRecursively(context, rd, round, rd.getRootFile(), stampsStorage, forceMarkDirty, currentFiles, filter);
        }
        if (completelyMarkedDirty) {
            FSOperations.addCompletelyMarkedDirtyTarget(context, target);
        }
    }

    private static boolean traverseRecursively(final CompileContext context, final BuildRootDescriptor rd, final CompilationRound round, File file, final @NotNull StampsStorage<? extends StampsStorage.Stamp> stampStorage, final boolean forceDirty, final @Nullable Set<? super File> currentFiles, final @Nullable FileFilter filter) throws IOException {
        if (stampStorage == null) {
            FSOperations.$$$reportNull$$$0(1);
        }
        final BuildRootIndex rootIndex = context.getProjectDescriptor().getBuildRootIndex();
        final Ref allFilesMarked = Ref.create((Object)Boolean.TRUE);
        Files.walkFileTree(file.toPath(), EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException e) throws IOException {
                if (e instanceof FileSystemLoopException) {
                    LOG.info((Throwable)e);
                    boolean marked = FSOperations.traverseRecursivelyIO(context, rd, round, file.toFile(), stampStorage, forceDirty, currentFiles, filter);
                    if (!marked) {
                        allFilesMarked.set((Object)Boolean.FALSE);
                    }
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return super.visitFileFailed(file, e);
            }

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                return rootIndex.isDirectoryAccepted(dir.toFile(), rd) ? FileVisitResult.CONTINUE : FileVisitResult.SKIP_SUBTREE;
            }

            @Override
            public FileVisitResult visitFile(Path f, BasicFileAttributes attrs) throws IOException {
                File _file = f.toFile();
                if (!rootIndex.isFileAccepted(_file, rd)) {
                    return FileVisitResult.CONTINUE;
                }
                if (filter != null && !filter.accept(_file)) {
                    allFilesMarked.set((Object)Boolean.FALSE);
                } else {
                    boolean markDirty = forceDirty;
                    if (!markDirty) {
                        markDirty = stampStorage.isDirtyStamp((StampsStorage.Stamp)stampStorage.getPreviousStamp(_file, rd.getTarget()), _file, attrs);
                    }
                    if (markDirty) {
                        StampsStorage marker = context.isProjectRebuild() ? null : stampStorage;
                        context.getProjectDescriptor().fsState.markDirty(context, round, _file, rd, marker, false);
                    }
                    if (currentFiles != null) {
                        currentFiles.add(_file);
                    }
                    if (!markDirty) {
                        allFilesMarked.set((Object)Boolean.FALSE);
                    }
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return (Boolean)allFilesMarked.get();
    }

    private static boolean traverseRecursivelyIO(CompileContext context, BuildRootDescriptor rd, CompilationRound round, File file, @NotNull StampsStorage<? extends StampsStorage.Stamp> stampsStorage, boolean forceDirty, @Nullable Set<? super File> currentFiles, @Nullable FileFilter filter) throws IOException {
        if (stampsStorage == null) {
            FSOperations.$$$reportNull$$$0(2);
        }
        BuildRootIndex rootIndex = context.getProjectDescriptor().getBuildRootIndex();
        File[] children = file.listFiles();
        if (children != null) {
            boolean allMarkedDirty = true;
            if (children.length > 0 && rootIndex.isDirectoryAccepted(file, rd)) {
                for (File child : children) {
                    allMarkedDirty &= FSOperations.traverseRecursivelyIO(context, rd, round, child, stampsStorage, forceDirty, currentFiles, filter);
                }
            }
            return allMarkedDirty;
        }
        if (!rootIndex.isFileAccepted(file, rd)) {
            return true;
        }
        if (filter != null && !filter.accept(file)) {
            return false;
        }
        boolean markDirty = forceDirty;
        if (!markDirty) {
            markDirty = stampsStorage.isDirtyStamp(stampsStorage.getPreviousStamp(file, rd.getTarget()), file);
        }
        if (markDirty) {
            StampsStorage<? extends StampsStorage.Stamp> marker = context.isProjectRebuild() ? null : stampsStorage;
            context.getProjectDescriptor().fsState.markDirty(context, round, file, rd, marker, false);
        }
        if (currentFiles != null) {
            currentFiles.add(file);
        }
        return markDirty;
    }

    public static void pruneEmptyDirs(CompileContext context, @Nullable Set<File> dirsToDelete) {
        if (dirsToDelete == null || dirsToDelete.isEmpty()) {
            return;
        }
        Set doNotDelete = (Set)ALL_OUTPUTS_KEY.get(context);
        if (doNotDelete == null) {
            doNotDelete = FileCollectionFactory.createCanonicalFileSet();
            for (BuildTarget<?> target : context.getProjectDescriptor().getBuildTargetIndex().getAllTargets()) {
                doNotDelete.addAll(target.getOutputRoots(context));
            }
            ALL_OUTPUTS_KEY.set(context, doNotDelete);
        }
        Set additionalDirs = null;
        Set<File> toDelete = dirsToDelete;
        while (toDelete != null) {
            for (File file : toDelete) {
                File parentFile;
                boolean deleted = !doNotDelete.contains(file) && file.delete();
                if (!deleted || (parentFile = file.getParentFile()) == null) continue;
                if (additionalDirs == null) {
                    additionalDirs = FileCollectionFactory.createCanonicalFileSet();
                }
                additionalDirs.add(parentFile);
            }
            toDelete = additionalDirs;
            additionalDirs = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isMarkedDirty(CompileContext context, ModuleChunk chunk) {
        GlobalContextKey<Set<BuildTarget<?>>> globalContextKey = TARGETS_COMPLETELY_MARKED_DIRTY;
        synchronized (globalContextKey) {
            Set marked = (Set)TARGETS_COMPLETELY_MARKED_DIRTY.get(context);
            return marked != null && marked.containsAll(chunk.getTargets());
        }
    }

    public static long lastModified(File file) {
        return FSOperations.lastModified(file.toPath());
    }

    private static long lastModified(Path path) {
        try {
            return Files.getLastModifiedTime(path, new LinkOption[0]).toMillis();
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            return 0L;
        }
    }

    public static void copy(File fromFile, File toFile) throws IOException {
        block7: {
            Path from = fromFile.toPath();
            Path to = toFile.toPath();
            try {
                try {
                    Files.copy(from, to, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (AccessDeniedException e) {
                    if (!Files.isWritable(to) && toFile.setWritable(true)) {
                        Files.copy(from, to, StandardCopyOption.REPLACE_EXISTING);
                        break block7;
                    }
                    throw e;
                }
                catch (NoSuchFileException e) {
                    File parent = toFile.getParentFile();
                    if (parent != null && parent.mkdirs()) {
                        Files.copy(from, to, StandardCopyOption.REPLACE_EXISTING);
                        break block7;
                    }
                    throw e;
                }
            }
            catch (IOException e) {
                LOG.info("Error copying " + fromFile.getPath() + " to " + toFile.getPath() + " with NIO API", (Throwable)e);
                FileUtil.copyContent((File)fromFile, (File)toFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isMarkedDirty(CompileContext context, BuildTarget<?> target) {
        GlobalContextKey<Set<BuildTarget<?>>> globalContextKey = TARGETS_COMPLETELY_MARKED_DIRTY;
        synchronized (globalContextKey) {
            Set marked = (Set)TARGETS_COMPLETELY_MARKED_DIRTY.get(context);
            return marked != null && marked.contains(target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addCompletelyMarkedDirtyTarget(CompileContext context, BuildTarget<?> target) {
        GlobalContextKey<Set<BuildTarget<?>>> globalContextKey = TARGETS_COMPLETELY_MARKED_DIRTY;
        synchronized (globalContextKey) {
            HashSet marked = (HashSet)TARGETS_COMPLETELY_MARKED_DIRTY.get(context);
            if (marked == null) {
                marked = new HashSet();
                TARGETS_COMPLETELY_MARKED_DIRTY.set(context, marked);
            }
            marked.add(target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeTargetsAlreadyMarkedDirty(CompileContext context, Set<ModuleBuildTarget> targetsSetToFilter) {
        GlobalContextKey<Set<BuildTarget<?>>> globalContextKey = TARGETS_COMPLETELY_MARKED_DIRTY;
        synchronized (globalContextKey) {
            Set marked = (Set)TARGETS_COMPLETELY_MARKED_DIRTY.get(context);
            if (marked != null) {
                targetsSetToFilter.removeAll(marked);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stampStorage";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stampsStorage";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/jps/incremental/FSOperations";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processFilesToRecompile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "traverseRecursively";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "traverseRecursivelyIO";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface DirtyFilesHolderBuilder<R extends BuildRootDescriptor, T extends BuildTarget<R>> {
        public DirtyFilesHolderBuilder<R, T> markDirtyFile(T var1, File var2) throws IOException;

        public DirtyFilesHolder<R, T> create();
    }
}

