/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.incremental.BinaryContent;

public class CompiledClass
extends UserDataHolderBase {
    private static final Logger LOG = Logger.getInstance(CompiledClass.class);
    @NotNull
    private final File myOutputFile;
    @NotNull
    private final Collection<File> mySourceFiles;
    @Nullable
    private final String myClassName;
    @NotNull
    private BinaryContent myContent;
    private boolean myIsDirty;

    public CompiledClass(@NotNull File outputFile, @NotNull Collection<File> sourceFiles, @Nullable String className, @NotNull BinaryContent content) {
        if (outputFile == null) {
            CompiledClass.$$$reportNull$$$0(0);
        }
        if (sourceFiles == null) {
            CompiledClass.$$$reportNull$$$0(1);
        }
        if (content == null) {
            CompiledClass.$$$reportNull$$$0(2);
        }
        this.myIsDirty = false;
        this.myOutputFile = outputFile;
        this.mySourceFiles = sourceFiles;
        this.myClassName = className;
        this.myContent = content;
        LOG.assertTrue(!this.mySourceFiles.isEmpty());
    }

    public CompiledClass(@NotNull File outputFile, @NotNull File sourceFile, @Nullable String className, @NotNull BinaryContent content) {
        if (outputFile == null) {
            CompiledClass.$$$reportNull$$$0(3);
        }
        if (sourceFile == null) {
            CompiledClass.$$$reportNull$$$0(4);
        }
        if (content == null) {
            CompiledClass.$$$reportNull$$$0(5);
        }
        this(outputFile, Collections.singleton(sourceFile), className, content);
    }

    public void save() throws IOException {
        this.myContent.saveToFile(this.myOutputFile);
        this.myIsDirty = false;
    }

    @NotNull
    public File getOutputFile() {
        File file = this.myOutputFile;
        if (file == null) {
            CompiledClass.$$$reportNull$$$0(6);
        }
        return file;
    }

    @NotNull
    public Collection<File> getSourceFiles() {
        Collection<File> collection = this.mySourceFiles;
        if (collection == null) {
            CompiledClass.$$$reportNull$$$0(7);
        }
        return collection;
    }

    @NotNull
    public List<String> getSourceFilesPaths() {
        List list = ContainerUtil.map(this.mySourceFiles, file -> file.getPath());
        if (list == null) {
            CompiledClass.$$$reportNull$$$0(8);
        }
        return list;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @NotNull
    public File getSourceFile() {
        File file = (File)ContainerUtil.getFirstItem(this.getSourceFiles());
        if (file == null) {
            CompiledClass.$$$reportNull$$$0(9);
        }
        return file;
    }

    @Nullable
    public String getClassName() {
        return this.myClassName;
    }

    @NotNull
    public BinaryContent getContent() {
        BinaryContent binaryContent = this.myContent;
        if (binaryContent == null) {
            CompiledClass.$$$reportNull$$$0(10);
        }
        return binaryContent;
    }

    public void setContent(@NotNull BinaryContent content) {
        if (content == null) {
            CompiledClass.$$$reportNull$$$0(11);
        }
        this.myContent = content;
        this.myIsDirty = true;
    }

    public boolean isDirty() {
        return this.myIsDirty;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        CompiledClass aClass = (CompiledClass)((Object)o);
        return FileUtil.filesEqual((File)this.myOutputFile, (File)aClass.myOutputFile);
    }

    public int hashCode() {
        return FileUtil.fileHashCode((File)this.myOutputFile);
    }

    public String toString() {
        return "CompiledClass{myOutputFile=" + this.myOutputFile + ", mySourceFiles=" + this.mySourceFiles + ", myIsDirty=" + this.myIsDirty + '}';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFiles";
                break;
            }
            case 2: 
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFile";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/incremental/CompiledClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/incremental/CompiledClass";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputFile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceFiles";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceFilesPaths";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceFile";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setContent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

