/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.java.dependencyView;

import com.intellij.util.io.DataInputOutputUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.java.dependencyView.ClassRepr;
import org.jetbrains.jps.builders.java.dependencyView.DependencyContext;
import org.jetbrains.jps.builders.java.dependencyView.Difference;
import org.jetbrains.jps.builders.java.dependencyView.FieldRepr;
import org.jetbrains.jps.builders.java.dependencyView.MethodRepr;
import org.jetbrains.jps.builders.java.dependencyView.ModuleRepr;
import org.jetbrains.jps.builders.java.dependencyView.RW;
import org.jetbrains.jps.builders.java.dependencyView.Streamable;
import org.jetbrains.jps.builders.java.dependencyView.TypeRepr;
import org.jetbrains.jps.builders.storage.BuildDataCorruptedException;

class Proto
implements RW.Savable,
Streamable {
    public final int access;
    public final int signature;
    public final int name;
    @NotNull
    public final Set<TypeRepr.ClassType> annotations;

    protected Proto(int access, int signature, int name, Set<TypeRepr.ClassType> annotations) {
        this.access = access;
        this.signature = signature;
        this.name = name;
        this.annotations = annotations;
    }

    protected Proto(DependencyContext context, DataInput in) {
        try {
            this.access = DataInputOutputUtil.readINT((DataInput)in);
            this.signature = DataInputOutputUtil.readINT((DataInput)in);
            this.name = DataInputOutputUtil.readINT((DataInput)in);
            this.annotations = RW.read(TypeRepr.classTypeExternalizer(context), new HashSet(), in);
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public void save(DataOutput out) {
        try {
            DataInputOutputUtil.writeINT((DataOutput)out, (int)this.access);
            DataInputOutputUtil.writeINT((DataOutput)out, (int)this.signature);
            DataInputOutputUtil.writeINT((DataOutput)out, (int)this.name);
            RW.save(this.annotations, out);
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    public final boolean isPublic() {
        return (1 & this.access) != 0;
    }

    public final boolean isProtected() {
        return (4 & this.access) != 0;
    }

    public final boolean isPackageLocal() {
        return (this.access & 7) == 0;
    }

    public final boolean isPrivate() {
        return (2 & this.access) != 0;
    }

    public final boolean isAbstract() {
        return (0x400 & this.access) != 0;
    }

    public final boolean isBridge() {
        return (0x40 & this.access) != 0;
    }

    public final boolean isSynthetic() {
        return (0x1000 & this.access) != 0;
    }

    public final boolean isAnnotation() {
        return (0x2000 & this.access) != 0;
    }

    public final boolean isFinal() {
        return (0x10 & this.access) != 0;
    }

    public final boolean isStatic() {
        return (8 & this.access) != 0;
    }

    public final boolean isMoreAccessibleThan(Proto anotherProto) {
        if (anotherProto.isPrivate()) {
            return this.isPackageLocal() || this.isProtected() || this.isPublic();
        }
        if (anotherProto.isPackageLocal()) {
            return this.isProtected() || this.isPublic();
        }
        if (anotherProto.isProtected()) {
            return this.isPublic();
        }
        return false;
    }

    public Difference difference(final Proto past) {
        Difference.Specifier ann;
        int diff = 0;
        if (past.access != this.access) {
            diff |= 1;
        }
        if (past.signature != this.signature) {
            diff |= 8;
        }
        if (!(ann = Difference.make(past.annotations, this.annotations)).unchanged()) {
            diff |= 0x40;
        }
        final int base = diff;
        return new Difference(){

            @Override
            public int base() {
                return base;
            }

            @Override
            public boolean no() {
                return base == 0;
            }

            @Override
            public int addedModifiers() {
                return ~past.access & Proto.this.access;
            }

            @Override
            public int removedModifiers() {
                return ~Proto.this.access & past.access;
            }

            @Override
            public boolean packageLocalOn() {
                return (past.isPrivate() || past.isPublic() || past.isProtected()) && Proto.this.isPackageLocal();
            }

            @Override
            public boolean hadValue() {
                return false;
            }

            @Override
            public boolean accessRestricted() {
                return Difference.weakerAccess(Proto.this.access, past.access);
            }

            @Override
            public Difference.Specifier<TypeRepr.ClassType, Difference> annotations() {
                return ann;
            }
        };
    }

    @Override
    public void toStream(DependencyContext context, PrintStream stream) {
        String d;
        String string = d = this instanceof ClassRepr ? "      " : "          ";
        if (this instanceof ClassRepr) {
            stream.print("    Class ");
            stream.println(context.getValue(this.name));
        } else if (this instanceof MethodRepr) {
            stream.print("        Method ");
            stream.println(context.getValue(this.name));
        } else if (this instanceof FieldRepr) {
            stream.print("        Field ");
            stream.println(context.getValue(this.name));
        } else if (this instanceof ModuleRepr) {
            stream.print("        Module ");
            stream.println(context.getValue(this.name));
        }
        stream.print(d);
        stream.print("Access     : ");
        stream.println(this.access);
        stream.print(d);
        stream.print("Signature  : ");
        stream.println(context.getValue(this.signature));
    }
}

