/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.java.dependencyView;

import com.intellij.openapi.util.Pair;
import gnu.trove.TObjectObjectProcedure;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.java.dependencyView.CloseableMaplet;
import org.jetbrains.jps.builders.java.dependencyView.DependencyContext;
import org.jetbrains.jps.builders.java.dependencyView.Streamable;

abstract class ObjectObjectMultiMaplet<K, V>
implements Streamable,
CloseableMaplet {
    ObjectObjectMultiMaplet() {
    }

    abstract boolean containsKey(K var1);

    abstract Collection<V> get(K var1);

    abstract void put(K var1, V var2);

    abstract void put(K var1, Collection<V> var2);

    abstract void replace(K var1, Collection<V> var2);

    abstract void putAll(ObjectObjectMultiMaplet<K, V> var1);

    abstract void replaceAll(ObjectObjectMultiMaplet<K, V> var1);

    abstract void remove(K var1);

    abstract void removeFrom(K var1, V var2);

    abstract void removeAll(K var1, Collection<V> var2);

    abstract void forEachEntry(TObjectObjectProcedure<K, Collection<V>> var1);

    abstract void flush(boolean var1);

    @Override
    public void toStream(DependencyContext context, PrintStream stream) {
        final ArrayList keys = new ArrayList();
        this.forEachEntry(new TObjectObjectProcedure<K, Collection<V>>(){

            public boolean execute(K a, Collection<V> b) {
                keys.add(Pair.create(a, (Object)ObjectObjectMultiMaplet.this.debugString(a)));
                return true;
            }
        });
        keys.sort(Pair.comparingBySecond());
        for (Pair a : keys) {
            Collection<V> b = this.get(a.first);
            stream.print("  Key: ");
            stream.println((String)a.second);
            stream.println("  Values:");
            LinkedList<String> list = new LinkedList<String>();
            for (V value : b) {
                if (!(value instanceof Streamable)) continue;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                PrintStream s = new PrintStream(baos);
                ((Streamable)value).toStream(context, s);
                list.add(baos.toString());
            }
            Collections.sort(list);
            for (String l : list) {
                stream.print(l);
            }
            stream.println("  End Of Values");
        }
    }

    @NotNull
    protected String debugString(K k) {
        String string = k.toString();
        if (string == null) {
            ObjectObjectMultiMaplet.$$$reportNull$$$0(0);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/builders/java/dependencyView/ObjectObjectMultiMaplet", "debugString"));
    }
}

