/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.java.dependencyView;

import com.intellij.openapi.util.Ref;
import com.intellij.util.containers.SLRUCache;
import com.intellij.util.io.AppendablePersistentMap;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import com.intellij.util.io.PersistentHashMapValueStorage;
import gnu.trove.TIntFunction;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntObjectProcedure;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.java.dependencyView.IntIntMultiMaplet;
import org.jetbrains.jps.builders.storage.BuildDataCorruptedException;

class NaturalIntIntPersistentMultiMaplet
extends IntIntMultiMaplet {
    private static final TIntHashSet NULL_COLLECTION = new TIntHashSet();
    private static final int CACHE_SIZE = 128;
    private final PersistentHashMap<Integer, TIntHashSet> myMap;
    private final SLRUCache<Integer, TIntHashSet> myCache;
    private static final DataExternalizer<TIntHashSet> EXTERNALIZER = new DataExternalizer<TIntHashSet>(){

        public void save(@NotNull DataOutput out, TIntHashSet value) throws IOException {
            if (out == null) {
                1.$$$reportNull$$$0(0);
            }
            Ref exRef = new Ref(null);
            value.forEach(elem -> {
                try {
                    if (elem == 0) {
                        throw new IOException("Zero values are not supported");
                    }
                    DataInputOutputUtil.writeINT((DataOutput)out, (int)elem);
                }
                catch (IOException e) {
                    exRef.set((Object)e);
                    return false;
                }
                return true;
            });
            IOException exception = (IOException)exRef.get();
            if (exception != null) {
                throw exception;
            }
        }

        public TIntHashSet read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                1.$$$reportNull$$$0(1);
            }
            TIntHashSet result = new TIntHashSet();
            DataInputStream stream = (DataInputStream)in;
            while (stream.available() > 0) {
                int elem = DataInputOutputUtil.readINT((DataInput)in);
                if (elem < 0) {
                    result.remove(-elem);
                    continue;
                }
                if (elem <= 0) continue;
                result.add(elem);
            }
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/jps/builders/java/dependencyView/NaturalIntIntPersistentMultiMaplet$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NaturalIntIntPersistentMultiMaplet(File file, KeyDescriptor<Integer> keyExternalizer) throws IOException {
        Boolean prevValue = (Boolean)PersistentHashMapValueStorage.CreationTimeOptions.COMPACT_CHUNKS_WITH_VALUE_DESERIALIZATION.get();
        try {
            PersistentHashMapValueStorage.CreationTimeOptions.COMPACT_CHUNKS_WITH_VALUE_DESERIALIZATION.set(Boolean.TRUE);
            this.myMap = new PersistentHashMap(file, keyExternalizer, EXTERNALIZER);
        }
        finally {
            PersistentHashMapValueStorage.CreationTimeOptions.COMPACT_CHUNKS_WITH_VALUE_DESERIALIZATION.set(prevValue);
        }
        this.myCache = new SLRUCache<Integer, TIntHashSet>(128, 256){

            @NotNull
            public TIntHashSet createValue(Integer key) {
                TIntHashSet collection;
                block8: {
                    block7: {
                        TIntHashSet tIntHashSet;
                        try {
                            collection = (TIntHashSet)NaturalIntIntPersistentMultiMaplet.this.myMap.get((Object)key);
                            if (collection != null) break block7;
                            tIntHashSet = NULL_COLLECTION;
                        }
                        catch (IOException e) {
                            throw new BuildDataCorruptedException(e);
                        }
                        if (tIntHashSet == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        return tIntHashSet;
                    }
                    if (!collection.isEmpty()) break block8;
                    NaturalIntIntPersistentMultiMaplet.this.myMap.remove((Object)key);
                    TIntHashSet tIntHashSet = NULL_COLLECTION;
                    if (tIntHashSet == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return tIntHashSet;
                }
                TIntHashSet tIntHashSet = collection;
                if (tIntHashSet == null) {
                    2.$$$reportNull$$$0(2);
                }
                return tIntHashSet;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/builders/java/dependencyView/NaturalIntIntPersistentMultiMaplet$2", "createValue"));
            }
        };
    }

    @Override
    public boolean containsKey(int key) {
        try {
            return this.myMap.containsMapping((Object)key);
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public TIntHashSet get(int key) {
        TIntHashSet collection = (TIntHashSet)this.myCache.get((Object)key);
        return collection == NULL_COLLECTION ? null : collection;
    }

    @Override
    public void replace(int key, TIntHashSet value) {
        try {
            this.myCache.remove((Object)key);
            if (value == null || value.isEmpty()) {
                this.myMap.remove((Object)key);
            } else {
                this.myMap.put((Object)key, (Object)value);
            }
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public void put(int key, TIntHashSet values) {
        try {
            if (!values.isEmpty()) {
                this.myCache.remove((Object)key);
                this.myMap.appendData((Object)key, NaturalIntIntPersistentMultiMaplet.getAddAppender(values));
            }
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public void put(int key, int value) {
        try {
            this.myCache.remove((Object)key);
            this.myMap.appendData((Object)key, NaturalIntIntPersistentMultiMaplet.getAddAppender(value));
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public void removeAll(int key, TIntHashSet values) {
        try {
            if (!values.isEmpty()) {
                this.myCache.remove((Object)key);
                this.myMap.appendData((Object)key, NaturalIntIntPersistentMultiMaplet.getRemoveAppender(values));
            }
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public void removeFrom(int key, int value) {
        try {
            TIntHashSet collection = (TIntHashSet)this.myCache.get((Object)key);
            if (collection != NULL_COLLECTION && collection.remove(value)) {
                this.myCache.remove((Object)key);
                if (collection.isEmpty()) {
                    this.myMap.remove((Object)key);
                } else {
                    this.myMap.appendData((Object)key, NaturalIntIntPersistentMultiMaplet.getRemoveAppender(value));
                }
            }
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public void remove(int key) {
        try {
            this.myCache.remove((Object)key);
            this.myMap.remove((Object)key);
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public void putAll(IntIntMultiMaplet m) {
        m.forEachEntry(new TIntObjectProcedure<TIntHashSet>(){

            public boolean execute(int key, TIntHashSet value) {
                NaturalIntIntPersistentMultiMaplet.this.put(key, value);
                return true;
            }
        });
    }

    @Override
    public void replaceAll(IntIntMultiMaplet m) {
        m.forEachEntry(new TIntObjectProcedure<TIntHashSet>(){

            public boolean execute(int key, TIntHashSet value) {
                NaturalIntIntPersistentMultiMaplet.this.replace(key, value);
                return true;
            }
        });
    }

    @Override
    public void close() {
        try {
            this.myCache.clear();
            this.myMap.close();
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public void flush(boolean memoryCachesOnly) {
        if (!memoryCachesOnly) {
            this.myMap.force();
        }
    }

    @Override
    public void forEachEntry(TIntObjectProcedure<TIntHashSet> procedure) {
        try {
            this.myMap.processKeysWithExistingMapping(key -> {
                try {
                    return procedure.execute(key.intValue(), (Object)((TIntHashSet)this.myMap.get(key)));
                }
                catch (IOException e) {
                    throw new BuildDataCorruptedException(e);
                }
            });
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @NotNull
    private static AppendablePersistentMap.ValueDataAppender getAddAppender(int value) {
        AppendablePersistentMap.ValueDataAppender valueDataAppender = out -> DataInputOutputUtil.writeINT((DataOutput)out, (int)value);
        if (valueDataAppender == null) {
            NaturalIntIntPersistentMultiMaplet.$$$reportNull$$$0(0);
        }
        return valueDataAppender;
    }

    @NotNull
    private static AppendablePersistentMap.ValueDataAppender getRemoveAppender(int value) {
        AppendablePersistentMap.ValueDataAppender valueDataAppender = out -> DataInputOutputUtil.writeINT((DataOutput)out, (int)(-value));
        if (valueDataAppender == null) {
            NaturalIntIntPersistentMultiMaplet.$$$reportNull$$$0(1);
        }
        return valueDataAppender;
    }

    @NotNull
    private static AppendablePersistentMap.ValueDataAppender getAddAppender(TIntHashSet set) {
        return NaturalIntIntPersistentMultiMaplet.getAppender(set, value -> value);
    }

    @NotNull
    private static AppendablePersistentMap.ValueDataAppender getRemoveAppender(TIntHashSet set) {
        return NaturalIntIntPersistentMultiMaplet.getAppender(set, value -> -value);
    }

    @NotNull
    private static AppendablePersistentMap.ValueDataAppender getAppender(final TIntHashSet set, final TIntFunction converter) {
        return new AppendablePersistentMap.ValueDataAppender(){

            public void append(@NotNull DataOutput out) throws IOException {
                if (out == null) {
                    5.$$$reportNull$$$0(0);
                }
                Ref exRef = new Ref();
                set.forEach(v -> {
                    try {
                        DataInputOutputUtil.writeINT((DataOutput)out, (int)converter.execute(v));
                    }
                    catch (IOException e) {
                        exRef.set((Object)e);
                        return false;
                    }
                    return true;
                });
                IOException exception = (IOException)exRef.get();
                if (exception != null) {
                    throw exception;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "org/jetbrains/jps/builders/java/dependencyView/NaturalIntIntPersistentMultiMaplet$5", "append"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/jps/builders/java/dependencyView/NaturalIntIntPersistentMultiMaplet";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddAppender";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoveAppender";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

