/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.backwardRefs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TObjectIntHashMap;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.jps.backwardRefs.CompilerRef;
import org.jetbrains.jps.backwardRefs.JavaBackwardReferenceIndexWriter;
import org.jetbrains.jps.backwardRefs.SignatureData;
import org.jetbrains.jps.backwardRefs.index.CompiledFileData;
import org.jetbrains.jps.javac.ast.api.JavacDef;
import org.jetbrains.jps.javac.ast.api.JavacRef;
import org.jetbrains.jps.javac.ast.api.JavacTypeCast;

public final class BackwardReferenceIndexUtil {
    private static final Logger LOG = Logger.getInstance(BackwardReferenceIndexUtil.class);

    /*
     * Could not resolve type clashes
     */
    static void registerFile(String filePath, TObjectIntHashMap<? extends JavacRef> refs, Collection<? extends JavacDef> defs, Collection<? extends JavacTypeCast> casts, Collection<? extends JavacRef> implicitToString, JavaBackwardReferenceIndexWriter writer) {
        try {
            int fileId = writer.enumeratePath(filePath);
            int funExprId = 0;
            HashMap<CompilerRef, Void> definitions = new HashMap<CompilerRef, Void>(defs.size());
            HashMap<CompilerRef, Collection<CompilerRef>> backwardHierarchyMap = new HashMap<CompilerRef, Collection<CompilerRef>>();
            HashMap<SignatureData, Collection<CompilerRef>> signatureData = new HashMap<SignatureData, Collection<CompilerRef>>();
            HashMap<CompilerRef, Collection<CompilerRef>> castMap = new HashMap<CompilerRef, Collection<CompilerRef>>();
            HashMap<CompilerRef, Void> implicitToStringMap = new HashMap<CompilerRef, Void>();
            AnonymousClassEnumerator anonymousClassEnumerator = new AnonymousClassEnumerator();
            for (JavacDef def : defs) {
                if (def instanceof JavacDef.JavacClassDef) {
                    JavacRef[] superClasses;
                    CompilerRef.CompilerClassHierarchyElementDef aClass;
                    JavacRef.JavacClass sym = (JavacRef.JavacClass)def.getDefinedElement();
                    if (sym.isPackageInfo()) continue;
                    if (sym.isAnonymous()) {
                        JavacRef[] classes = ((JavacDef.JavacClassDef)def).getSuperClasses();
                        if (classes.length == 0) {
                            LOG.info("Seems that compilation will finish with errors in anonymous class inside file " + filePath);
                            continue;
                        }
                        aClass = anonymousClassEnumerator.addAnonymous(sym.getName(), writer.asClassUsage(classes[0]));
                    } else {
                        aClass = writer.asClassUsage((JavacRef)sym);
                    }
                    definitions.put(aClass, null);
                    for (JavacRef superClass : superClasses = ((JavacDef.JavacClassDef)def).getSuperClasses()) {
                        CompilerRef.JavaCompilerClassRef superClassRef = writer.asClassUsage(superClass);
                        backwardHierarchyMap.computeIfAbsent(superClassRef, k -> new SmartList()).add(aClass);
                    }
                    continue;
                }
                if (def instanceof JavacDef.JavacFunExprDef) {
                    CompilerRef.JavaCompilerClassRef functionalType = writer.asClassUsage(def.getDefinedElement());
                    int id = funExprId++;
                    CompilerRef.JavaCompilerFunExprDef result = new CompilerRef.JavaCompilerFunExprDef(id);
                    definitions.put(result, null);
                    ((Collection)ContainerUtil.getOrCreate(backwardHierarchyMap, (Object)functionalType, () -> new SmartList())).add(result);
                    continue;
                }
                if (!(def instanceof JavacDef.JavacMemberDef)) continue;
                CompilerRef ref2 = writer.enumerateNames(def.getDefinedElement(), (Function<? super String, Integer>)((Function)name -> anonymousClassEnumerator.getCompilerRefIfAnonymous(name)));
                CompilerRef.JavaCompilerClassRef returnType = writer.asClassUsage(((JavacDef.JavacMemberDef)def).getReturnType());
                if (ref2 == null) continue;
                SignatureData data = new SignatureData(returnType.getName(), ((JavacDef.JavacMemberDef)def).getIteratorKind(), ((JavacDef.JavacMemberDef)def).isStatic());
                signatureData.computeIfAbsent(data, element -> new SmartList()).add(ref2);
            }
            HashMap<CompilerRef, Integer> convertedRefs = new HashMap<CompilerRef, Integer>();
            IOException[] exception = new IOException[]{null};
            refs.forEachEntry((ref, count) -> {
                try {
                    CompilerRef compilerRef = writer.enumerateNames((JavacRef)ref, (Function<? super String, Integer>)((Function)name -> anonymousClassEnumerator.getCompilerRefIfAnonymous(name)));
                    if (compilerRef != null) {
                        Integer old = (Integer)convertedRefs.get(compilerRef);
                        convertedRefs.put(compilerRef, old == null ? count : old + count);
                    }
                }
                catch (IOException e) {
                    exception[0] = e;
                    return false;
                }
                return true;
            });
            if (exception[0] != null) {
                throw exception[0];
            }
            for (JavacTypeCast cast : casts) {
                CompilerRef enumeratedOperandType;
                CompilerRef enumeratedCastType = writer.enumerateNames((JavacRef)cast.getCastType(), (Function<? super String, Integer>)((Function)name -> null));
                if (enumeratedCastType == null || (enumeratedOperandType = writer.enumerateNames((JavacRef)cast.getOperandType(), (Function<? super String, Integer>)((Function)name -> null))) == null) continue;
                castMap.computeIfAbsent(enumeratedCastType, t -> new SmartList()).add(enumeratedOperandType);
            }
            for (JavacRef ref3 : implicitToString) {
                implicitToStringMap.put(writer.asClassUsage(ref3), null);
            }
            writer.writeData(fileId, new CompiledFileData(backwardHierarchyMap, castMap, convertedRefs, definitions, signatureData, implicitToStringMap));
        }
        catch (IOException e) {
            writer.setRebuildCause(e);
        }
    }

    private static final class AnonymousClassEnumerator {
        private Map<String, CompilerRef.CompilerClassHierarchyElementDef> myAnonymousName2Id = null;

        private AnonymousClassEnumerator() {
        }

        private CompilerRef.JavaCompilerAnonymousClassRef addAnonymous(String internalName, CompilerRef.JavaCompilerClassRef base) {
            if (this.myAnonymousName2Id == null) {
                this.myAnonymousName2Id = new HashMap<String, CompilerRef.CompilerClassHierarchyElementDef>();
            }
            int anonymousIdx = this.myAnonymousName2Id.size();
            this.myAnonymousName2Id.put(internalName, base);
            return new CompilerRef.JavaCompilerAnonymousClassRef(anonymousIdx);
        }

        private Integer getCompilerRefIfAnonymous(String className) {
            if (this.myAnonymousName2Id == null) {
                return null;
            }
            CompilerRef.CompilerClassHierarchyElementDef ref = this.myAnonymousName2Id.get(className);
            return ref == null ? null : Integer.valueOf(ref.getName());
        }
    }
}

