/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.settings;

import com.intellij.javascript.trace.execution.TraceConsoleProperties;
import com.intellij.javascript.trace.settings.TraceConfigurable;
import com.intellij.javascript.trace.settings.TraceProjectSettings;
import com.intellij.javascript.trace.settings.TraceSettings;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TraceSettingsManager {
    private final Project myProject;
    private final TraceConsoleProperties myProperties;
    private final List<Consumer<TraceSettings>> myApplySettingsConsumers;
    private boolean isLoaded;

    public TraceSettingsManager(@NotNull Project project, @NotNull TraceConsoleProperties properties) {
        if (project == null) {
            TraceSettingsManager.$$$reportNull$$$0(0);
        }
        if (properties == null) {
            TraceSettingsManager.$$$reportNull$$$0(1);
        }
        this.myApplySettingsConsumers = new ArrayList<Consumer<TraceSettings>>();
        this.myProject = project;
        this.myProperties = properties;
    }

    public void applySettings() {
        TraceProjectSettings.EventFilterState activeFilter = this.getActiveFilter();
        for (Consumer<TraceSettings> consumer : this.myApplySettingsConsumers) {
            consumer.consume((Object)new TraceSettings(activeFilter, this.myProperties.isRealtimeEvaluationEnabled(), this.myProperties.isSourceMapLookupEnabled(), this.myProperties.isSourceMapGenerationEnabled()));
        }
    }

    public TraceProjectSettings.EventFilterState getActiveFilter() {
        String filterName = this.myProperties.getEventFilterName();
        TraceProjectSettings.EventFilterState filter = TraceProjectSettings.getInstance(this.myProject).getState().findEventFilterByName(filterName);
        return filter != null ? filter : (TraceProjectSettings.EventFilterState.ALL_FILTER.getName().equals(filterName) ? TraceProjectSettings.EventFilterState.ALL_FILTER : TraceProjectSettings.EventFilterState.NULL_FILTER);
    }

    public void addSettingsConsumer(Consumer<TraceSettings> consumer) {
        this.myApplySettingsConsumers.add(consumer);
    }

    public TraceProjectSettings.EventFilterState[] getFilters() {
        TraceProjectSettings.TraceSettingsState state = TraceProjectSettings.getInstance(this.myProject).getState();
        List<TraceProjectSettings.EventFilterState> filters = state.getEventFilters();
        return filters.toArray(new TraceProjectSettings.EventFilterState[0]);
    }

    public String getActiveFilterName() {
        return this.myProperties.getEventFilterName();
    }

    public void setAndApplyFilter(String filterName) {
        this.myProperties.setEventFilterName(filterName);
        this.applySettings();
    }

    public boolean setAndApplyFilterByCondition(String value) {
        TraceProjectSettings.EventFilterState filter = TraceProjectSettings.getInstance(this.myProject).getState().findEventFilterByOnlyCondition(value);
        if (filter == null) {
            return false;
        }
        this.setAndApplyFilter(filter.getName());
        return true;
    }

    public void addToActiveOrCreateNewFilterAndApply(@NotNull TraceProjectSettings.EventFilterConditionState condition, @NotNull String nameSuggestion) {
        TraceProjectSettings.EventFilterState activeFilter;
        if (condition == null) {
            TraceSettingsManager.$$$reportNull$$$0(2);
        }
        if (nameSuggestion == null) {
            TraceSettingsManager.$$$reportNull$$$0(3);
        }
        if (!TraceProjectSettings.EventFilterState.isAllOrNothingFilter(activeFilter = this.getActiveFilter())) {
            activeFilter.addEventFilterCondition(condition);
            this.applySettings();
        } else {
            ShowSettingsUtil util = ShowSettingsUtil.getInstance();
            TraceConfigurable configurable = new TraceConfigurable(this.myProject, this);
            util.editConfigurable(this.myProject, (Configurable)configurable, () -> configurable.addActiveFilterWithCondition(condition, nameSuggestion));
        }
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    public void setLoaded(boolean isLoaded) {
        this.isLoaded = isLoaded;
    }

    public boolean isSourceMapSupportEnabled() {
        return this.myProperties.isSourceMapLookupEnabled();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameSuggestion";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javascript/trace/settings/TraceSettingsManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addToActiveOrCreateNewFilterAndApply";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

