/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.systemProxy;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.javascript.trace.TraceBundle;
import com.intellij.javascript.trace.execution.systemProxy.ProxyConfigurator;
import com.intellij.javascript.trace.execution.systemProxy.ProxySettings;
import com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.annotations.NotNull;

public class LinuxProxyConfigurator
extends ProxyConfigurator {
    private static final Logger LOG = Logger.getInstance(LinuxProxyConfigurator.class);

    @Override
    @NotNull
    protected ProxySettings updateSettingsReturnExisting(@NotNull ProxySettings newSettings) throws ExecutionException {
        String proxyData;
        String autouValue;
        String automValue;
        String scriptPath;
        if (newSettings == null) {
            LinuxProxyConfigurator.$$$reportNull$$$0(0);
        }
        if ((scriptPath = this.getScriptPath("proxy-nix.sh")) == null) {
            String message = TraceBundle.message("dialog.message.cannot.find.path.to.proxy.nix.sh", new Object[0]);
            LOG.warn(message);
            throw new ExecutionException(message);
        }
        String string = automValue = newSettings.isTempSettings() ? "auto" : newSettings.getData();
        if (automValue == null) {
            String message = TraceBundle.message("dialog.message.autom.value.null", new Object[0]);
            LOG.warn(message);
            throw new ExecutionException(message);
        }
        String string2 = autouValue = newSettings.getAutoConfigUrl() != null && !newSettings.getAutoConfigUrl().isEmpty() ? newSettings.getAutoConfigUrl() : "''";
        if (autouValue == null) {
            String message = TraceBundle.message("dialog.message.autou.value.null", new Object[0]);
            LOG.warn(message);
            throw new ExecutionException(message);
        }
        ProcessOutput output = ExecUtil.execAndGetOutput((GeneralCommandLine)new GeneralCommandLine(new String[]{"sh", scriptPath, "-autom", automValue, "-autou", autouValue}));
        String error = output.getStderr();
        if (!error.isEmpty()) {
            LOG.warn(error);
        }
        if (!(proxyData = output.getStdout()).isEmpty()) {
            String[] values = proxyData.split(";");
            if (values.length == 2) {
                String mode = values[0];
                String url = values[1];
                ProxySettings settings = new ProxySettings(false, false, url, "");
                settings.setData(mode);
                ProxySettings proxySettings = settings;
                if (proxySettings == null) {
                    LinuxProxyConfigurator.$$$reportNull$$$0(1);
                }
                return proxySettings;
            }
        } else {
            LOG.warn("Proxy data does not have expected format: " + proxyData);
        }
        return new ProxySettings(false, false, null, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSettings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/trace/execution/systemProxy/LinuxProxyConfigurator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/trace/execution/systemProxy/LinuxProxyConfigurator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "updateSettingsReturnExisting";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateSettingsReturnExisting";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

