/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.search;

import com.intellij.javascript.trace.TraceBundle;
import com.intellij.javascript.trace.execution.common.IndexedPsiFile;
import com.intellij.javascript.trace.execution.common.TraceContext;
import com.intellij.javascript.trace.execution.common.TraceSession;
import com.intellij.javascript.trace.execution.events.EventNode;
import com.intellij.javascript.trace.execution.events.EventTree;
import com.intellij.javascript.trace.execution.search.TraceSearchRequest;
import com.intellij.javascript.trace.execution.search.TraceSearchResult;
import com.intellij.javascript.trace.execution.stack.StackNode;
import com.intellij.javascript.trace.execution.stack.StackTree;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FixedHashMap;
import com.intellij.util.containers.Predicate;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class TraceNavigator {
    private final TraceSession myTraceSession;
    private final TraceContext myTraceContext;
    private static final int SEARCH_RESULT_CACHE_CAPACITY = 50;
    private static final float LOAD_FACTOR = 0.75f;
    private final Map<MyFunction, TraceSearchResult> myCache;

    public TraceNavigator(@NotNull TraceContext traceContext) {
        if (traceContext == null) {
            TraceNavigator.$$$reportNull$$$0(0);
        }
        this.myCache = new FixedHashMap(50, (int)Math.ceil(66.66666412353516) + 1, 0.75f, true);
        this.myTraceContext = traceContext;
        this.myTraceSession = traceContext.getTraceSession();
    }

    /*
     * WARNING - void declaration
     */
    public void goToFunctionCall(@NotNull String file, int functionId, @NotNull String contextId, long startEventId, int startStackNodeIndex, boolean bl) {
        void forward;
        if (file == null) {
            TraceNavigator.$$$reportNull$$$0(1);
        }
        if (contextId == null) {
            TraceNavigator.$$$reportNull$$$0(2);
        }
        MyFunction searchKey = MyFunction.create(file, functionId);
        Consumer searchResultConsumer = arg_0 -> this.lambda$goToFunctionCall$3(searchKey, file, functionId, startStackNodeIndex, (boolean)forward, contextId, startEventId, arg_0);
        TraceSearchResult searchResult = this.myCache.get(searchKey);
        if (searchResult == null) {
            this.myTraceSession.searchFunction(new TraceSearchRequest(file, functionId), (Consumer<TraceSearchResult>)searchResultConsumer);
        } else {
            searchResultConsumer.consume((Object)searchResult);
        }
    }

    public void resetCache() {
        this.myCache.clear();
    }

    private void reportFunctionNotFound() {
        StatusBar.Info.set((String)TraceBundle.message("status.navigation.functionNotFound", new Object[0]), (Project)this.myTraceContext.getProject());
    }

    private void select(@NotNull EventNode eventNode, @NotNull StackNode stackNode) {
        if (eventNode == null) {
            TraceNavigator.$$$reportNull$$$0(3);
        }
        if (stackNode == null) {
            TraceNavigator.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().invokeLater(() -> this.myTraceContext.select(eventNode, (Function<StackNode[], StackNode>)((Function)nodes -> stackNode)));
    }

    private static StackNode findStackNode(@NotNull String file, int functionId, StackNode @NotNull [] nodes, int start, boolean forward) {
        if (file == null) {
            TraceNavigator.$$$reportNull$$$0(5);
        }
        if (nodes == null) {
            TraceNavigator.$$$reportNull$$$0(6);
        }
        Predicate nodePredicate = node -> node != null && file.equals(node.getFile()) && node.getFunctionId() == functionId;
        if (forward) {
            for (int i = start; i < nodes.length; ++i) {
                StackNode node2 = nodes[i];
                if (!nodePredicate.apply((Object)node2)) continue;
                return node2;
            }
        } else {
            for (int i = start; i >= 0; --i) {
                StackNode node3 = nodes[i];
                if (!nodePredicate.apply((Object)node3)) continue;
                return node3;
            }
        }
        return null;
    }

    public boolean hasFunction(@NotNull String file, int functionId) {
        if (file == null) {
            TraceNavigator.$$$reportNull$$$0(7);
        }
        if (!this.myTraceContext.getTraceSession().isRunning()) {
            return false;
        }
        if (functionId < IndexedPsiFile.PROGRAM_ID) {
            return false;
        }
        MyFunction key = MyFunction.create(file, functionId);
        TraceSearchResult result = this.myCache.get(key);
        return result == null || !result.isEmpty();
    }

    private /* synthetic */ void lambda$goToFunctionCall$3(MyFunction searchKey, String file, int functionId, int startStackNodeIndex, boolean forward, String contextId, long startEventId, TraceSearchResult result) {
        this.myCache.put(searchKey, result);
        if (result.isEmpty()) {
            this.reportFunctionNotFound();
            return;
        }
        this.myTraceContext.getTraceSearch().reset();
        EventTree eventTree = this.myTraceContext.getCurrentEventTree();
        if (eventTree == null) {
            return;
        }
        EventNode selectedEventNode = eventTree.getSelectedEventNode();
        if (selectedEventNode == null) {
            return;
        }
        StackTree stackTree = this.myTraceContext.getCurrentStackTree();
        if (stackTree == null) {
            return;
        }
        StackNode stackNode = TraceNavigator.findStackNode(file, functionId, stackTree.getAllNodes(), startStackNodeIndex, forward);
        if (stackNode != null) {
            this.select(selectedEventNode, stackNode);
        } else {
            EventNode event;
            List eventNodes = Arrays.asList(eventTree.getAllEventNodesOrderedByOccurenceTimeDesc());
            if (forward) {
                eventNodes = ContainerUtil.reverse(eventNodes);
            }
            if ((event = (EventNode)((Object)ContainerUtil.find((Iterable)eventNodes, node -> {
                String eventContextId = node.getEvent().getStreamId();
                long eventId = node.getEventId();
                return eventContextId.equals(contextId) && (forward && eventId > startEventId || !forward && eventId < startEventId) && result.contains(eventContextId, eventId);
            }))) == null) {
                this.reportFunctionNotFound();
                return;
            }
            ApplicationManager.getApplication().invokeLater(() -> this.myTraceContext.select(event, (Function<StackNode[], StackNode>)((Function)nodes -> {
                StackNode node = TraceNavigator.findStackNode(file, functionId, nodes, forward ? 0 : ((StackNode[])nodes).length - 1, forward);
                if (node == null) {
                    this.reportFunctionNotFound();
                }
                return node;
            })));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "traceContext";
                break;
            }
            case 1: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventNode";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stackNode";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javascript/trace/execution/search/TraceNavigator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "goToFunctionCall";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "select";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "findStackNode";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "hasFunction";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class MyFunction {
        private final String myFile;
        private final int myFunctionId;

        private MyFunction(@NotNull String file, int functionId) {
            if (file == null) {
                MyFunction.$$$reportNull$$$0(0);
            }
            this.myFile = file;
            this.myFunctionId = functionId;
        }

        public static MyFunction create(@NotNull String file, int functionId) {
            if (file == null) {
                MyFunction.$$$reportNull$$$0(1);
            }
            return new MyFunction(file, functionId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MyFunction function = (MyFunction)o;
            if (this.myFunctionId != function.myFunctionId) {
                return false;
            }
            return this.myFile.equals(function.myFile);
        }

        public int hashCode() {
            int result = this.myFile.hashCode();
            result = 31 * result + this.myFunctionId;
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "file";
            objectArray2[1] = "com/intellij/javascript/trace/execution/search/TraceNavigator$MyFunction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "create";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

