/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution;

import com.intellij.javascript.trace.TraceBundle;
import com.intellij.javascript.trace.execution.TraceLimits;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.jetbrains.annotations.NotNull;

public class TraceLimitsPanel
extends JPanel {
    private final JPanel myLimitsPanel;
    private final JLabel myEmptyLabel = new JLabel(TraceBundle.message("configuration.label.perConfig", new Object[0]));
    private final MyLimitValueSpinner myDepthSpinner;
    private final MyLimitValueSpinner myPropNumSpinner;
    private final MyLimitValueSpinner myArrLengthSpinner;
    private final MyLimitValueSpinner myStrLengthSpinner;

    public TraceLimitsPanel() {
        super(new GridBagLayout());
        this.myLimitsPanel = new JPanel(new GridBagLayout());
        this.myLimitsPanel.add((Component)new JLabel(TraceBundle.message("configuration.label.depthLimit", new Object[0])), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.myDepthSpinner = new MyLimitValueSpinner(1, 10);
        this.myLimitsPanel.add((Component)this.myDepthSpinner, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.myLimitsPanel.add((Component)new JLabel(TraceBundle.message("configuration.label.propNumLimit", new Object[0])), new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.myPropNumSpinner = new MyLimitValueSpinner(3, 10);
        this.myLimitsPanel.add((Component)this.myPropNumSpinner, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.myLimitsPanel.add((Component)new JLabel(TraceBundle.message("configuration.label.arrLengthLimit", new Object[0])), new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.myArrLengthSpinner = new MyLimitValueSpinner(3, 10);
        this.myLimitsPanel.add((Component)this.myArrLengthSpinner, new GridBagConstraints(5, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.myLimitsPanel.add((Component)new JLabel(TraceBundle.message("configuration.label.strLengthLimit", new Object[0])), new GridBagConstraints(6, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.myStrLengthSpinner = new MyLimitValueSpinner(50, 800);
        this.myLimitsPanel.add((Component)this.myStrLengthSpinner, new GridBagConstraints(7, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.myLimitsPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.myEmptyLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 13, 1, new Insets(0, 0, 0, 0), 0, 10));
    }

    public void setValue(@NotNull TraceLimits traceLimits) {
        if (traceLimits == null) {
            TraceLimitsPanel.$$$reportNull$$$0(0);
        }
        this.myDepthSpinner.setValue(traceLimits.getMaxDepth());
        this.myPropNumSpinner.setValue(traceLimits.getMaxPropertyNumber());
        this.myArrLengthSpinner.setValue(traceLimits.getMaxArrayLength());
        this.myStrLengthSpinner.setValue(traceLimits.getMaxStringLength());
    }

    @NotNull
    public TraceLimits getValue() {
        return new TraceLimits(this.myDepthSpinner.getIntValue(), this.myPropNumSpinner.getIntValue(), this.myArrLengthSpinner.getIntValue(), this.myStrLengthSpinner.getIntValue());
    }

    public void setEditable(boolean isEditable) {
        this.myEmptyLabel.setVisible(!isEditable);
        this.myLimitsPanel.setVisible(isEditable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "traceLimits", "com/intellij/javascript/trace/execution/TraceLimitsPanel", "setValue"));
    }

    private static class MyLimitValueSpinner
    extends JSpinner {
        MyLimitValueSpinner(int value, int max) {
            this.setModel(new SpinnerNumberModel(value, 1, max, 1));
            this.setEditor(new JSpinner.NumberEditor((JSpinner)this, "#"));
        }

        public int getIntValue() {
            return (Integer)this.getValue();
        }
    }
}

