/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.kpmsearch;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.HttpRequests;
import java.io.IOException;
import java.io.Reader;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.kpmsearch.DefaultPackageServiceConfig;
import org.jetbrains.idea.kpmsearch.PackageSearchEndpointConfig;
import org.jetbrains.idea.kpmsearch.PackageSearchResultModel;
import org.jetbrains.idea.maven.onlinecompletion.model.MavenDependencyCompletionItem;
import org.jetbrains.idea.maven.onlinecompletion.model.MavenRepositoryArtifactInfo;
import org.jetbrains.idea.reposearch.DependencySearchProvider;
import org.jetbrains.idea.reposearch.RepositoryArtifactData;

public class PackageSearchService
implements DependencySearchProvider {
    private final Gson myGson = new Gson();
    private final PackageSearchEndpointConfig myPackageServiceConfig;

    public PackageSearchService() {
        this(new DefaultPackageServiceConfig());
    }

    public PackageSearchService(PackageSearchEndpointConfig config) {
        this.myPackageServiceConfig = config;
    }

    @Override
    public void fulltextSearch(@NotNull String searchString, @NotNull Consumer<RepositoryArtifactData> consumer) {
        if (searchString == null) {
            PackageSearchService.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            PackageSearchService.$$$reportNull$$$0(1);
        }
        searchString = PackageSearchService.normalize(searchString);
        ProgressManager.checkCanceled();
        String url = this.createUrlFullTextSearch(searchString);
        this.doRequest(consumer, url);
    }

    private static String normalize(@Nullable String string) {
        if (StringUtil.isEmpty((String)string)) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (char c : string.toCharArray()) {
            if (!PackageSearchService.isAcceptable(c)) continue;
            builder.append(c);
        }
        return builder.toString();
    }

    private static boolean isAcceptable(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == ':' || c == '-' || c == '.' || c == '_';
    }

    @Override
    public void suggestPrefix(@Nullable String groupId, @Nullable String artifactId, @NotNull Consumer<RepositoryArtifactData> consumer) {
        if (consumer == null) {
            PackageSearchService.$$$reportNull$$$0(2);
        }
        artifactId = PackageSearchService.normalize(artifactId);
        groupId = PackageSearchService.normalize(groupId);
        ProgressManager.checkCanceled();
        String url = this.createUrlSuggestPrefix(groupId, artifactId);
        this.doRequest(consumer, url);
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    private void doRequest(@NotNull Consumer<RepositoryArtifactData> consumer, @Nullable String url) {
        if (consumer == null) {
            PackageSearchService.$$$reportNull$$$0(3);
        }
        if (StringUtil.isEmpty((String)url)) {
            return;
        }
        try {
            HttpRequests.request((String)url).userAgent(this.myPackageServiceConfig.getUserAgent()).forceHttps(this.myPackageServiceConfig.forceHttps()).connectTimeout(this.myPackageServiceConfig.getReadTimeout()).readTimeout(this.myPackageServiceConfig.getConnectTimeout()).connect(request -> this.process(consumer, request));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Object process(@NotNull Consumer<RepositoryArtifactData> consumer, HttpRequests.Request request) {
        if (consumer == null) {
            PackageSearchService.$$$reportNull$$$0(4);
        }
        try {
            JsonReader reader = this.myGson.newJsonReader((Reader)request.getReader());
            reader.beginObject();
            while (reader.hasNext()) {
                String name = reader.nextName();
                if ("items".equals(name)) {
                    this.readVariants(reader, consumer);
                    continue;
                }
                reader.nextString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private String createUrlFullTextSearch(@NotNull String coord) {
        String url;
        if (coord == null) {
            PackageSearchService.$$$reportNull$$$0(5);
        }
        if (StringUtil.isEmpty((String)(url = this.myPackageServiceConfig.getFullTextUrl()))) {
            return null;
        }
        if (StringUtil.isEmpty((String)coord)) {
            return url;
        }
        return url + "?query=" + PackageSearchService.encode(coord.trim());
    }

    private String createUrlSuggestPrefix(@Nullable String groupId, @Nullable String artifactId) {
        String url = this.myPackageServiceConfig.getSuggestUrl();
        if (StringUtil.isEmpty((String)url)) {
            return null;
        }
        String groupParam = StringUtil.isEmpty((String)groupId) ? "" : "groupId=" + PackageSearchService.encode(groupId.trim());
        String artifactParam = StringUtil.isEmpty((String)artifactId) ? "" : "artifactId=" + PackageSearchService.encode(artifactId.trim());
        StringBuilder sb = new StringBuilder(url);
        if (StringUtil.isNotEmpty((String)groupParam)) {
            sb.append('?');
            sb.append(groupParam);
            if (StringUtil.isNotEmpty((String)artifactParam)) {
                sb.append('&');
            }
        }
        if (StringUtil.isNotEmpty((String)artifactParam)) {
            if (StringUtil.isEmpty((String)groupParam)) {
                sb.append('?');
            }
            sb.append(artifactParam);
        }
        return sb.toString();
    }

    private void readVariants(JsonReader reader, Consumer<RepositoryArtifactData> consumer) throws IOException {
        reader.beginArray();
        int results = 0;
        while (reader.hasNext() && results++ < 20) {
            PackageSearchResultModel resultModel = (PackageSearchResultModel)this.myGson.fromJson(reader, PackageSearchResultModel.class);
            ProgressManager.checkCanceled();
            if (resultModel.versions == null || resultModel.versions.length < 1 || StringUtil.isEmpty((String)resultModel.groupId) || StringUtil.isEmpty((String)resultModel.artifactId)) continue;
            HashSet<String> versions = new HashSet<String>();
            ArrayList<MavenDependencyCompletionItem> itemList = new ArrayList<MavenDependencyCompletionItem>();
            for (int i = 0; i < resultModel.versions.length; ++i) {
                if (!versions.add(resultModel.versions[i])) continue;
                itemList.add(new MavenDependencyCompletionItem(resultModel.groupId, resultModel.artifactId, resultModel.versions[i], MavenDependencyCompletionItem.Type.REMOTE));
            }
            MavenDependencyCompletionItem[] items = itemList.toArray(new MavenDependencyCompletionItem[0]);
            String groupId = items[0].getGroupId();
            String artifactId = items[0].getArtifactId();
            if (groupId == null || artifactId == null) continue;
            consumer.accept(new MavenRepositoryArtifactInfo(groupId, artifactId, items));
        }
    }

    @NotNull
    private static String encode(@NotNull String s) {
        if (s == null) {
            PackageSearchService.$$$reportNull$$$0(6);
        }
        String string = URLEncoder.encode(s.trim(), StandardCharsets.UTF_8);
        if (string == null) {
            PackageSearchService.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchString";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coord";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/kpmsearch/PackageSearchService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/kpmsearch/PackageSearchService";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "encode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fulltextSearch";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "suggestPrefix";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doRequest";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createUrlFullTextSearch";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "encode";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

