/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.quickfix;

import com.intellij.codeInsight.daemon.impl.quickfix.ModifierFix;
import com.intellij.codeInsight.intention.AddAnnotationFix;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiType;
import de.plushnikov.intellij.plugin.quickfix.ChangeAnnotationParameterQuickFix;
import de.plushnikov.intellij.plugin.quickfix.CreateFieldQuickFix;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PsiQuickFixFactory {
    public static LocalQuickFix createAddAnnotationQuickFix(@NotNull PsiClass psiClass, @NotNull String annotationFQN, @Nullable String annotationParam) {
        if (psiClass == null) {
            PsiQuickFixFactory.$$$reportNull$$$0(0);
        }
        if (annotationFQN == null) {
            PsiQuickFixFactory.$$$reportNull$$$0(1);
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)psiClass.getProject());
        PsiAnnotation newAnnotation = elementFactory.createAnnotationFromText("@" + annotationFQN + "(" + StringUtil.notNullize((String)annotationParam) + ")", (PsiElement)psiClass);
        PsiNameValuePair[] attributes = newAnnotation.getParameterList().getAttributes();
        return new AddAnnotationFix(annotationFQN, (PsiModifierListOwner)psiClass, attributes, new String[0]);
    }

    public static LocalQuickFix createModifierListFix(@NotNull PsiModifierListOwner owner, @NotNull String modifier, boolean shouldHave, boolean showContainingClass) {
        if (owner == null) {
            PsiQuickFixFactory.$$$reportNull$$$0(2);
        }
        if (modifier == null) {
            PsiQuickFixFactory.$$$reportNull$$$0(3);
        }
        return new ModifierFix(owner, modifier, shouldHave, showContainingClass);
    }

    public static LocalQuickFix createNewFieldFix(@NotNull PsiClass psiClass, @NotNull String name, @NotNull PsiType psiType, @Nullable String initializerText, String ... modifiers) {
        if (psiClass == null) {
            PsiQuickFixFactory.$$$reportNull$$$0(4);
        }
        if (name == null) {
            PsiQuickFixFactory.$$$reportNull$$$0(5);
        }
        if (psiType == null) {
            PsiQuickFixFactory.$$$reportNull$$$0(6);
        }
        return new CreateFieldQuickFix(psiClass, name, psiType, initializerText, modifiers);
    }

    public static LocalQuickFix createChangeAnnotationParameterFix(@NotNull PsiAnnotation psiAnnotation, @NotNull String name, @Nullable String newValue) {
        if (psiAnnotation == null) {
            PsiQuickFixFactory.$$$reportNull$$$0(7);
        }
        if (name == null) {
            PsiQuickFixFactory.$$$reportNull$$$0(8);
        }
        return new ChangeAnnotationParameterQuickFix(psiAnnotation, name, newValue);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationFQN";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
        }
        objectArray2[1] = "de/plushnikov/intellij/plugin/quickfix/PsiQuickFixFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createAddAnnotationQuickFix";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createModifierListFix";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "createNewFieldFix";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "createChangeAnnotationParameterFix";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

