/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.processor.clazz.builder;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import de.plushnikov.intellij.plugin.problem.LombokProblem;
import de.plushnikov.intellij.plugin.problem.ProblemBuilder;
import de.plushnikov.intellij.plugin.problem.ProblemEmptyBuilder;
import de.plushnikov.intellij.plugin.processor.clazz.AbstractClassProcessor;
import de.plushnikov.intellij.plugin.processor.handler.BuilderHandler;
import de.plushnikov.intellij.plugin.util.PsiAnnotationSearchUtil;
import de.plushnikov.intellij.plugin.util.PsiClassUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBuilderPreDefinedInnerClassProcessor
extends AbstractClassProcessor {
    AbstractBuilderPreDefinedInnerClassProcessor(@NotNull Class<? extends PsiElement> supportedClass, @NotNull String supportedAnnotationClass) {
        if (supportedClass == null) {
            AbstractBuilderPreDefinedInnerClassProcessor.$$$reportNull$$$0(0);
        }
        if (supportedAnnotationClass == null) {
            AbstractBuilderPreDefinedInnerClassProcessor.$$$reportNull$$$0(1);
        }
        super(supportedClass, supportedAnnotationClass);
    }

    @Override
    @NotNull
    public List<? super PsiElement> process(@NotNull PsiClass psiClass, @Nullable String nameHint) {
        Optional<PsiClass> parentClass;
        Optional<PsiAnnotation> builderAnnotation;
        if (psiClass == null) {
            AbstractBuilderPreDefinedInnerClassProcessor.$$$reportNull$$$0(2);
        }
        if ((builderAnnotation = (parentClass = this.getSupportedParentClass(psiClass)).map(this::getSupportedAnnotation)).isPresent()) {
            PsiClass psiParentClass = parentClass.get();
            PsiAnnotation psiBuilderAnnotation = builderAnnotation.get();
            if (this.validate(psiBuilderAnnotation, psiParentClass, ProblemEmptyBuilder.getInstance())) {
                List<? super PsiElement> list = this.processAnnotation(psiParentClass, null, psiBuilderAnnotation, psiClass, nameHint);
                if (list == null) {
                    AbstractBuilderPreDefinedInnerClassProcessor.$$$reportNull$$$0(3);
                }
                return list;
            }
        } else if (parentClass.isPresent()) {
            PsiClass psiParentClass = parentClass.get();
            Collection<PsiMethod> psiMethods = PsiClassUtil.collectClassMethodsIntern(psiParentClass);
            for (PsiMethod psiMethod : psiMethods) {
                String builderClassNameOfThisMethod;
                PsiAnnotation psiBuilderAnnotation = PsiAnnotationSearchUtil.findAnnotation((PsiModifierListOwner)psiMethod, this.getSupportedAnnotationClasses());
                if (null == psiBuilderAnnotation || !Objects.equals(builderClassNameOfThisMethod = this.getBuilderHandler().getBuilderClassName(psiParentClass, psiBuilderAnnotation, psiMethod), psiClass.getName())) continue;
                List<? super PsiElement> list = this.processAnnotation(psiParentClass, psiMethod, psiBuilderAnnotation, psiClass, nameHint);
                if (list == null) {
                    AbstractBuilderPreDefinedInnerClassProcessor.$$$reportNull$$$0(4);
                }
                return list;
            }
        }
        List list = Collections.emptyList();
        if (list == null) {
            AbstractBuilderPreDefinedInnerClassProcessor.$$$reportNull$$$0(5);
        }
        return list;
    }

    private List<? super PsiElement> processAnnotation(@NotNull PsiClass psiParentClass, @Nullable PsiMethod psiParentMethod, @NotNull PsiAnnotation psiAnnotation, @NotNull PsiClass psiClass, @Nullable String nameHint) {
        if (psiParentClass == null) {
            AbstractBuilderPreDefinedInnerClassProcessor.$$$reportNull$$$0(6);
        }
        if (psiAnnotation == null) {
            AbstractBuilderPreDefinedInnerClassProcessor.$$$reportNull$$$0(7);
        }
        if (psiClass == null) {
            AbstractBuilderPreDefinedInnerClassProcessor.$$$reportNull$$$0(8);
        }
        String builderClassName = this.getBuilderHandler().getBuilderClassName(psiParentClass, psiAnnotation, psiParentMethod);
        ArrayList<? extends PsiElement> result = new ArrayList<PsiElement>();
        if (builderClassName.equals(psiClass.getName()) && this.possibleToGenerateElementNamed(nameHint, psiClass, psiAnnotation)) {
            result.addAll(this.generatePsiElements(psiParentClass, psiParentMethod, psiAnnotation, psiClass));
        }
        return result;
    }

    protected BuilderHandler getBuilderHandler() {
        return new BuilderHandler();
    }

    protected abstract Collection<? extends PsiElement> generatePsiElements(@NotNull PsiClass var1, @Nullable PsiMethod var2, @NotNull PsiAnnotation var3, @NotNull PsiClass var4);

    @Override
    @NotNull
    public Collection<LombokProblem> verifyAnnotation(@NotNull PsiAnnotation psiAnnotation) {
        if (psiAnnotation == null) {
            AbstractBuilderPreDefinedInnerClassProcessor.$$$reportNull$$$0(9);
        }
        Set<LombokProblem> set = Collections.emptySet();
        if (set == null) {
            AbstractBuilderPreDefinedInnerClassProcessor.$$$reportNull$$$0(10);
        }
        return set;
    }

    @Override
    protected boolean validate(@NotNull PsiAnnotation psiAnnotation, @NotNull PsiClass psiClass, @NotNull ProblemBuilder builder) {
        if (psiAnnotation == null) {
            AbstractBuilderPreDefinedInnerClassProcessor.$$$reportNull$$$0(11);
        }
        if (psiClass == null) {
            AbstractBuilderPreDefinedInnerClassProcessor.$$$reportNull$$$0(12);
        }
        if (builder == null) {
            AbstractBuilderPreDefinedInnerClassProcessor.$$$reportNull$$$0(13);
        }
        return this.getBuilderHandler().validate(psiClass, psiAnnotation, builder);
    }

    @Override
    protected void generatePsiElements(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation, @NotNull List<? super PsiElement> target) {
        if (psiClass == null) {
            AbstractBuilderPreDefinedInnerClassProcessor.$$$reportNull$$$0(14);
        }
        if (psiAnnotation == null) {
            AbstractBuilderPreDefinedInnerClassProcessor.$$$reportNull$$$0(15);
        }
        if (target == null) {
            AbstractBuilderPreDefinedInnerClassProcessor.$$$reportNull$$$0(16);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supportedClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supportedAnnotationClass";
                break;
            }
            case 2: 
            case 8: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/processor/clazz/builder/AbstractBuilderPreDefinedInnerClassProcessor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiParentClass";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/processor/clazz/builder/AbstractBuilderPreDefinedInnerClassProcessor";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "process";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "verifyAnnotation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 10: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processAnnotation";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "verifyAnnotation";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "generatePsiElements";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

