/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.wsl;

import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WSLUtil;
import com.intellij.execution.wsl.WslDistributionManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.util.ObjectUtils;
import com.intellij.wsl.WSLBundle;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WSLCredentialsHolder {
    private static final String DISTRIBUTION_ID = "DISTRIBUTION_ID";
    @Nullable
    private String myDistributionId;

    @NotNull
    public static WSLCredentialsHolder create(@NotNull WSLDistribution distribution) {
        if (distribution == null) {
            WSLCredentialsHolder.$$$reportNull$$$0(0);
        }
        WSLCredentialsHolder result = new WSLCredentialsHolder();
        result.setDistributionId(distribution.getId());
        WSLCredentialsHolder wSLCredentialsHolder = result;
        if (wSLCredentialsHolder == null) {
            WSLCredentialsHolder.$$$reportNull$$$0(1);
        }
        return wSLCredentialsHolder;
    }

    @NotNull
    String requireNotNullDistributionId() {
        if (this.myDistributionId == null) {
            throw new RuntimeException("Invoked get before initializing");
        }
        String string = this.myDistributionId;
        if (string == null) {
            WSLCredentialsHolder.$$$reportNull$$$0(2);
        }
        return string;
    }

    void setDistributionId(@NotNull String distributionId) {
        if (distributionId == null) {
            WSLCredentialsHolder.$$$reportNull$$$0(3);
        }
        this.myDistributionId = distributionId;
    }

    public void save(@NotNull Element rootElement) {
        if (rootElement == null) {
            WSLCredentialsHolder.$$$reportNull$$$0(4);
        }
        if (this.myDistributionId == null) {
            throw new RuntimeException("Invoked save before initializing");
        }
        rootElement.setAttribute(DISTRIBUTION_ID, this.myDistributionId);
    }

    public void load(@NotNull Element rootElement) {
        String value;
        if (rootElement == null) {
            WSLCredentialsHolder.$$$reportNull$$$0(5);
        }
        this.myDistributionId = (value = rootElement.getAttributeValue(DISTRIBUTION_ID)) != null ? WSLUtil.getMsId((String)value) : null;
    }

    @NotNull
    public WSLDistribution getDistribution() {
        WSLDistribution wSLDistribution = WslDistributionManager.getInstance().getOrCreateDistributionByMsId(this.requireNotNullDistributionId());
        if (wSLDistribution == null) {
            WSLCredentialsHolder.$$$reportNull$$$0(6);
        }
        return wSLDistribution;
    }

    @NotNull
    public static WSLCredentialsHolder get(@NotNull RemoteSdkAdditionalData<?> sdkAdditionalData) throws ConfigurationException {
        Object credentials;
        if (sdkAdditionalData == null) {
            WSLCredentialsHolder.$$$reportNull$$$0(7);
        }
        if ((credentials = sdkAdditionalData.connectionCredentials().getCredentials()) instanceof WSLCredentialsHolder) {
            WSLCredentialsHolder wSLCredentialsHolder = (WSLCredentialsHolder)credentials;
            if (wSLCredentialsHolder == null) {
                WSLCredentialsHolder.$$$reportNull$$$0(8);
            }
            return wSLCredentialsHolder;
        }
        throw new ConfigurationException(WSLBundle.message("dialog.message.wsl.credentials.expected", credentials));
    }

    @Nullable
    public static WSLDistribution getDistribution(@Nullable SdkAdditionalData sdkAdditionalData) {
        if (!(sdkAdditionalData instanceof RemoteSdkAdditionalData)) {
            return null;
        }
        WSLCredentialsHolder wslCredentialsHolder = (WSLCredentialsHolder)ObjectUtils.tryCast((Object)((RemoteSdkAdditionalData)sdkAdditionalData).connectionCredentials().getCredentials(), WSLCredentialsHolder.class);
        return wslCredentialsHolder == null ? null : wslCredentialsHolder.getDistribution();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distribution";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/wsl/WSLCredentialsHolder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distributionId";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkAdditionalData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/wsl/WSLCredentialsHolder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "requireNotNullDistributionId";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDistribution";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setDistributionId";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "save";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

