/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.search;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.asJava.ImpreciseResolveResult;
import org.jetbrains.kotlin.idea.caches.trackers.KotlinCodeBlockModificationListener;
import org.jetbrains.kotlin.idea.search.KotlinSearchUsagesSupport;
import org.jetbrains.kotlin.idea.search.PsiBasedClassResolver;
import org.jetbrains.kotlin.idea.search.SearchUtilKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.ImportPath;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 $2\u00020\u0001:\u0002$%B\u000f\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0006H\u0007J,\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u000b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0006H\u0002J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010 \u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010!\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0014\u0010\"\u001a\u00020\u0015*\u00020\u00152\u0006\u0010#\u001a\u00020\u0015H\u0002R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/idea/search/PsiBasedClassResolver;", "", "target", "Lcom/intellij/psi/PsiClass;", "(Lcom/intellij/psi/PsiClass;)V", "targetClassFqName", "", "(Ljava/lang/String;)V", "conflictingPackages", "", "forceAmbiguity", "", "forceAmbiguityForInnerAnnotations", "forceAmbiguityForNonAnnotations", "packagesWithTypeAliases", "targetPackage", "targetShortName", "addConflict", "", "fqName", "analyzeSingleImport", "Lorg/jetbrains/kotlin/idea/search/PsiBasedClassResolver$Result;", "result", "importedFqName", "Lorg/jetbrains/kotlin/name/FqName;", "isAllUnder", "aliasName", "canBeTargetReference", "Lorg/jetbrains/kotlin/asJava/ImpreciseResolveResult;", "ref", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "checkQualifiedReferenceToTarget", "findPotentialClassConflicts", "findPotentialTypeAliasConflicts", "changeTo", "newResult", "Companion", "Result", "kotlin.fir.frontend-independent"})
public final class PsiBasedClassResolver {
    private final String targetShortName;
    private final String targetPackage;
    private final List<String> conflictingPackages;
    private final List<String> packagesWithTypeAliases;
    private boolean forceAmbiguity;
    private boolean forceAmbiguityForInnerAnnotations;
    private boolean forceAmbiguityForNonAnnotations;
    private final String targetClassFqName;
    @NotNull
    private static final AtomicInteger attempts;
    @NotNull
    private static final AtomicInteger trueHits;
    @NotNull
    private static final AtomicInteger falseHits;
    private static final Key<CachedValue<PsiBasedClassResolver>> PSI_BASED_CLASS_RESOLVER_KEY;
    @NotNull
    public static final Companion Companion;

    private final void findPotentialClassConflicts(PsiClass target) {
        PsiClass[] candidates2;
        PsiShortNamesCache psiShortNamesCache = PsiShortNamesCache.getInstance((Project)target.getProject());
        Project project = target.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"target.project");
        PsiClass[] psiClassArray = psiShortNamesCache.getClassesByName(this.targetShortName, SearchUtilKt.allScope(project));
        Intrinsics.checkNotNullExpressionValue((Object)psiClassArray, (String)"PsiShortNamesCache.getIn\u2026arget.project.allScope())");
        PsiClass[] psiClassArray2 = candidates2 = psiClassArray;
        int n = psiClassArray2.length;
        for (int j = 0; j < n; ++j) {
            PsiClass candidate;
            PsiClass psiClass2 = candidate = psiClassArray2[j];
            Intrinsics.checkNotNullExpressionValue((Object)psiClass2, (String)"candidate");
            if (psiClass2.getContainingClass() != null && !candidate.hasModifierProperty("private")) {
                if (candidate.isAnnotationType()) {
                    this.forceAmbiguityForInnerAnnotations = true;
                    break;
                }
                this.forceAmbiguityForNonAnnotations = true;
                break;
            }
            if (Intrinsics.areEqual((Object)candidate.getQualifiedName(), (Object)target.getQualifiedName())) {
                PsiElement psiElement = candidate.getNavigationElement();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"candidate.navigationElement");
                PsiFile psiFile = psiElement.getContainingFile();
                PsiElement psiElement2 = target.getNavigationElement();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"target.navigationElement");
                if (!(Intrinsics.areEqual((Object)psiFile, (Object)psiElement2.getContainingFile()) ^ true)) continue;
                this.forceAmbiguity = true;
                break;
            }
            String string = candidate.getQualifiedName();
            if (string == null || (string = StringsKt.substringBeforeLast((String)string, (char)'.', (String)"")) == null) continue;
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String candidatePackage = string2;
            boolean bl3 = false;
            if (Intrinsics.areEqual((Object)candidatePackage, (Object)"")) {
                this.forceAmbiguity = true;
                continue;
            }
            this.conflictingPackages.add(candidatePackage);
        }
    }

    private final void findPotentialTypeAliasConflicts(PsiClass target) {
        Project project = target.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"target.project");
        Project project2 = target.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"target.project");
        Collection<KtTypeAlias> candidates2 = KotlinSearchUsagesSupport.Companion.findTypeAliasByShortName(this.targetShortName, project, SearchUtilKt.allScope(project2));
        for (KtTypeAlias candidate : candidates2) {
            String string = candidate.getContainingKtFile().getPackageFqName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"candidate.containingKtFi\u2026.packageFqName.asString()");
            this.packagesWithTypeAliases.add(string);
        }
    }

    @TestOnly
    public final void addConflict(@NotNull String fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        this.conflictingPackages.add(StringsKt.substringBeforeLast$default((String)fqName2, (char)'.', null, (int)2, null));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ImpreciseResolveResult canBeTargetReference(@NotNull KtSimpleNameExpression ref) {
        KtDeclaration declaration;
        KtDeclaration ktDeclaration;
        void $this$getParentOfTypeAndBranch_u24default$iv;
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        attempts.incrementAndGet();
        if (Intrinsics.areEqual((Object)ref.getReferencedName(), (Object)this.targetShortName) ^ true) {
            return ImpreciseResolveResult.UNSURE;
        }
        PsiElement $this$getStrictParentOfType$iv = (PsiElement)ref;
        boolean $i$f$getStrictParentOfType22 = false;
        KtUserType ktUserType = (KtUserType)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtUserType.class, (boolean)true);
        if (ktUserType == null) {
            return ImpreciseResolveResult.UNSURE;
        }
        KtUserType userType = ktUserType;
        PsiElement $i$f$getStrictParentOfType22 = (PsiElement)userType;
        Function1 branch$iv = canBeTargetReference.parentAnnotation.1.INSTANCE;
        boolean strict$iv2 = false;
        boolean $i$f$getParentOfTypeAndBranch = false;
        void $this$getParentOfType$iv$iv = $this$getParentOfTypeAndBranch_u24default$iv;
        boolean $i$f$getParentOfType = false;
        Object object = PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv$iv, KtAnnotationEntry.class, (boolean)strict$iv2);
        KtAnnotationEntry parentAnnotation2 = (KtAnnotationEntry)(object == null ? null : PsiUtilsKt.getIfChildIsInBranch((PsiElement)object, (PsiElement)$this$getParentOfTypeAndBranch_u24default$iv, (Function1)branch$iv));
        if (this.forceAmbiguityForNonAnnotations && parentAnnotation2 == null) {
            return ImpreciseResolveResult.UNSURE;
        }
        KtAnnotationEntry ktAnnotationEntry = parentAnnotation2;
        if (ktAnnotationEntry != null) {
            void $this$getParentOfType$iv;
            PsiElement strict$iv2 = (PsiElement)ktAnnotationEntry;
            boolean strict$iv3 = true;
            boolean $i$f$getParentOfType2 = false;
            ktDeclaration = (KtDeclaration)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtDeclaration.class, (boolean)strict$iv3);
        } else {
            ktDeclaration = declaration = null;
        }
        if (this.forceAmbiguityForInnerAnnotations) {
            KtDeclaration ktDeclaration2 = declaration;
            if (!((ktDeclaration2 != null ? ktDeclaration2.getParent() : null) instanceof KtFile)) {
                return ImpreciseResolveResult.UNSURE;
            }
        }
        if (this.forceAmbiguity) {
            return ImpreciseResolveResult.UNSURE;
        }
        Result qualifiedCheckResult = this.checkQualifiedReferenceToTarget(ref);
        if (qualifiedCheckResult != null) {
            return qualifiedCheckResult.getReturnValue();
        }
        KtFile ktFile = ref.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"ref.containingKtFile");
        KtFile file = ktFile;
        Result result2 = Result.NothingFound;
        object = file.getPackageFqName().asString();
        if (Intrinsics.areEqual((Object)object, (Object)this.targetPackage)) {
            result2 = this.changeTo(result2, Result.Found);
        } else if (this.conflictingPackages.contains(object)) {
            result2 = this.changeTo(result2, Result.FoundOther);
        } else if (this.packagesWithTypeAliases.contains(object)) {
            return ImpreciseResolveResult.UNSURE;
        }
        for (ImportPath importPath : KotlinSearchUsagesSupport.Companion.getDefaultImports(file)) {
            Name name = importPath.getAlias();
            if ((result2 = this.analyzeSingleImport(result2, importPath.getFqName(), importPath.isAllUnder(), name != null ? name.asString() : null)) != Result.Ambiguity) continue;
            return ImpreciseResolveResult.UNSURE;
        }
        for (KtImportDirective importDirective : file.getImportDirectives()) {
            if ((result2 = this.analyzeSingleImport(result2, importDirective.getImportedFqName(), importDirective.isAllUnder(), importDirective.getAliasName())) != Result.Ambiguity) continue;
            return ImpreciseResolveResult.UNSURE;
        }
        if (result2.getReturnValue() == ImpreciseResolveResult.MATCH) {
            trueHits.incrementAndGet();
        } else if (result2.getReturnValue() == ImpreciseResolveResult.NO_MATCH) {
            falseHits.incrementAndGet();
        }
        return result2.getReturnValue();
    }

    private final Result analyzeSingleImport(Result result2, FqName importedFqName, boolean isAllUnder, String aliasName) {
        if (!isAllUnder) {
            FqName fqName2 = importedFqName;
            if (Intrinsics.areEqual((Object)(fqName2 != null ? fqName2.asString() : null), (Object)this.targetClassFqName) && (aliasName == null || Intrinsics.areEqual((Object)aliasName, (Object)this.targetShortName))) {
                return this.changeTo(result2, Result.Found);
            }
            FqName fqName3 = importedFqName;
            if (Intrinsics.areEqual((Object)(fqName3 != null && (fqName3 = fqName3.shortName()) != null ? fqName3.asString() : null), (Object)this.targetShortName) && this.conflictingPackages.contains(importedFqName.parent().asString()) && aliasName == null) {
                return this.changeTo(result2, Result.FoundOther);
            }
            FqName fqName4 = importedFqName;
            if (Intrinsics.areEqual((Object)(fqName4 != null && (fqName4 = fqName4.shortName()) != null ? fqName4.asString() : null), (Object)this.targetShortName) && this.packagesWithTypeAliases.contains(importedFqName.parent().asString()) && aliasName == null) {
                return Result.Ambiguity;
            }
            if (Intrinsics.areEqual((Object)aliasName, (Object)this.targetShortName)) {
                return this.changeTo(result2, Result.FoundOther);
            }
        } else {
            FqName fqName5 = importedFqName;
            if (Intrinsics.areEqual((Object)(fqName5 != null ? fqName5.asString() : null), (Object)this.targetPackage)) {
                return this.changeTo(result2, Result.Found);
            }
            FqName fqName6 = importedFqName;
            if (CollectionsKt.contains((Iterable)this.conflictingPackages, (Object)(fqName6 != null ? fqName6.asString() : null))) {
                return this.changeTo(result2, Result.FoundOther);
            }
            FqName fqName7 = importedFqName;
            if (CollectionsKt.contains((Iterable)this.packagesWithTypeAliases, (Object)(fqName7 != null ? fqName7.asString() : null))) {
                return Result.Ambiguity;
            }
        }
        return result2;
    }

    private final Result checkQualifiedReferenceToTarget(KtSimpleNameExpression ref) {
        KtUserType ktUserType;
        PsiElement $this$safeAs$iv = ref.getParent();
        boolean $i$f$safeAs = false;
        PsiElement psiElement = $this$safeAs$iv;
        if (!(psiElement instanceof KtUserType)) {
            psiElement = null;
        }
        if ((ktUserType = (KtUserType)psiElement) != null && (ktUserType = ktUserType.getQualifier()) != null) {
            KtUserType ktUserType2 = ktUserType;
            boolean bl = false;
            boolean bl2 = false;
            KtUserType qualifier = ktUserType2;
            boolean bl3 = false;
            String fqName2 = CollectionsKt.joinToString$default((Iterable)CollectionsKt.reversed((Iterable)SequencesKt.toList((Sequence)SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super String>, Continuation<? super Unit>, Object>(qualifier, null){
                private /* synthetic */ Object L$0;
                Object L$1;
                int label;
                final /* synthetic */ KtUserType $qualifier;

                /*
                 * Unable to fully structure code
                 * Could not resolve type clashes
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    block0 : switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            $this$sequence = (SequenceScope)this.L$0;
                            q = this.$qualifier;
lbl7:
                            // 2 sources

                            while (true) {
                                v0 = q;
                                if ((v0 != null ? v0.getReferencedName() : null) == null) break block0;
                                v1 /* !! */  = q;
                                if (v1 /* !! */  == null || (v1 /* !! */  = v1 /* !! */ .getReferencedName()) == null) {
                                    break block0;
                                }
                                this.L$0 = $this$sequence;
                                this.L$1 = q;
                                this.label = 1;
                                v2 = $this$sequence.yield((Object)v1 /* !! */ , (Continuation)this);
                                if (v2 == var4_2) {
                                    return var4_2;
                                }
                                ** GOTO lbl25
                                break;
                            }
                        }
                        case 1: {
                            var3_4 = (KtUserType)this.L$1;
                            var2_3 = (SequenceScope)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
lbl25:
                            // 2 sources

                            v3 = var3_4;
                            var3_4 = v3 != null ? v3.getQualifier() : null;
                            ** continue;
                        }
                    }
                    return Unit.INSTANCE;
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }
                {
                    this.$qualifier = ktUserType;
                    super(2, continuation);
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                    Intrinsics.checkNotNullParameter(completion, (String)"completion");
                    Function2<SequenceScope<? super String>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    Object object = function2.L$0 = value;
                    return function2;
                }

                public final Object invoke(Object object, Object object2) {
                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                }
            })))), (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
            return Intrinsics.areEqual((Object)fqName2, (Object)this.targetPackage) ? Result.Ambiguity : Result.FoundOther;
        }
        return null;
    }

    private final Result changeTo(Result $this$changeTo, Result newResult) {
        if ($this$changeTo == Result.NothingFound || $this$changeTo.getReturnValue() == newResult.getReturnValue()) {
            return newResult;
        }
        return Result.Ambiguity;
    }

    @TestOnly
    public PsiBasedClassResolver(@NotNull String targetClassFqName) {
        Intrinsics.checkNotNullParameter((Object)targetClassFqName, (String)"targetClassFqName");
        this.targetClassFqName = targetClassFqName;
        this.targetShortName = StringsKt.substringAfterLast$default((String)this.targetClassFqName, (char)'.', null, (int)2, null);
        this.targetPackage = StringsKt.substringBeforeLast((String)this.targetClassFqName, (char)'.', (String)"");
        boolean bl = false;
        this.conflictingPackages = new ArrayList();
        bl = false;
        this.packagesWithTypeAliases = new ArrayList();
    }

    private PsiBasedClassResolver(final PsiClass target) {
        block5: {
            block4: {
                String string = target.getQualifiedName();
                if (string == null) {
                    string = "";
                }
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"target.qualifiedName ?: \"\"");
                this(string);
                if (target.getQualifiedName() == null || target.getContainingClass() != null) break block4;
                CharSequence charSequence = this.targetPackage;
                boolean bl = false;
                if (!(charSequence.length() == 0)) break block5;
            }
            this.forceAmbiguity = true;
            return;
        }
        ApplicationUtilsKt.runReadAction((Function0)new Function0<Unit>(){

            public final void invoke() {
                this.findPotentialClassConflicts(target);
                this.findPotentialTypeAliasConflicts(target);
            }
        });
    }

    static {
        Companion = new Companion(null);
        attempts = new AtomicInteger();
        trueHits = new AtomicInteger();
        falseHits = new AtomicInteger();
        PSI_BASED_CLASS_RESOLVER_KEY = new Key("PsiBasedClassResolver");
    }

    public /* synthetic */ PsiBasedClassResolver(PsiClass target, DefaultConstructorMarker $constructor_marker) {
        this(target);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/search/PsiBasedClassResolver$Result;", "", "returnValue", "Lorg/jetbrains/kotlin/asJava/ImpreciseResolveResult;", "(Ljava/lang/String;ILorg/jetbrains/kotlin/asJava/ImpreciseResolveResult;)V", "getReturnValue", "()Lorg/jetbrains/kotlin/asJava/ImpreciseResolveResult;", "NothingFound", "Found", "FoundOther", "Ambiguity", "kotlin.fir.frontend-independent"})
    public static final class Result
    extends Enum<Result> {
        public static final /* enum */ Result NothingFound;
        public static final /* enum */ Result Found;
        public static final /* enum */ Result FoundOther;
        public static final /* enum */ Result Ambiguity;
        private static final /* synthetic */ Result[] $VALUES;
        @NotNull
        private final ImpreciseResolveResult returnValue;

        static {
            Result[] resultArray = new Result[4];
            Result[] resultArray2 = resultArray;
            resultArray[0] = NothingFound = new Result(ImpreciseResolveResult.NO_MATCH);
            resultArray[1] = Found = new Result(ImpreciseResolveResult.MATCH);
            resultArray[2] = FoundOther = new Result(ImpreciseResolveResult.NO_MATCH);
            resultArray[3] = Ambiguity = new Result(ImpreciseResolveResult.UNSURE);
            $VALUES = resultArray;
        }

        @NotNull
        public final ImpreciseResolveResult getReturnValue() {
            return this.returnValue;
        }

        private Result(ImpreciseResolveResult returnValue) {
            this.returnValue = returnValue;
        }

        public static Result[] values() {
            return (Result[])$VALUES.clone();
        }

        public static Result valueOf(String string) {
            return Enum.valueOf(Result.class, string);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011R\u001a\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00020\b8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u000b\u001a\u00020\b8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0013\u0010\r\u001a\u00020\b8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/search/PsiBasedClassResolver$Companion;", "", "()V", "PSI_BASED_CLASS_RESOLVER_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/psi/util/CachedValue;", "Lorg/jetbrains/kotlin/idea/search/PsiBasedClassResolver;", "attempts", "Ljava/util/concurrent/atomic/AtomicInteger;", "getAttempts", "()Ljava/util/concurrent/atomic/AtomicInteger;", "falseHits", "getFalseHits", "trueHits", "getTrueHits", "getInstance", "target", "Lcom/intellij/psi/PsiClass;", "kotlin.fir.frontend-independent"})
    public static final class Companion {
        @TestOnly
        @NotNull
        public final AtomicInteger getAttempts() {
            return attempts;
        }

        @TestOnly
        @NotNull
        public final AtomicInteger getTrueHits() {
            return trueHits;
        }

        @TestOnly
        @NotNull
        public final AtomicInteger getFalseHits() {
            return falseHits;
        }

        @NotNull
        public final PsiBasedClassResolver getInstance(@NotNull PsiClass target) {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            CachedValue cachedValue2 = (CachedValue)target.getUserData(PSI_BASED_CLASS_RESOLVER_KEY);
            if (cachedValue2 != null) {
                CachedValue cachedValue3 = cachedValue2;
                boolean bl = false;
                boolean bl2 = false;
                CachedValue it = cachedValue3;
                boolean bl3 = false;
                CachedValue cachedValue4 = it;
                Intrinsics.checkNotNullExpressionValue((Object)cachedValue4, (String)"it");
                Object object = cachedValue4.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.value");
                return (PsiBasedClassResolver)object;
            }
            CachedValue cachedValue5 = CachedValuesManager.getManager((Project)target.getProject()).createCachedValue(new CachedValueProvider(target){
                final /* synthetic */ PsiClass $target;

                @Nullable
                public final CachedValueProvider.Result<PsiBasedClassResolver> compute() {
                    PsiBasedClassResolver psiBasedClassResolver = new PsiBasedClassResolver(this.$target, null);
                    Object[] objectArray = new Object[1];
                    Project project = this.$target.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"target.project");
                    objectArray[0] = KotlinCodeBlockModificationListener.Companion.getInstance(project).getKotlinOutOfCodeBlockTracker();
                    return new CachedValueProvider.Result((Object)psiBasedClassResolver, objectArray);
                }
                {
                    this.$target = psiClass2;
                }
            }, false);
            Intrinsics.checkNotNullExpressionValue((Object)cachedValue5, (String)"CachedValuesManager.getM\u2026   }, false\n            )");
            CachedValue cachedValue6 = cachedValue5;
            target.putUserData(PSI_BASED_CLASS_RESOLVER_KEY, (Object)cachedValue6);
            Object object = cachedValue6.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"cachedValue.value");
            return (PsiBasedClassResolver)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

