/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.findUsages.dialogs;

import com.intellij.find.FindSettings;
import com.intellij.find.findUsages.FindMethodUsagesDialog;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.findUsages.JavaMethodFindUsagesOptions;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.StateRestoringCheckBox;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.elements.KtLightMethod;
import org.jetbrains.kotlin.idea.KotlinIndependentBundle;
import org.jetbrains.kotlin.idea.findUsages.KotlinFunctionFindUsagesOptions;
import org.jetbrains.kotlin.idea.findUsages.dialogs.Utils;
import org.jetbrains.kotlin.idea.search.KotlinSearchUsagesSupport;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

public class KotlinFindFunctionUsagesDialog
extends FindMethodUsagesDialog {
    private StateRestoringCheckBox expectedUsages;

    public KotlinFindFunctionUsagesDialog(PsiMethod method, Project project, KotlinFunctionFindUsagesOptions findUsagesOptions, boolean toShowInNewTab, boolean mustOpenInNewTab, boolean isSingleFile, FindUsagesHandler handler) {
        super((PsiElement)method, project, (FindUsagesOptions)findUsagesOptions, toShowInNewTab, mustOpenInNewTab, isSingleFile, handler);
    }

    @NotNull
    protected KotlinFunctionFindUsagesOptions getFindUsagesOptions() {
        KotlinFunctionFindUsagesOptions kotlinFunctionFindUsagesOptions = (KotlinFunctionFindUsagesOptions)this.myFindUsagesOptions;
        if (kotlinFunctionFindUsagesOptions == null) {
            KotlinFindFunctionUsagesDialog.$$$reportNull$$$0(0);
        }
        return kotlinFunctionFindUsagesOptions;
    }

    public void configureLabelComponent(@NotNull SimpleColoredComponent coloredComponent) {
        if (coloredComponent == null) {
            KotlinFindFunctionUsagesDialog.$$$reportNull$$$0(1);
        }
        coloredComponent.append(KotlinSearchUsagesSupport.Companion.formatJavaOrLightMethod((PsiMethod)this.myPsiElement));
    }

    protected JPanel createFindWhatPanel() {
        JPanel findWhatPanel = super.createFindWhatPanel();
        if (findWhatPanel != null) {
            Utils.renameCheckbox(findWhatPanel, JavaBundle.message((String)"find.what.implementing.methods.checkbox", (Object[])new Object[0]), KotlinIndependentBundle.message("find.declaration.implementing.methods.checkbox", new Object[0]));
            Utils.renameCheckbox(findWhatPanel, JavaBundle.message((String)"find.what.overriding.methods.checkbox", (Object[])new Object[0]), KotlinIndependentBundle.message("find.declaration.overriding.methods.checkbox", new Object[0]));
        }
        return findWhatPanel;
    }

    protected void addUsagesOptions(JPanel optionsPanel) {
        PsiElement element2;
        super.addUsagesOptions(optionsPanel);
        if (!Utils.renameCheckbox(optionsPanel, JavaBundle.message((String)"find.options.include.overloaded.methods.checkbox", (Object[])new Object[0]), KotlinIndependentBundle.message("find.declaration.include.overloaded.methods.checkbox", new Object[0]))) {
            this.addCheckboxToPanel(KotlinIndependentBundle.message("find.declaration.include.overloaded.methods.checkbox", new Object[0]), FindSettings.getInstance().isSearchOverloadedMethods(), optionsPanel, false);
        }
        KtNamedDeclaration function2 = (element2 = LightClassUtilsKt.getUnwrapped((PsiElement)this.getPsiElement())) instanceof KtNamedDeclaration ? (KtNamedDeclaration)element2 : (KtDeclaration)((KtLightMethod)element2).getKotlinOrigin();
        boolean isActual = function2 != null && PsiUtilsKt.hasActualModifier((KtModifierListOwner)function2);
        KotlinFunctionFindUsagesOptions options = this.getFindUsagesOptions();
        if (isActual) {
            this.expectedUsages = this.addCheckboxToPanel(KotlinIndependentBundle.message("find.usages.checkbox.name.expected.functions", new Object[0]), options.getSearchExpected(), optionsPanel, false);
        }
    }

    public void calcFindUsagesOptions(JavaMethodFindUsagesOptions options) {
        super.calcFindUsagesOptions(options);
        KotlinFunctionFindUsagesOptions kotlinOptions = (KotlinFunctionFindUsagesOptions)options;
        if (this.expectedUsages != null) {
            kotlinOptions.setSearchExpected(this.expectedUsages.isSelected());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/idea/findUsages/dialogs/KotlinFindFunctionUsagesDialog";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coloredComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFindUsagesOptions";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/idea/findUsages/dialogs/KotlinFindFunctionUsagesDialog";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "configureLabelComponent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

