/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.refactoring;

import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.refactoring.JSDefaultRenameProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewTypeLocation;
import com.intellij.util.IncorrectOperationException;
import org.angularjs.AngularJSBundle;
import org.angularjs.codeInsight.DirectiveUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AngularJSDirectiveRenameProcessor
extends JSDefaultRenameProcessor {
    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            AngularJSDirectiveRenameProcessor.$$$reportNull$$$0(0);
        }
        return DirectiveUtil.getDirective(element) != null;
    }

    @Nullable
    public PsiElement substituteElementToRename(@NotNull PsiElement element, @Nullable Editor editor) {
        if (element == null) {
            AngularJSDirectiveRenameProcessor.$$$reportNull$$$0(1);
        }
        return DirectiveUtil.getDirective(element);
    }

    public void renameElement(@NotNull PsiElement element, @NotNull String newName, UsageInfo @NotNull [] usages, @Nullable RefactoringElementListener listener) throws IncorrectOperationException {
        String directiveName;
        String attributeName;
        if (element == null) {
            AngularJSDirectiveRenameProcessor.$$$reportNull$$$0(2);
        }
        if (newName == null) {
            AngularJSDirectiveRenameProcessor.$$$reportNull$$$0(3);
        }
        if (usages == null) {
            AngularJSDirectiveRenameProcessor.$$$reportNull$$$0(4);
        }
        PsiNamedElement directive = (PsiNamedElement)element;
        if (newName.contains("-")) {
            attributeName = newName;
            directiveName = DirectiveUtil.normalizeAttributeName(newName);
        } else {
            attributeName = DirectiveUtil.getAttributeName(newName);
            directiveName = newName;
        }
        for (UsageInfo usage : usages) {
            RenameUtil.rename((UsageInfo)usage, (String)attributeName);
        }
        directive.setName(directiveName);
        if (listener != null) {
            listener.elementRenamed(element);
        }
    }

    @NotNull
    public RenameDialog createRenameDialog(@NotNull Project project, @NotNull PsiElement element, PsiElement nameSuggestionContext, Editor editor) {
        if (project == null) {
            AngularJSDirectiveRenameProcessor.$$$reportNull$$$0(5);
        }
        if (element == null) {
            AngularJSDirectiveRenameProcessor.$$$reportNull$$$0(6);
        }
        final String directiveName = ((PsiNamedElement)element).getName();
        return new RenameDialog(project, element, nameSuggestionContext, editor){

            public String[] getSuggestedNames() {
                return new String[]{directiveName};
            }

            protected boolean areButtonsValid() {
                return true;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "org/angularjs/refactoring/AngularJSDirectiveRenameProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canProcessElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "substituteElementToRename";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "renameElement";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "createRenameDialog";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class AngularJSDirectiveElementDescriptor
    implements ElementDescriptionProvider {
        @Nullable
        public String getElementDescription(@NotNull PsiElement element, @NotNull ElementDescriptionLocation location) {
            JSImplicitElement directive;
            if (element == null) {
                AngularJSDirectiveElementDescriptor.$$$reportNull$$$0(0);
            }
            if (location == null) {
                AngularJSDirectiveElementDescriptor.$$$reportNull$$$0(1);
            }
            if ((directive = DirectiveUtil.getDirective(element)) != null) {
                if (location instanceof UsageViewTypeLocation) {
                    return AngularJSBundle.message("angularjs.symbol.directive", new Object[0]);
                }
                return directive.getName();
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "location";
                    break;
                }
            }
            objectArray[1] = "org/angularjs/refactoring/AngularJSDirectiveRenameProcessor$AngularJSDirectiveElementDescriptor";
            objectArray[2] = "getElementDescription";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

