/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.index;

import com.intellij.lang.javascript.psi.JSImplicitElementProvider;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElementStructure;
import com.intellij.lang.javascript.psi.stubs.JSImplicitItem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharSequenceSubSequence;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import one.util.streamex.StreamEx;
import org.angularjs.index.AngularDirectivesDocIndex;
import org.angularjs.index.AngularDirectivesIndex;
import org.angularjs.index.AngularIndexUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AngularJSDirectivesSupport {
    private static final String INDEX_TAG_NAME_PREFIX = ">";
    private static final String INDEX_ANY_TAG_NAME = "T";
    private static final String INDEX_ATTRIBUTE_NAME_PREFIX = "=";
    private static final String INDEX_ANY_ATTRIBUTE_NAME = "A";

    @NotNull
    public static List<JSImplicitElement> findTagDirectives(@NotNull Project project, @Nullable String tagName) {
        if (project == null) {
            AngularJSDirectivesSupport.$$$reportNull$$$0(0);
        }
        List list = ContainerUtil.filter(AngularJSDirectivesSupport.findDirectivesCandidates(project, AngularJSDirectivesSupport.getTagDirectiveIndexName(tagName)), AngularJSDirectivesSupport::isTagDirective);
        if (list == null) {
            AngularJSDirectivesSupport.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public static List<JSImplicitElement> findAttributeDirectives(@NotNull Project project, @Nullable String attributeName) {
        if (project == null) {
            AngularJSDirectivesSupport.$$$reportNull$$$0(2);
        }
        return AngularJSDirectivesSupport.findDirectivesCandidates(project, AngularJSDirectivesSupport.getAttributeDirectiveIndexName(attributeName));
    }

    @Nullable
    public static JSImplicitElement findDirective(@NotNull Project project, @NotNull String name) {
        if (project == null) {
            AngularJSDirectivesSupport.$$$reportNull$$$0(3);
        }
        if (name == null) {
            AngularJSDirectivesSupport.$$$reportNull$$$0(4);
        }
        return ((StreamEx)((StreamEx)StreamEx.of(AngularJSDirectivesSupport.findTagDirectives(project, name)).append(AngularJSDirectivesSupport.findAttributeDirectives(project, name)).filter(directive -> name.equals(directive.getName()))).sortedBy(JSImplicitItem::getUserString)).findFirst().orElse(null);
    }

    public static List<String> getDirectiveIndexKeys(@NotNull JSImplicitElementStructure directive) {
        if (directive == null) {
            AngularJSDirectivesSupport.$$$reportNull$$$0(5);
        }
        String restrictions = directive.getTypeString();
        SmartList result = new SmartList();
        String name = directive.getName();
        boolean isAttribute = false;
        boolean isTag = false;
        if (restrictions == null) {
            isAttribute = true;
        } else {
            int semicolon = restrictions.indexOf(59);
            if (semicolon < 0) {
                isAttribute = true;
            } else {
                CharSequenceSubSequence restrict = new CharSequenceSubSequence((CharSequence)restrictions, 0, semicolon);
                if (StringUtil.isEmpty((CharSequence)restrict)) {
                    isAttribute = true;
                } else {
                    if (Strings.indexOfIgnoreCase((CharSequence)restrict, (CharSequence)INDEX_ANY_ATTRIBUTE_NAME, (int)0) >= 0) {
                        isAttribute = true;
                    }
                    if (StringUtil.equals((CharSequence)"D", (CharSequence)restrict) || Strings.indexOfIgnoreCase((CharSequence)restrict, (CharSequence)"E", (int)0) >= 0) {
                        isTag = true;
                    }
                }
            }
        }
        if (isAttribute) {
            result.add(AngularJSDirectivesSupport.getAttributeDirectiveIndexName(null));
            result.add(AngularJSDirectivesSupport.getAttributeDirectiveIndexName(name));
        }
        if (isTag) {
            result.add(AngularJSDirectivesSupport.getTagDirectiveIndexName(name));
            result.add(AngularJSDirectivesSupport.getTagDirectiveIndexName(null));
        }
        return result;
    }

    public static boolean isTagDirective(@NotNull JSImplicitElement directive) {
        String restrictions;
        if (directive == null) {
            AngularJSDirectivesSupport.$$$reportNull$$$0(6);
        }
        if ((restrictions = directive.getTypeString()) != null) {
            CharSequence restrict = AngularIndexUtil.convertRestrictions(directive.getProject(), restrictions.subSequence(0, restrictions.indexOf(59)));
            return !StringUtil.isEmpty((CharSequence)restrict) && Strings.indexOfIgnoreCase((CharSequence)restrict, (CharSequence)"E", (int)0) >= 0;
        }
        return false;
    }

    public static boolean isDirective(@NotNull JSImplicitElement directive) {
        String userString;
        if (directive == null) {
            AngularJSDirectivesSupport.$$$reportNull$$$0(7);
        }
        return "adi".equals(userString = directive.getUserString()) || "addi".equals(userString);
    }

    @NotNull
    private static List<JSImplicitElement> findDirectivesCandidates(@NotNull Project project, @NotNull String indexLookupName) {
        if (project == null) {
            AngularJSDirectivesSupport.$$$reportNull$$$0(8);
        }
        if (indexLookupName == null) {
            AngularJSDirectivesSupport.$$$reportNull$$$0(9);
        }
        ArrayList<JSImplicitElement> result = new ArrayList<JSImplicitElement>();
        HashSet documentedDirectives = new HashSet();
        AngularJSDirectivesSupport.processDirectivesFromIndex(project, AngularDirectivesDocIndex.KEY, indexLookupName, directive -> {
            result.add((JSImplicitElement)directive);
            documentedDirectives.add(directive.getName());
        });
        AngularJSDirectivesSupport.processDirectivesFromIndex(project, AngularDirectivesIndex.KEY, indexLookupName, directive -> {
            if (!documentedDirectives.contains(directive.getName())) {
                result.add((JSImplicitElement)directive);
            }
        });
        ArrayList<JSImplicitElement> arrayList = result;
        if (arrayList == null) {
            AngularJSDirectivesSupport.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    private static void processDirectivesFromIndex(@NotNull Project project, StubIndexKey<String, JSImplicitElementProvider> key, @NotNull String indexLookupName, Consumer<JSImplicitElement> consumer) {
        if (project == null) {
            AngularJSDirectivesSupport.$$$reportNull$$$0(11);
        }
        if (indexLookupName == null) {
            AngularJSDirectivesSupport.$$$reportNull$$$0(12);
        }
        StubIndex.getInstance().processElements(key, (Object)indexLookupName, project, GlobalSearchScope.allScope((Project)project), JSImplicitElementProvider.class, provider -> {
            Collection elements;
            JSElementIndexingData indexingData = provider.getIndexingData();
            if (indexingData != null && (elements = indexingData.getImplicitElements()) != null) {
                for (JSImplicitElement element : elements) {
                    if (!element.isValid() || !AngularJSDirectivesSupport.isDirective(element)) continue;
                    consumer.accept(element);
                }
            }
            return true;
        });
    }

    @NotNull
    private static String getTagDirectiveIndexName(@Nullable String tagName) {
        return tagName != null ? INDEX_TAG_NAME_PREFIX + tagName : INDEX_ANY_TAG_NAME;
    }

    @NotNull
    private static String getAttributeDirectiveIndexName(@Nullable String attributeName) {
        return attributeName != null ? INDEX_ATTRIBUTE_NAME_PREFIX + attributeName : INDEX_ANY_ATTRIBUTE_NAME;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/angularjs/index/AngularJSDirectivesSupport";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directive";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexLookupName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/angularjs/index/AngularJSDirectivesSupport";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "findTagDirectives";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findDirectivesCandidates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findTagDirectives";
                break;
            }
            case 1: 
            case 10: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findAttributeDirectives";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findDirective";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDirectiveIndexKeys";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isTagDirective";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isDirective";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findDirectivesCandidates";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processDirectivesFromIndex";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

