/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.diagram;

import com.intellij.diagram.DiagramEdge;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.view.Arrow;
import com.intellij.openapi.graph.view.EdgeRealizer;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.LineType;
import com.intellij.openapi.graph.view.QuadCurveEdgeRealizer;
import com.intellij.ui.Gray;
import com.intellij.uml.UmlGraphBuilder;
import java.awt.Color;
import java.util.List;
import org.angularjs.codeInsight.router.AngularUiRouterEdge;
import org.angularjs.codeInsight.router.AngularUiRouterNode;
import org.angularjs.codeInsight.router.DiagramObject;

final class AngularEdgeLayouter {
    AngularEdgeLayouter() {
    }

    public void layoutEdges(UmlGraphBuilder umlGraphBuilder, Graph2D graph) {
        Edge[] edgeArray;
        for (Edge edge : edgeArray = graph.getEdgeArray()) {
            DiagramEdge edgeObject = (DiagramEdge)umlGraphBuilder.getEdgeObject(edge);
            if (!(edgeObject instanceof AngularUiRouterEdge)) continue;
            OneEdgeLayouter oneEdgeLayouter = new OneEdgeLayouter(edge, (AngularUiRouterEdge)edgeObject, graph);
            oneEdgeLayouter.calculateEdgeLayout();
            graph.setRealizer(edge, (EdgeRealizer)oneEdgeLayouter.myRealizer);
            GraphManager gm = GraphManager.getGraphManager();
            graph.setEndPointsAbs(edge, gm.createYPoint(oneEdgeLayouter.sourceX, oneEdgeLayouter.sourceY), gm.createYPoint(oneEdgeLayouter.targetX, oneEdgeLayouter.targetY));
        }
    }

    static final class OneEdgeLayouter {
        private final Edge edge;
        private final AngularUiRouterEdge edgeObject;
        private final double sourceXcenter;
        private final double sourceYcenter;
        private final double targetXcenter;
        private final double targetYcenter;
        private final double sourceWidth;
        private final double targetWidth;
        private final double sourceHeight;
        private final double targetHeight;
        private double sourceX;
        private double targetX;
        private double sourceY;
        private double targetY;
        private QuadCurveEdgeRealizer myRealizer;

        OneEdgeLayouter(Edge edge, AngularUiRouterEdge edgeObject, Graph2D graph) {
            this.edge = edge;
            this.edgeObject = edgeObject;
            this.sourceXcenter = graph.getCenterX(edge.source());
            this.targetXcenter = graph.getCenterX(edge.target());
            this.sourceYcenter = graph.getCenterY(edge.source());
            this.targetYcenter = graph.getCenterY(edge.target());
            this.sourceWidth = graph.getWidth(edge.source());
            this.targetWidth = graph.getWidth(edge.target());
            this.sourceHeight = graph.getHeight(edge.source());
            this.targetHeight = graph.getHeight(edge.target());
        }

        public void calculateEdgeLayout() {
            if (this.edgeObject == null) {
                return;
            }
            this.myRealizer = GraphManager.getGraphManager().createQuadCurveEdgeRealizer();
            this.myRealizer.setLineColor((Color)Gray._170);
            this.myRealizer.setSourceArrow(Arrow.SHORT);
            AngularUiRouterNode source = (AngularUiRouterNode)this.edgeObject.getSource();
            AngularUiRouterNode target = (AngularUiRouterNode)this.edgeObject.getTarget();
            boolean sourceOnTheLeft = this.sourceXcenter < this.targetXcenter;
            int idxSource = -1;
            int idxTarget = -1;
            if (AngularUiRouterEdge.Type.parent.equals((Object)this.edgeObject.getType())) {
                this.myRealizer.setLineType(LineType.DOTTED_1);
            } else {
                if (AngularUiRouterEdge.Type.fillsTemplate.equals((Object)this.edgeObject.getType())) {
                    this.myRealizer.setLineType(LineType.DASHED_1);
                }
                idxSource = OneEdgeLayouter.getOffsetInElements(source, this.edgeObject.getSourceName());
                idxTarget = OneEdgeLayouter.getOffsetInElements(target, this.edgeObject.getTargetName());
            }
            this.sourceX = sourceOnTheLeft ? this.sourceXcenter + this.sourceWidth / 2.0 : this.sourceXcenter - this.sourceWidth / 2.0;
            this.targetX = sourceOnTheLeft ? this.targetXcenter - this.targetWidth / 2.0 : this.targetXcenter + this.targetWidth / 2.0;
            int sourceSize = source.getIdentifyingElement().getChildrenList().size();
            double step = this.sourceHeight / (double)(sourceSize + 1);
            this.sourceY += sourceSize == 0 || idxSource < 0 ? step * 0.5 : (double)idxSource * step + step * 1.5;
            int targetSize = target.getIdentifyingElement().getChildrenList().size();
            double targetStep = this.targetHeight / (double)(targetSize + 1);
            this.targetY += targetSize == 0 || idxTarget < 0 ? targetStep * 0.5 : (double)idxTarget * targetStep + targetStep * 1.5;
        }

        private static int getOffsetInElements(AngularUiRouterNode node, String name) {
            List<DiagramObject> list = node.getIdentifyingElement().getChildrenList();
            int idx = -1;
            if (name != null && list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    DiagramObject object = list.get(i);
                    if (!object.getName().equals(name)) continue;
                    idx = i;
                    break;
                }
            }
            return idx;
        }

        public double getSourceX() {
            return this.sourceX;
        }

        public double getTargetX() {
            return this.targetX;
        }

        public double getSourceY() {
            return this.sourceY;
        }

        public double getTargetY() {
            return this.targetY;
        }

        public QuadCurveEdgeRealizer getRealizer() {
            return this.myRealizer;
        }
    }
}

