/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.codeInsight.router;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.angularjs.codeInsight.router.AngularUiRouterNode;
import org.angularjs.codeInsight.router.Type;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DiagramObject {
    @NotNull
    private Type myType;
    @NotNull
    @NlsSafe
    private final String myName;
    @Nullable
    @Nls
    private String myTooltip;
    @Nullable
    private final SmartPsiElementPointer<?> myNavigationTarget;
    private boolean myIsValid;
    @NotNull
    private final List<String> myNotes;
    @NotNull
    private final List<String> myWarnings;
    @NotNull
    private final List<String> myErrors;
    private final Map<String, DiagramObject> myChildren;
    private final List<String> myChildOrder;
    private AngularUiRouterNode myContainer;
    private String myParentName;

    public DiagramObject(@NotNull Type type, @NotNull String name, @Nullable SmartPsiElementPointer<?> navigationTarget) {
        if (type == null) {
            DiagramObject.$$$reportNull$$$0(0);
        }
        if (name == null) {
            DiagramObject.$$$reportNull$$$0(1);
        }
        this.myIsValid = true;
        this.myType = type;
        this.myName = name;
        this.myNavigationTarget = navigationTarget;
        this.myWarnings = new SmartList();
        this.myErrors = new SmartList();
        this.myNotes = new SmartList();
        this.myChildren = new HashMap<String, DiagramObject>();
        this.myChildOrder = new ArrayList<String>();
    }

    public void addChild(@NotNull DiagramObject child, AngularUiRouterNode parent) {
        if (child == null) {
            DiagramObject.$$$reportNull$$$0(2);
        }
        this.myChildren.put(child.getName(), child);
        child.myContainer = parent;
        this.myChildOrder.add(child.getName());
    }

    public List<DiagramObject> getChildrenList() {
        ArrayList<DiagramObject> list = new ArrayList<DiagramObject>();
        for (String s : this.myChildOrder) {
            list.add(this.myChildren.get(s));
        }
        return list;
    }

    public AngularUiRouterNode getContainer() {
        return this.myContainer;
    }

    @NotNull
    public Type getType() {
        Type type = this.myType;
        if (type == null) {
            DiagramObject.$$$reportNull$$$0(3);
        }
        return type;
    }

    @NotNull
    @NlsSafe
    public String getName() {
        String string = this.myName;
        if (string == null) {
            DiagramObject.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    public SmartPsiElementPointer<?> getNavigationTarget() {
        return this.myNavigationTarget;
    }

    public void addError(@NotNull String error) {
        if (error == null) {
            DiagramObject.$$$reportNull$$$0(5);
        }
        this.myErrors.add(error);
        this.myIsValid = false;
    }

    public void addWarning(@NotNull String warning) {
        if (warning == null) {
            DiagramObject.$$$reportNull$$$0(6);
        }
        this.myWarnings.add(warning);
        this.myIsValid = false;
    }

    public void addNote(@NotNull String note) {
        if (note == null) {
            DiagramObject.$$$reportNull$$$0(7);
        }
        this.myNotes.add(note);
    }

    public boolean isValid() {
        return this.myIsValid;
    }

    @NotNull
    public List<String> getErrors() {
        List<String> list = this.myErrors;
        if (list == null) {
            DiagramObject.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    public List<String> getWarnings() {
        List<String> list = this.myWarnings;
        if (list == null) {
            DiagramObject.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    public List<String> getNotes() {
        List<String> list = this.myNotes;
        if (list == null) {
            DiagramObject.$$$reportNull$$$0(10);
        }
        return list;
    }

    @NotNull
    @Nls
    public String getTooltip() {
        String string = this.myTooltip == null ? this.myName : this.myTooltip;
        if (string == null) {
            DiagramObject.$$$reportNull$$$0(11);
        }
        return string;
    }

    public void setTooltip(@Nls @Nullable String tooltip) {
        this.myTooltip = tooltip;
    }

    public void setType(@NotNull Type type) {
        if (type == null) {
            DiagramObject.$$$reportNull$$$0(12);
        }
        this.myType = type;
    }

    public String getParent() {
        return this.myParentName;
    }

    public void setParent(String parentName) {
        this.myParentName = parentName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DiagramObject object = (DiagramObject)o;
        if (this.myType != object.myType) {
            return false;
        }
        if (!this.myName.equals(object.myName)) {
            return false;
        }
        if (!Objects.equals(this.myTooltip, object.myTooltip)) {
            return false;
        }
        if (!Objects.equals(this.myNavigationTarget, object.myNavigationTarget)) {
            return false;
        }
        return Objects.equals((Object)this.myContainer, (Object)object.myContainer);
    }

    public int hashCode() {
        int result = this.myType.hashCode();
        result = 31 * result + this.myName.hashCode();
        result = 31 * result + (this.myTooltip != null ? this.myTooltip.hashCode() : 0);
        result = 31 * result + (this.myContainer != null ? this.myContainer.hashCode() : 0);
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/angularjs/codeInsight/router/DiagramObject";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "warning";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "note";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/angularjs/codeInsight/router/DiagramObject";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrors";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getWarnings";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotes";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTooltip";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addChild";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addError";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addWarning";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addNote";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

