/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.codeInsight.router;

import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.angularjs.AngularJSBundle;
import org.angularjs.codeInsight.router.AngularUiRouterDiagramBuilder;
import org.angularjs.codeInsight.router.AngularUiRouterEdge;
import org.angularjs.codeInsight.router.AngularUiRouterNode;
import org.angularjs.codeInsight.router.DiagramObject;
import org.angularjs.codeInsight.router.RootTemplate;
import org.angularjs.codeInsight.router.Template;
import org.angularjs.codeInsight.router.Type;
import org.angularjs.codeInsight.router.UiRouterState;
import org.angularjs.codeInsight.router.UiView;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AngularUiRouterGraphBuilder {
    @NotNull
    private final Project myProject;
    private final Map<String, UiRouterState> myStatesMap;
    private final Map<VirtualFile, Template> myTemplatesMap;
    @Nullable
    private final RootTemplate myRootTemplate;
    private final VirtualFile myKey;

    public AngularUiRouterGraphBuilder(@NotNull Project project, @NotNull Map<String, UiRouterState> statesMap, @NotNull Map<VirtualFile, Template> templatesMap, @Nullable RootTemplate rootTemplate, VirtualFile key) {
        if (project == null) {
            AngularUiRouterGraphBuilder.$$$reportNull$$$0(0);
        }
        if (statesMap == null) {
            AngularUiRouterGraphBuilder.$$$reportNull$$$0(1);
        }
        if (templatesMap == null) {
            AngularUiRouterGraphBuilder.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myStatesMap = statesMap;
        this.myTemplatesMap = templatesMap;
        this.myRootTemplate = rootTemplate;
        this.myKey = key;
    }

    public VirtualFile getKey() {
        return this.myKey;
    }

    public GraphNodesBuilder createDataModel(@NotNull DiagramProvider<DiagramObject> provider) {
        if (provider == null) {
            AngularUiRouterGraphBuilder.$$$reportNull$$$0(3);
        }
        GraphNodesBuilder nodesBuilder = new GraphNodesBuilder(this.myStatesMap, this.myTemplatesMap, this.myRootTemplate, this.myKey);
        nodesBuilder.build(provider, this.myProject);
        return nodesBuilder;
    }

    public static String normalizeTemplateUrl(@Nullable String url) {
        if (url == null) {
            return null;
        }
        url = url.startsWith("/") ? url.substring(1) : url;
        url = url.endsWith("/") ? url.substring(0, url.length() - 1) : url;
        return url;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statesMap";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templatesMap";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
        }
        objectArray2[1] = "org/angularjs/codeInsight/router/AngularUiRouterGraphBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createDataModel";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class GraphNodesBuilder {
        public static final String DEFAULT = "$default";
        @NotNull
        private final Map<String, UiRouterState> myStatesMap;
        @NotNull
        private final Map<VirtualFile, Template> myTemplatesMap;
        @Nullable
        private final RootTemplate myRootTemplate;
        private final VirtualFile myKey;
        private AngularUiRouterNode myRootNode;
        private final Map<String, AngularUiRouterNode> stateNodes;
        private final Map<String, AngularUiRouterNode> templateNodes;
        private final Map<Pair<String, String>, DiagramObject> templatePlaceHoldersNodes;
        private final Map<Pair<String, String>, DiagramObject> viewNodes;
        private final List<AngularUiRouterEdge> edges;
        private final List<AngularUiRouterNode> allNodes;

        public GraphNodesBuilder(@NotNull Map<String, UiRouterState> statesMap, @NotNull Map<VirtualFile, Template> templatesMap, @Nullable RootTemplate rootTemplate, VirtualFile key) {
            if (statesMap == null) {
                GraphNodesBuilder.$$$reportNull$$$0(0);
            }
            if (templatesMap == null) {
                GraphNodesBuilder.$$$reportNull$$$0(1);
            }
            this.stateNodes = new HashMap<String, AngularUiRouterNode>();
            this.templateNodes = new HashMap<String, AngularUiRouterNode>();
            this.templatePlaceHoldersNodes = new HashMap<Pair<String, String>, DiagramObject>();
            this.viewNodes = new HashMap<Pair<String, String>, DiagramObject>();
            this.edges = new ArrayList<AngularUiRouterEdge>();
            this.allNodes = new ArrayList<AngularUiRouterNode>();
            this.myStatesMap = statesMap;
            this.myTemplatesMap = templatesMap;
            this.myRootTemplate = rootTemplate;
            this.myKey = key;
        }

        public AngularUiRouterNode getRootNode() {
            return this.myRootNode;
        }

        public VirtualFile getKey() {
            return this.myKey;
        }

        public void build(@NotNull DiagramProvider<DiagramObject> provider, @NotNull Project project) {
            String name;
            List<UiView> views;
            AngularUiRouterNode node;
            UiRouterState state;
            if (provider == null) {
                GraphNodesBuilder.$$$reportNull$$$0(2);
            }
            if (project == null) {
                GraphNodesBuilder.$$$reportNull$$$0(3);
            }
            if (this.myRootTemplate != null) {
                this.myRootNode = this.getOrCreateTemplateNode(provider, this.myKey, AngularUiRouterGraphBuilder.normalizeTemplateUrl(this.myRootTemplate.getRelativeUrl()), this.myRootTemplate.getTemplate());
                this.myRootNode.getIdentifyingElement().setType(Type.topLevelTemplate);
            } else {
                PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(this.myKey);
                DiagramObject rootDiagramObject = new DiagramObject(Type.topLevelTemplate, this.myKey.getName(), psiFile == null ? null : SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer((PsiElement)psiFile));
                this.myRootNode = new AngularUiRouterNode(rootDiagramObject, provider);
            }
            this.setParentStates();
            for (Map.Entry entry : this.myStatesMap.entrySet()) {
                PsiElement element;
                state = (UiRouterState)entry.getValue();
                DiagramObject stateObject = new DiagramObject(Type.state, state.getName(), state.getPointer());
                if (state.getParentName() != null) {
                    stateObject.setParent(state.getParentName());
                }
                if (state.getPointer() == null) {
                    stateObject.addError(AngularJSBundle.message("angularjs.ui.router.diagram.error.cant.find.state.definition", new Object[0]));
                }
                AngularUiRouterNode node2 = new AngularUiRouterNode(stateObject, provider);
                this.stateNodes.put(state.getName(), node2);
                Iterator<UiView> templateUrl = AngularUiRouterGraphBuilder.normalizeTemplateUrl(state.getTemplateUrl());
                if (templateUrl != null && !state.hasViews()) {
                    AngularUiRouterNode templateNode = this.getOrCreateTemplateNode(provider, state.getTemplateFile(), (String)((Object)templateUrl), null);
                    this.edges.add(new AngularUiRouterEdge((DiagramNode<DiagramObject>)templateNode, (DiagramNode<DiagramObject>)node2, AngularJSBundle.message("angularjs.ui.router.diagram.edge.provides", new Object[0]), AngularUiRouterEdge.Type.providesTemplate));
                } else if (state.isHasTemplateDefined() && state.getTemplatePointer() != null && (element = state.getTemplatePointer().getElement()) != null && element.isValid()) {
                    AngularUiRouterNode localTemplateNode = this.createLocalTemplate(element, provider);
                    this.edges.add(new AngularUiRouterEdge((DiagramNode<DiagramObject>)localTemplateNode, (DiagramNode<DiagramObject>)node2, AngularJSBundle.message("angularjs.ui.router.diagram.edge.provides", new Object[0]), AngularUiRouterEdge.Type.providesTemplate));
                }
                if (state.hasViews()) {
                    if (state.isAbstract()) {
                        stateObject.addWarning(AngularJSBundle.message("angularjs.ui.router.diagram.warning.abstract.state", new Object[0]));
                    } else if (templateUrl != null || state.isHasTemplateDefined()) {
                        stateObject.addWarning(AngularJSBundle.message("angularjs.ui.router.diagram.warning.views.are.defined", new Object[0]));
                    }
                }
                if (!state.isHasTemplateDefined() || state.getTemplatePointer() != null) continue;
                stateObject.addNote(AngularJSBundle.message("angularjs.ui.router.diagram.note.has.embedded.template.definition", new Object[0]));
            }
            for (Map.Entry entry : this.myStatesMap.entrySet()) {
                state = (UiRouterState)entry.getValue();
                node = this.stateNodes.get(state.getName());
                assert (node != null);
                views = state.getViews();
                if (views == null || views.isEmpty()) continue;
                for (UiView view : views) {
                    PsiElement element;
                    name = StringUtil.isEmptyOrSpaces((String)view.getName()) ? DEFAULT : view.getName();
                    DiagramObject viewObject = new DiagramObject(Type.view, name, view.getPointer());
                    this.viewNodes.put((Pair<String, String>)Pair.create((Object)state.getName(), (Object)name), viewObject);
                    String template = view.getTemplate();
                    if (!StringUtil.isEmptyOrSpaces((String)template)) {
                        AngularUiRouterNode templateNode = this.getOrCreateTemplateNode(provider, view.getTemplateFile(), template, null);
                        this.edges.add(new AngularUiRouterEdge((DiagramNode<DiagramObject>)templateNode, (DiagramNode<DiagramObject>)node, AngularJSBundle.message("angularjs.ui.router.diagram.edge.smth.provides", name), AngularUiRouterEdge.Type.providesTemplate).setTargetName(name));
                    } else if (view.getTemplatePointer() != null && (element = view.getTemplatePointer().getElement()) != null && element.isValid()) {
                        AngularUiRouterNode localTemplateNode = this.createLocalTemplate(element, provider);
                        this.edges.add(new AngularUiRouterEdge((DiagramNode<DiagramObject>)localTemplateNode, (DiagramNode<DiagramObject>)node, AngularJSBundle.message("angularjs.ui.router.diagram.edge.smth.provides", name), AngularUiRouterEdge.Type.providesTemplate).setTargetName(name));
                    }
                    node.getIdentifyingElement().addChild(viewObject, node);
                }
            }
            for (Map.Entry entry : this.myStatesMap.entrySet()) {
                state = (UiRouterState)entry.getValue();
                node = this.stateNodes.get(state.getName());
                assert (node != null);
                views = state.getViews();
                if (views != null && !views.isEmpty()) {
                    for (UiView view : views) {
                        name = StringUtil.isEmptyOrSpaces((String)view.getName()) ? DEFAULT : view.getName();
                        DiagramObject viewNode = this.viewNodes.get(Pair.create((Object)state.getName(), (Object)name));
                        assert (viewNode != null);
                        Pair<AngularUiRouterNode, String> pair = this.getParentTemplateNode(state.getName(), view.getName());
                        if (pair == null || pair.getFirst() == null) continue;
                        this.connectViewOrStateWithPlaceholder(node, name, pair);
                    }
                    continue;
                }
                Pair<AngularUiRouterNode, String> pair = this.getParentTemplateNode(state.getName(), "");
                if (pair == null || pair.getFirst() == null) continue;
                this.connectViewOrStateWithPlaceholder(node, DEFAULT, pair);
            }
            this.createStateParentEdges();
            ArrayList<AngularUiRouterNode> list = new ArrayList<AngularUiRouterNode>();
            list.add(this.myRootNode);
            list.addAll(this.stateNodes.values());
            list.addAll(this.templateNodes.values());
            for (AngularUiRouterNode node3 : list) {
                if (this.allNodes.contains((Object)node3)) continue;
                this.allNodes.add(node3);
            }
        }

        private AngularUiRouterNode createLocalTemplate(PsiElement element, DiagramProvider<DiagramObject> provider) {
            String name = element.getContainingFile().getName() + " (" + AngularJSBundle.message("angularjs.ui.router.diagram.node.name.local", new Object[0]) + ")";
            @NlsSafe String key = element.getContainingFile().getVirtualFile().getUrl() + ":" + element.getTextRange().getStartOffset();
            Template template = AngularUiRouterDiagramBuilder.readTemplateFromFile(element.getProject(), name, element);
            if (!this.templateNodes.containsKey(key)) {
                DiagramObject templateObject = new DiagramObject(Type.template, name, template.getPointer());
                AngularUiRouterNode templateNode = new AngularUiRouterNode(templateObject, provider);
                this.templateNodes.put(key, templateNode);
                this.putPlaceholderNodes(key, template, templateNode);
            }
            AngularUiRouterNode templateNode = this.templateNodes.get(key);
            assert (templateNode != null);
            templateNode.getIdentifyingElement().setTooltip(key);
            return templateNode;
        }

        private void connectViewOrStateWithPlaceholder(AngularUiRouterNode stateNode, String viewName, Pair<AngularUiRouterNode, String> pair) {
            String parentState;
            UiRouterState parentStateObject;
            String placeholderName = (String)pair.getSecond();
            String usedTemplateUrl = null;
            Type nodeType = ((AngularUiRouterNode)((Object)pair.getFirst())).getIdentifyingElement().getType();
            if (Type.template.equals((Object)nodeType) || Type.topLevelTemplate.equals((Object)nodeType)) {
                usedTemplateUrl = ((AngularUiRouterNode)((Object)pair.getFirst())).getIdentifyingElement().getTooltip();
            } else if (Type.state.equals((Object)nodeType) && (parentStateObject = this.myStatesMap.get(parentState = ((AngularUiRouterNode)((Object)pair.getFirst())).getIdentifyingElement().getName())) != null) {
                if (parentStateObject.hasViews()) {
                    List<UiView> parentViews = parentStateObject.getViews();
                    for (UiView parentView : parentViews) {
                        if (!placeholderName.equals(parentView.getName())) continue;
                        usedTemplateUrl = parentView.getTemplate();
                        break;
                    }
                } else if (!StringUtil.isEmptyOrSpaces((String)parentStateObject.getTemplateUrl())) {
                    usedTemplateUrl = parentStateObject.getTemplateUrl();
                }
            }
            usedTemplateUrl = AngularUiRouterGraphBuilder.normalizeTemplateUrl(usedTemplateUrl);
            DiagramObject placeholder = this.templatePlaceHoldersNodes.get(Pair.create((Object)usedTemplateUrl, (Object)placeholderName));
            if (placeholder != null && placeholder.getContainer() != null) {
                AngularUiRouterEdge edge = new AngularUiRouterEdge((DiagramNode<DiagramObject>)placeholder.getContainer(), (DiagramNode<DiagramObject>)stateNode, AngularJSBundle.message("angularjs.ui.router.diagram.edge.smth.populates.smth", viewName, placeholderName), AngularUiRouterEdge.Type.fillsTemplate).setSourceName(placeholderName).setTargetName(viewName);
                edge.setTargetAnchor(placeholder);
                this.edges.add(edge);
            }
        }

        private void createStateParentEdges() {
            for (Map.Entry<String, AngularUiRouterNode> entry : this.stateNodes.entrySet()) {
                AngularUiRouterNode parentState;
                String key = entry.getKey();
                UiRouterState state = this.myStatesMap.get(key);
                if (state == null || state.getParentName() == null || (parentState = this.stateNodes.get(state.getParentName())) == null) continue;
                this.edges.add(new AngularUiRouterEdge((DiagramNode<DiagramObject>)parentState, (DiagramNode<DiagramObject>)((DiagramNode)entry.getValue()), "", AngularUiRouterEdge.Type.parent));
            }
        }

        private void setParentStates() {
            for (Map.Entry<String, UiRouterState> entry : this.myStatesMap.entrySet()) {
                String key;
                int dotIdx;
                if (!StringUtil.isEmptyOrSpaces((String)entry.getValue().getParentName()) || (dotIdx = (key = entry.getKey()).lastIndexOf(46)) <= 0) continue;
                String parentKey = key.substring(0, dotIdx);
                entry.getValue().setParentName(parentKey);
            }
        }

        public List<AngularUiRouterNode> getStateTemplates(@NotNull AngularUiRouterNode state) {
            if (state == null) {
                GraphNodesBuilder.$$$reportNull$$$0(4);
            }
            ArrayList<AngularUiRouterNode> list = new ArrayList<AngularUiRouterNode>();
            if (!Type.state.equals((Object)state.getIdentifyingElement().getType())) {
                return Collections.emptyList();
            }
            for (AngularUiRouterEdge edge : this.edges) {
                if (!AngularUiRouterEdge.Type.providesTemplate.equals((Object)edge.getType()) || !edge.getTarget().equals((Object)state) || !Type.template.equals((Object)((DiagramObject)edge.getSource().getIdentifyingElement()).getType())) continue;
                list.add((AngularUiRouterNode)edge.getSource());
            }
            return list;
        }

        public List<AngularUiRouterNode> getZeroLevelStates() {
            ArrayList<AngularUiRouterNode> list = new ArrayList<AngularUiRouterNode>();
            for (AngularUiRouterNode current : this.allNodes) {
                if (!Type.state.equals((Object)current.getIdentifyingElement().getType()) || current.getIdentifyingElement().getParent() != null) continue;
                list.add(current);
            }
            return list;
        }

        public List<AngularUiRouterNode> getImmediateChildrenStates(@NotNull AngularUiRouterNode node) {
            if (node == null) {
                GraphNodesBuilder.$$$reportNull$$$0(5);
            }
            if (this.myRootNode.equals((Object)node)) {
                return this.getZeroLevelStates();
            }
            String name = node.getIdentifyingElement().getName();
            ArrayList<AngularUiRouterNode> list = new ArrayList<AngularUiRouterNode>();
            DiagramObject diagramObject = node.getIdentifyingElement();
            if (!Type.state.equals((Object)diagramObject.getType())) {
                return Collections.emptyList();
            }
            for (AngularUiRouterNode current : this.allNodes) {
                if (!Type.state.equals((Object)current.getIdentifyingElement().getType()) || !name.equals(current.getIdentifyingElement().getParent())) continue;
                list.add(current);
            }
            return list;
        }

        public List<AngularUiRouterEdge> getEdges() {
            return this.edges;
        }

        public List<AngularUiRouterNode> getAllNodes() {
            return this.allNodes;
        }

        @Nullable
        private Pair<AngularUiRouterNode, String> getParentTemplateNode(@NotNull String state, @NotNull String view) {
            int idx;
            if (state == null) {
                GraphNodesBuilder.$$$reportNull$$$0(6);
            }
            if (view == null) {
                GraphNodesBuilder.$$$reportNull$$$0(7);
            }
            if ((idx = view.indexOf("@")) < 0) {
                if (state.contains(".") || this.myStatesMap.get(state).getParentName() != null) {
                    UiRouterState routerState = this.myStatesMap.get(state);
                    if (routerState == null) {
                        return null;
                    }
                    return Pair.create((Object)((Object)this.stateNodes.get(routerState.getParentName())), (Object)view);
                }
                return Pair.create((Object)((Object)this.myRootNode), (Object)view);
            }
            String placeholderName = view.substring(0, idx);
            String stateName = view.substring(idx + 1);
            if (StringUtil.isEmptyOrSpaces((String)stateName)) {
                return Pair.create((Object)((Object)this.myRootNode), (Object)placeholderName);
            }
            return Pair.create((Object)((Object)this.stateNodes.get(stateName)), (Object)placeholderName);
        }

        @NotNull
        private AngularUiRouterNode getOrCreateTemplateNode(DiagramProvider<DiagramObject> provider, @Nullable VirtualFile templateFile, @NotNull String templateUrl, @Nullable Template template) {
            String fullUrl;
            int idx;
            if (templateUrl == null) {
                GraphNodesBuilder.$$$reportNull$$$0(8);
            }
            templateUrl = (idx = (fullUrl = templateUrl).lastIndexOf(47)) >= 0 ? templateUrl.substring(idx + 1) : templateUrl;
            Template template2 = template = template == null && templateFile != null ? this.myTemplatesMap.get(templateFile) : template;
            if (template == null || template.getPointer() == null || templateFile == null) {
                AngularUiRouterNode templateNode = this.templateNodes.get(fullUrl);
                if (templateNode != null) {
                    AngularUiRouterNode angularUiRouterNode = templateNode;
                    if (angularUiRouterNode == null) {
                        GraphNodesBuilder.$$$reportNull$$$0(9);
                    }
                    return angularUiRouterNode;
                }
                DiagramObject templateObject = new DiagramObject(Type.template, templateUrl, null);
                templateObject.addError(AngularJSBundle.message("angularjs.ui.router.diagram.error.cant.find.template.file", new Object[0]));
                AngularUiRouterNode fictiveNode = new AngularUiRouterNode(templateObject, provider);
                fictiveNode.getIdentifyingElement().setTooltip(fullUrl);
                this.templateNodes.put(fullUrl, fictiveNode);
                AngularUiRouterNode angularUiRouterNode = fictiveNode;
                if (angularUiRouterNode == null) {
                    GraphNodesBuilder.$$$reportNull$$$0(10);
                }
                return angularUiRouterNode;
            }
            if (!this.templateNodes.containsKey(templateFile.getUrl())) {
                DiagramObject templateObject = new DiagramObject(Type.template, templateUrl, template.getPointer());
                AngularUiRouterNode templateNode = new AngularUiRouterNode(templateObject, provider);
                this.templateNodes.put(templateFile.getUrl(), templateNode);
                this.putPlaceholderNodes(fullUrl, template, templateNode);
            }
            AngularUiRouterNode templateNode = this.templateNodes.get(templateFile.getUrl());
            assert (templateNode != null);
            templateNode.getIdentifyingElement().setTooltip(fullUrl);
            AngularUiRouterNode angularUiRouterNode = templateNode;
            if (angularUiRouterNode == null) {
                GraphNodesBuilder.$$$reportNull$$$0(11);
            }
            return angularUiRouterNode;
        }

        private void putPlaceholderNodes(@NotNull String templateUrl, Template template, AngularUiRouterNode templateNode) {
            Map<String, SmartPsiElementPointer<PsiElement>> placeholders;
            if (templateUrl == null) {
                GraphNodesBuilder.$$$reportNull$$$0(12);
            }
            if ((placeholders = template.getViewPlaceholders()) != null) {
                for (Map.Entry<String, SmartPsiElementPointer<PsiElement>> pointerEntry : placeholders.entrySet()) {
                    String placeholder = pointerEntry.getKey();
                    DiagramObject placeholderObject = new DiagramObject(Type.templatePlaceholder, StringUtil.isEmptyOrSpaces((String)placeholder) ? DEFAULT : placeholder, pointerEntry.getValue());
                    templateNode.getIdentifyingElement().addChild(placeholderObject, templateNode);
                    this.templatePlaceHoldersNodes.put((Pair<String, String>)Pair.create((Object)templateUrl, (Object)placeholder), placeholderObject);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statesMap";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "templatesMap";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "view";
                    break;
                }
                case 8: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "templateUrl";
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/angularjs/codeInsight/router/AngularUiRouterGraphBuilder$GraphNodesBuilder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/angularjs/codeInsight/router/AngularUiRouterGraphBuilder$GraphNodesBuilder";
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOrCreateTemplateNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "build";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getStateTemplates";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getImmediateChildrenStates";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getParentTemplateNode";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getOrCreateTemplateNode";
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "putPlaceholderNodes";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

