/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.codeInsight.attributes;

import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharSequenceSubSequence;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlAttributeDescriptorsProvider;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.angularjs.codeInsight.DirectiveUtil;
import org.angularjs.codeInsight.attributes.AngularAttributesRegistry;
import org.angularjs.index.AngularIndexUtil;
import org.angularjs.index.AngularJSDirectivesSupport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AngularJSAttributeDescriptorsProvider
implements XmlAttributeDescriptorsProvider {
    public XmlAttributeDescriptor[] getAttributeDescriptors(XmlTag xmlTag) {
        if (xmlTag != null) {
            Project project = xmlTag.getProject();
            if (!AngularIndexUtil.hasAngularJS(project)) {
                return XmlAttributeDescriptor.EMPTY;
            }
            LinkedHashMap<String, XmlAttributeDescriptor> result = new LinkedHashMap<String, XmlAttributeDescriptor>();
            for (JSImplicitElement directive : ContainerUtil.concat((List[])new List[]{AngularJSDirectivesSupport.findAttributeDirectives(project, null)})) {
                String name = directive.getName();
                if (name == null || result.containsKey(name) || !AngularJSAttributeDescriptorsProvider.isApplicable(project, xmlTag, directive)) continue;
                this.addAttributes(project, result, directive.getName(), (PsiElement)directive);
            }
            return result.values().toArray(XmlAttributeDescriptor.EMPTY);
        }
        return XmlAttributeDescriptor.EMPTY;
    }

    protected void addAttributes(@Nullable Project project, @NotNull Map<String, XmlAttributeDescriptor> result, @NotNull String directiveName, @NotNull PsiElement declaration) {
        if (result == null) {
            AngularJSAttributeDescriptorsProvider.$$$reportNull$$$0(0);
        }
        if (directiveName == null) {
            AngularJSAttributeDescriptorsProvider.$$$reportNull$$$0(1);
        }
        if (declaration == null) {
            AngularJSAttributeDescriptorsProvider.$$$reportNull$$$0(2);
        }
        result.put(directiveName, (XmlAttributeDescriptor)AngularAttributesRegistry.createDescriptor(project, DirectiveUtil.getAttributeName(directiveName), declaration));
        if ("ngRepeat".equals(directiveName)) {
            result.put("ngRepeatStart", (XmlAttributeDescriptor)AngularAttributesRegistry.createDescriptor(project, "ng-repeat-start", declaration));
            result.put("ngRepeatEnd", (XmlAttributeDescriptor)AngularAttributesRegistry.createDescriptor(project, "ng-repeat-end", declaration));
        }
    }

    private static boolean isApplicable(@NotNull Project project, @NotNull XmlTag tag, @NotNull JSImplicitElement directive) {
        String restrictions;
        if (project == null) {
            AngularJSAttributeDescriptorsProvider.$$$reportNull$$$0(3);
        }
        if (tag == null) {
            AngularJSAttributeDescriptorsProvider.$$$reportNull$$$0(4);
        }
        if (directive == null) {
            AngularJSAttributeDescriptorsProvider.$$$reportNull$$$0(5);
        }
        if ((restrictions = directive.getTypeString()) != null) {
            CharSequenceSubSequence requiredTagAndAttr;
            int semicolon = restrictions.indexOf(59);
            if (semicolon < 0) {
                return true;
            }
            CharSequence restrict = AngularIndexUtil.convertRestrictions(project, (CharSequence)new CharSequenceSubSequence((CharSequence)restrictions, 0, semicolon));
            if (!StringUtil.isEmpty((CharSequence)restrict) && Strings.indexOfIgnoreCase((CharSequence)restrict, (CharSequence)"A", (int)0) < 0) {
                return false;
            }
            int secondSemicolon = restrictions.indexOf(59, semicolon + 1);
            if (secondSemicolon < 0) {
                secondSemicolon = restrictions.length();
            }
            if (!AngularJSAttributeDescriptorsProvider.tagAndAttrMatches(tag, (CharSequence)(requiredTagAndAttr = new CharSequenceSubSequence((CharSequence)restrictions, semicolon + 1, secondSemicolon)))) {
                return false;
            }
        }
        return true;
    }

    private static boolean tagAndAttrMatches(XmlTag tag, CharSequence requiredTagAndDirective) {
        if (requiredTagAndDirective.length() == 0) {
            return true;
        }
        int indexOfEquals = Strings.indexOf((CharSequence)requiredTagAndDirective, (char)'=');
        if (indexOfEquals < 0) {
            return AngularJSAttributeDescriptorsProvider.tagMatches(tag, requiredTagAndDirective);
        }
        if (!AngularJSAttributeDescriptorsProvider.tagMatches(tag, (CharSequence)new CharSequenceSubSequence(requiredTagAndDirective, 0, indexOfEquals))) {
            return false;
        }
        CharSequence requiredAttr = StringUtil.trim((CharSequence)new CharSequenceSubSequence(requiredTagAndDirective, indexOfEquals + 1, requiredTagAndDirective.length()));
        if (requiredAttr.length() == 0) {
            return true;
        }
        for (XmlAttribute attr : tag.getAttributes()) {
            if (!StringUtil.equals((CharSequence)requiredAttr, (CharSequence)DirectiveUtil.normalizeAttributeName(attr.getName(), true))) continue;
            return true;
        }
        return false;
    }

    private static boolean tagMatches(XmlTag tag, CharSequence requiredTag) {
        int nextIndex;
        if (StringUtil.isEmpty((CharSequence)requiredTag) || StringUtil.equalsIgnoreCase((CharSequence)requiredTag, (CharSequence)"ANY")) {
            return true;
        }
        CharSequence normalizedTag = DirectiveUtil.normalizeAttributeName(tag.getName(), true);
        int last = -1;
        do {
            CharSequence requirement;
            if (!StringUtil.equals((CharSequence)normalizedTag, (CharSequence)(requirement = StringUtil.trim((CharSequence)new CharSequenceSubSequence(requiredTag, last + 1, (nextIndex = Strings.indexOf((CharSequence)requiredTag, (char)',', (int)(last + 1))) > 0 ? nextIndex : requiredTag.length())))) && !StringUtil.equalsIgnoreCase((CharSequence)tag.getName(), (CharSequence)requirement)) continue;
            return true;
        } while ((last = nextIndex) > 0);
        if (StringUtil.equalsIgnoreCase((CharSequence)"input", (CharSequence)requiredTag)) {
            XmlTag parent = tag;
            while (parent != null && !(parent instanceof PsiFile)) {
                if (!((parent = parent.getParent()) instanceof XmlTag) || !AngularJSAttributeDescriptorsProvider.isForm(parent)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isForm(XmlTag parent) {
        String name = parent.getName();
        return "form".equalsIgnoreCase(name) || DirectiveUtil.normalizeAttributeName(name).equals("ngForm");
    }

    @Nullable
    public XmlAttributeDescriptor getAttributeDescriptor(String attrName, XmlTag xmlTag) {
        return AngularJSAttributeDescriptorsProvider.getDescriptor(attrName, xmlTag);
    }

    static XmlAttributeDescriptor getDescriptor(String attrName, XmlTag xmlTag) {
        if (xmlTag != null) {
            Project project = xmlTag.getProject();
            if (!AngularIndexUtil.hasAngularJS(xmlTag.getProject())) {
                return null;
            }
            String directiveName = DirectiveUtil.normalizeAttributeName(attrName);
            for (JSImplicitElement directive : AngularJSDirectivesSupport.findAttributeDirectives(project, directiveName)) {
                String name = directive.getName();
                if (name == null || !directiveName.equals(name) || !AngularJSAttributeDescriptorsProvider.isApplicable(project, xmlTag, directive)) continue;
                return AngularAttributesRegistry.createDescriptor(project, attrName, (PsiElement)directive);
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directiveName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directive";
                break;
            }
        }
        objectArray2[1] = "org/angularjs/codeInsight/attributes/AngularJSAttributeDescriptorsProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addAttributes";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

