/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.lang.html.highlighting;

import com.intellij.ide.highlighter.HtmlFileHighlighter;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.highlighting.JSHighlighter;
import com.intellij.lang.javascript.highlighting.TypeScriptHighlighter;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.XmlHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.angular2.lang.expr.Angular2Language;
import org.angular2.lang.expr.lexer.Angular2TokenTypes;
import org.angular2.lang.html.highlighting.Angular2HtmlHighlighterColors;
import org.angular2.lang.html.highlighting.Angular2HtmlHighlightingLexer;
import org.angular2.lang.html.lexer.Angular2HtmlTokenType;
import org.angular2.lang.html.parser.Angular2HtmlElementTypes;
import org.jetbrains.annotations.NotNull;

class Angular2HtmlFileHighlighter
extends HtmlFileHighlighter {
    private static final Map<IElementType, TextAttributesKey[]> keys = new HashMap<IElementType, TextAttributesKey[]>();
    private static final JSHighlighter ourJsHighlighter = new JSHighlighter(DialectOptionHolder.JS_1_5);
    private static final TypeScriptHighlighter ourTsHighlighter = new TypeScriptHighlighter(false);
    private static final Map<Pair<TextAttributesKey, IElementType>, TextAttributesKey> ourTsKeyMap = new ConcurrentHashMap<Pair<TextAttributesKey, IElementType>, TextAttributesKey>();
    private final boolean myTokenizeExpansionForms;
    private final Pair<String, String> myInterpolationConfig;

    private static void put(IElementType token, TextAttributesKey ... keysArr) {
        keys.put(token, keysArr);
    }

    Angular2HtmlFileHighlighter(boolean tokenizeExpansionForms, Pair<String, String> interpolationConfig) {
        this.myTokenizeExpansionForms = tokenizeExpansionForms;
        this.myInterpolationConfig = interpolationConfig;
    }

    public TextAttributesKey @NotNull [] getTokenHighlights(IElementType tokenType) {
        Object[] result = keys.get(tokenType);
        if (result != null) {
            if (result == null) {
                Angular2HtmlFileHighlighter.$$$reportNull$$$0(0);
            }
            return result;
        }
        result = super.getTokenHighlights(tokenType);
        if (tokenType.getLanguage() instanceof Angular2Language || tokenType.getLanguage() instanceof JavascriptLanguage) {
            result = (TextAttributesKey[])ArrayUtil.insert((Object[])result, (int)1, (Object)Angular2HtmlHighlighterColors.NG_EXPRESSION);
        }
        return Angular2HtmlFileHighlighter.mapToTsKeys((TextAttributesKey[])result, tokenType);
    }

    @NotNull
    public Lexer getHighlightingLexer() {
        return new Angular2HtmlHighlightingLexer(this.myTokenizeExpansionForms, this.myInterpolationConfig, FileTypeRegistry.getInstance().findFileTypeByName("CSS"));
    }

    private static TextAttributesKey @NotNull [] mapToTsKeys(TextAttributesKey @NotNull [] tokenHighlights, @NotNull IElementType tokenType) {
        if (tokenType == null) {
            Angular2HtmlFileHighlighter.$$$reportNull$$$0(1);
        }
        if (tokenHighlights == null) {
            Angular2HtmlFileHighlighter.$$$reportNull$$$0(2);
        }
        TextAttributesKey[] textAttributesKeyArray = (TextAttributesKey[])ContainerUtil.map2Array((Object[])tokenHighlights, TextAttributesKey.class, key -> Angular2HtmlFileHighlighter.getTsMappedKey(key, tokenType));
        if (textAttributesKeyArray == null) {
            Angular2HtmlFileHighlighter.$$$reportNull$$$0(3);
        }
        return textAttributesKeyArray;
    }

    @NotNull
    private static TextAttributesKey getTsMappedKey(@NotNull TextAttributesKey key, @NotNull IElementType tokenType) {
        if (key == null) {
            Angular2HtmlFileHighlighter.$$$reportNull$$$0(4);
        }
        if (tokenType == null) {
            Angular2HtmlFileHighlighter.$$$reportNull$$$0(5);
        }
        TextAttributesKey textAttributesKey = !key.getExternalName().startsWith("JS.") ? key : ourTsKeyMap.computeIfAbsent((Pair<TextAttributesKey, IElementType>)Pair.pair((Object)key, (Object)tokenType), p -> {
            Object[] jsHighlights = ourJsHighlighter.getTokenHighlights((IElementType)p.second);
            Object[] tsHighlights = ourTsHighlighter.getTokenHighlights((IElementType)p.second);
            TextAttributesKey jsKey = (TextAttributesKey)ArrayUtil.getLastElement((Object[])jsHighlights);
            TextAttributesKey tsKey = (TextAttributesKey)ArrayUtil.getLastElement((Object[])tsHighlights);
            return jsKey == p.first && tsKey != null ? tsKey : (TextAttributesKey)p.first;
        });
        if (textAttributesKey == null) {
            Angular2HtmlFileHighlighter.$$$reportNull$$$0(6);
        }
        return textAttributesKey;
    }

    static {
        ContainerUtil.newArrayList((Object[])new Angular2HtmlTokenType[]{Angular2HtmlElementTypes.INTERPOLATION_START, Angular2HtmlElementTypes.INTERPOLATION_END}).forEach(token -> Angular2HtmlFileHighlighter.put(token, XmlHighlighterColors.HTML_CODE, Angular2HtmlHighlighterColors.NG_EXPRESSION, Angular2HtmlHighlighterColors.NG_INTERPOLATION_DELIMITER));
        ContainerUtil.newArrayList((Object[])new Angular2HtmlTokenType[]{Angular2HtmlElementTypes.EXPANSION_FORM_START, Angular2HtmlElementTypes.EXPANSION_FORM_CASE_START, Angular2HtmlElementTypes.EXPANSION_FORM_END, Angular2HtmlElementTypes.EXPANSION_FORM_CASE_END}).forEach(token -> Angular2HtmlFileHighlighter.put(token, XmlHighlighterColors.HTML_CODE, Angular2HtmlHighlighterColors.NG_EXPANSION_FORM, Angular2HtmlHighlighterColors.NG_EXPANSION_FORM_DELIMITER));
        Angular2HtmlFileHighlighter.put(Angular2HtmlHighlightingLexer.EXPANSION_FORM_CONTENT, XmlHighlighterColors.HTML_CODE, Angular2HtmlHighlighterColors.NG_EXPANSION_FORM);
        Angular2HtmlFileHighlighter.put(Angular2HtmlHighlightingLexer.EXPANSION_FORM_COMMA, XmlHighlighterColors.HTML_CODE, Angular2HtmlHighlighterColors.NG_EXPANSION_FORM, Angular2HtmlHighlighterColors.NG_EXPANSION_FORM_COMMA);
        ContainerUtil.newArrayList((Object[])new Pair[]{Pair.pair((Object)Angular2HtmlElementTypes.BANANA_BOX_BINDING, (Object)Angular2HtmlHighlighterColors.NG_BANANA_BINDING_ATTR_NAME), Pair.pair((Object)Angular2HtmlElementTypes.EVENT, (Object)Angular2HtmlHighlighterColors.NG_EVENT_BINDING_ATTR_NAME), Pair.pair((Object)Angular2HtmlElementTypes.PROPERTY_BINDING, (Object)Angular2HtmlHighlighterColors.NG_PROPERTY_BINDING_ATTR_NAME), Pair.pair((Object)Angular2HtmlElementTypes.REFERENCE, (Object)Angular2HtmlHighlighterColors.NG_REFERENCE_ATTR_NAME), Pair.pair((Object)Angular2HtmlElementTypes.TEMPLATE_BINDINGS, (Object)Angular2HtmlHighlighterColors.NG_TEMPLATE_BINDINGS_ATTR_NAME), Pair.pair((Object)Angular2HtmlElementTypes.LET, (Object)Angular2HtmlHighlighterColors.NG_TEMPLATE_LET_ATTR_NAME)}).forEach(p -> Angular2HtmlFileHighlighter.put((IElementType)p.first, XmlHighlighterColors.HTML_CODE, XmlHighlighterColors.HTML_TAG, XmlHighlighterColors.HTML_ATTRIBUTE_NAME, (TextAttributesKey)p.second));
        ContainerUtil.newArrayList((Object[])Angular2TokenTypes.KEYWORDS.getTypes()).forEach(token -> Angular2HtmlFileHighlighter.put(token, XmlHighlighterColors.HTML_CODE, Angular2HtmlHighlighterColors.NG_EXPRESSION, TypeScriptHighlighter.TS_KEYWORD));
        ContainerUtil.newArrayList((Object[])new Pair[]{Pair.pair((Object)Angular2TokenTypes.ESCAPE_SEQUENCE, (Object)TypeScriptHighlighter.TS_VALID_STRING_ESCAPE), Pair.pair((Object)Angular2TokenTypes.INVALID_ESCAPE_SEQUENCE, (Object)TypeScriptHighlighter.TS_INVALID_STRING_ESCAPE), Pair.pair((Object)Angular2TokenTypes.XML_CHAR_ENTITY_REF, (Object)XmlHighlighterColors.HTML_ENTITY_REFERENCE), Pair.pair((Object)JSTokenTypes.STRING_LITERAL_PART, (Object)TypeScriptHighlighter.TS_STRING)}).forEach(p -> Angular2HtmlFileHighlighter.put((IElementType)p.first, XmlHighlighterColors.HTML_CODE, Angular2HtmlHighlighterColors.NG_EXPRESSION, (TextAttributesKey)p.second));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/angular2/lang/html/highlighting/Angular2HtmlFileHighlighter";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenHighlights";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenHighlights";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "org/angular2/lang/html/highlighting/Angular2HtmlFileHighlighter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "mapToTsKeys";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTsMappedKey";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "mapToTsKeys";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTsMappedKey";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

