/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.inspections.quickfixes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.util.ObjectUtils;
import org.angular2.lang.Angular2Bundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ConvertToPropertyBindingQuickFix
implements LocalQuickFix {
    private final String myPropertyName;

    public ConvertToPropertyBindingQuickFix(@NotNull String propertyName) {
        if (propertyName == null) {
            ConvertToPropertyBindingQuickFix.$$$reportNull$$$0(0);
        }
        this.myPropertyName = propertyName;
    }

    @Nls
    @NotNull
    public String getName() {
        String string = Angular2Bundle.message("angular.quickfix.template.bind-to-property.name", this.myPropertyName);
        if (string == null) {
            ConvertToPropertyBindingQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = Angular2Bundle.message("angular.quickfix.template.bind-to-property.family", new Object[0]);
        if (string == null) {
            ConvertToPropertyBindingQuickFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        XmlAttribute attribute;
        if (project == null) {
            ConvertToPropertyBindingQuickFix.$$$reportNull$$$0(3);
        }
        if (descriptor == null) {
            ConvertToPropertyBindingQuickFix.$$$reportNull$$$0(4);
        }
        if ((attribute = (XmlAttribute)ObjectUtils.tryCast((Object)descriptor.getPsiElement().getParent(), XmlAttribute.class)) != null) {
            attribute.setName("[" + this.myPropertyName + "]");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/angular2/inspections/quickfixes/ConvertToPropertyBindingQuickFix";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/angular2/inspections/quickfixes/ConvertToPropertyBindingQuickFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

