/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.entities.metadata.stubs;

import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.javascript.index.flags.BooleanStructureElement;
import com.intellij.lang.javascript.index.flags.FlagsStructure;
import com.intellij.lang.javascript.index.flags.FlagsStructureElement;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.angular2.entities.Angular2DirectiveKind;
import org.angular2.entities.metadata.psi.Angular2MetadataClassBase;
import org.angular2.entities.metadata.stubs.Angular2MetadataClassStub;
import org.angular2.entities.metadata.stubs.Angular2MetadataComponentStub;
import org.angular2.entities.metadata.stubs.Angular2MetadataDirectiveStub;
import org.angular2.entities.metadata.stubs.Angular2MetadataElementStub;
import org.angular2.entities.metadata.stubs.Angular2MetadataModuleStub;
import org.angular2.entities.metadata.stubs.Angular2MetadataPipeStub;
import org.angular2.entities.metadata.stubs.Angular2MetadataReferenceStub;
import org.angular2.index.Angular2MetadataClassNameIndex;
import org.angular2.lang.metadata.MetadataUtils;
import org.angular2.lang.metadata.psi.MetadataElementType;
import org.angular2.lang.metadata.stubs.MetadataElementStub;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Angular2MetadataClassStubBase<Psi extends Angular2MetadataClassBase<?>>
extends Angular2MetadataElementStub<Psi> {
    @NonNls
    private static final String EXTENDS_MEMBER = "#ext";
    private static final NotNullLazyValue<Map<String, EntityFactory>> ENTITY_FACTORIES = NotNullLazyValue.lazy(() -> ContainerUtil.immutableMapBuilder().put((Object)"NgModule", Angular2MetadataModuleStub::new).put((Object)"Pipe", Angular2MetadataPipeStub::createPipeStub).put((Object)"Component", Angular2MetadataComponentStub::new).put((Object)"Directive", Angular2MetadataDirectiveStub::new).build());
    private static final BooleanStructureElement IS_STRUCTURAL_DIRECTIVE_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement IS_REGULAR_DIRECTIVE_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement HAS_INPUT_MAPPINGS = new BooleanStructureElement();
    private static final BooleanStructureElement HAS_OUTPUT_MAPPINGS = new BooleanStructureElement();
    protected static final FlagsStructure FLAGS_STRUCTURE = new FlagsStructure(Angular2MetadataElementStub.FLAGS_STRUCTURE, new FlagsStructureElement[]{IS_STRUCTURAL_DIRECTIVE_FLAG, IS_REGULAR_DIRECTIVE_FLAG, HAS_INPUT_MAPPINGS, HAS_OUTPUT_MAPPINGS});
    protected final Map<String, String> myInputMappings;
    protected final Map<String, String> myOutputMappings;

    private static Map<String, EntityFactory> getEntityFactories() {
        return (Map)ENTITY_FACTORIES.getValue();
    }

    public static Angular2MetadataClassStubBase<?> createClassStub(@Nullable String memberName, @NotNull JsonValue source, @Nullable StubElement parent) {
        if (source == null) {
            Angular2MetadataClassStubBase.$$$reportNull$$$0(0);
        }
        return Angular2MetadataClassStubBase.streamDecorators((JsonObject)source).map(pair -> (Angular2MetadataClassStubBase)((Object)((Object)ObjectUtils.doIfNotNull((Object)Angular2MetadataClassStubBase.getEntityFactories().get(pair.first), factory -> factory.create(memberName, parent, (JsonObject)source, (JsonObject)pair.second))))).filter(Objects::nonNull).findFirst().orElseGet(() -> new Angular2MetadataClassStub(memberName, source, parent));
    }

    public Angular2MetadataClassStubBase(@Nullable String memberName, @Nullable StubElement parent, @NotNull JsonObject source, @NotNull MetadataElementType elementType) {
        JsonObject extendsClass;
        if (source == null) {
            Angular2MetadataClassStubBase.$$$reportNull$$$0(1);
        }
        if (elementType == null) {
            Angular2MetadataClassStubBase.$$$reportNull$$$0(2);
        }
        super(memberName, parent, elementType);
        if (this.loadInOuts()) {
            this.readTemplateFlag(source);
        }
        if ((extendsClass = MetadataUtils.getPropertyValue(source.findProperty("extends"), JsonObject.class)) != null) {
            Angular2MetadataReferenceStub.createReferenceStub(EXTENDS_MEMBER, (JsonValue)extendsClass, (StubElement)this);
        }
        this.myOutputMappings = new HashMap<String, String>();
        this.myInputMappings = new HashMap<String, String>();
        MetadataUtils.streamObjectProperty(source.findProperty("members")).forEach(this::loadMember);
        MetadataUtils.streamObjectProperty(source.findProperty("statics")).filter(prop -> prop.getValue() instanceof JsonObject && "function".equals(MetadataUtils.readStringPropertyValue(((JsonObject)prop.getValue()).findProperty("__symbolic")))).forEach(this::loadMemberProperty);
    }

    public Angular2MetadataClassStubBase(@NotNull StubInputStream stream, @Nullable StubElement parent, @NotNull MetadataElementType elementType) throws IOException {
        if (stream == null) {
            Angular2MetadataClassStubBase.$$$reportNull$$$0(3);
        }
        if (elementType == null) {
            Angular2MetadataClassStubBase.$$$reportNull$$$0(4);
        }
        super(stream, parent, elementType);
        this.myInputMappings = (Boolean)this.readFlag(HAS_INPUT_MAPPINGS) != false ? MetadataElementStub.readStringMap(stream) : Collections.emptyMap();
        this.myOutputMappings = (Boolean)this.readFlag(HAS_OUTPUT_MAPPINGS) != false ? MetadataElementStub.readStringMap(stream) : Collections.emptyMap();
    }

    @Nullable
    public String getClassName() {
        return this.getMemberName();
    }

    public Angular2MetadataReferenceStub getExtendsReference() {
        return (Angular2MetadataReferenceStub)((Object)ContainerUtil.find((Iterable)this.getChildrenStubs(), child -> child instanceof Angular2MetadataReferenceStub && EXTENDS_MEMBER.equals(((Angular2MetadataReferenceStub)((Object)child)).getMemberName())));
    }

    public Map<String, String> getInputMappings() {
        return Collections.unmodifiableMap(this.myInputMappings);
    }

    public Map<String, String> getOutputMappings() {
        return Collections.unmodifiableMap(this.myOutputMappings);
    }

    @Nullable
    public Angular2DirectiveKind getDirectiveKind() {
        boolean isStructural = (Boolean)this.readFlag(IS_STRUCTURAL_DIRECTIVE_FLAG);
        boolean isRegular = (Boolean)this.readFlag(IS_REGULAR_DIRECTIVE_FLAG);
        if (isStructural || isRegular) {
            return Angular2DirectiveKind.get(isRegular, isStructural);
        }
        return null;
    }

    @Override
    public void serialize(@NotNull StubOutputStream stream) throws IOException {
        if (stream == null) {
            Angular2MetadataClassStubBase.$$$reportNull$$$0(5);
        }
        this.writeFlag(HAS_INPUT_MAPPINGS, !this.myInputMappings.isEmpty());
        this.writeFlag(HAS_OUTPUT_MAPPINGS, !this.myOutputMappings.isEmpty());
        super.serialize(stream);
        if (!this.myInputMappings.isEmpty()) {
            Angular2MetadataClassStubBase.writeStringMap(this.myInputMappings, stream);
        }
        if (!this.myOutputMappings.isEmpty()) {
            Angular2MetadataClassStubBase.writeStringMap(this.myOutputMappings, stream);
        }
    }

    @Override
    public void index(@NotNull IndexSink sink) {
        if (sink == null) {
            Angular2MetadataClassStubBase.$$$reportNull$$$0(6);
        }
        super.index(sink);
        if (this.getClassName() != null) {
            sink.occurrence(Angular2MetadataClassNameIndex.KEY, (Object)this.getClassName());
        }
    }

    protected boolean loadInOuts() {
        return true;
    }

    @Override
    protected FlagsStructure getFlagsStructure() {
        return FLAGS_STRUCTURE;
    }

    private void readTemplateFlag(JsonObject source) {
        JsonObject members = (JsonObject)ObjectUtils.tryCast((Object)ObjectUtils.doIfNotNull((Object)source.findProperty("members"), JsonProperty::getValue), JsonObject.class);
        JsonProperty constructor = members != null ? members.findProperty("__ctor__") : null;
        String constructorText = constructor != null ? constructor.getText() : "";
        Angular2DirectiveKind kind = Angular2DirectiveKind.get(constructorText.contains("ElementRef"), constructorText.contains("TemplateRef"), constructorText.contains("ViewContainerRef"));
        this.writeFlag(IS_STRUCTURAL_DIRECTIVE_FLAG, kind != null && kind.isStructural());
        this.writeFlag(IS_REGULAR_DIRECTIVE_FLAG, kind != null && kind.isRegular());
    }

    private void loadMember(@NotNull JsonProperty property) {
        if (property == null) {
            Angular2MetadataClassStubBase.$$$reportNull$$$0(7);
        }
        String name = property.getName();
        JsonArray val = (JsonArray)ObjectUtils.tryCast((Object)property.getValue(), JsonArray.class);
        if (val == null || val.getValueList().size() != 1) {
            return;
        }
        JsonObject obj = (JsonObject)ObjectUtils.tryCast(val.getValueList().get(0), JsonObject.class);
        if (obj == null) {
            return;
        }
        String memberSymbol = MetadataUtils.readStringPropertyValue(obj.findProperty("__symbolic"));
        if (this.loadInOuts() && ("property".equals(memberSymbol) || "method".equals(memberSymbol))) {
            Angular2MetadataClassStubBase.streamDecorators(obj).forEach(dec -> {
                if ("Input".equals(dec.first)) {
                    Angular2MetadataClassStubBase.addBindingMapping(name, this.myInputMappings, Angular2MetadataClassStubBase.getDecoratorInitializer((JsonObject)dec.second, JsonStringLiteral.class));
                } else if ("Output".equals(dec.first)) {
                    Angular2MetadataClassStubBase.addBindingMapping(name, this.myOutputMappings, Angular2MetadataClassStubBase.getDecoratorInitializer((JsonObject)dec.second, JsonStringLiteral.class));
                }
            });
        } else if ("function".equals(memberSymbol)) {
            this.loadMemberProperty(property);
        }
    }

    private static void addBindingMapping(@NotNull String fieldName, @NotNull Map<String, String> mappings, @Nullable JsonStringLiteral initializer) {
        if (fieldName == null) {
            Angular2MetadataClassStubBase.$$$reportNull$$$0(8);
        }
        if (mappings == null) {
            Angular2MetadataClassStubBase.$$$reportNull$$$0(9);
        }
        String bindingName = initializer != null ? initializer.getValue() : fieldName;
        mappings.put(fieldName, bindingName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappings";
                break;
            }
        }
        objectArray2[1] = "org/angular2/entities/metadata/stubs/Angular2MetadataClassStubBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createClassStub";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "serialize";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "index";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "loadMember";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "addBindingMapping";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static interface EntityFactory {
        @Nullable
        public Angular2MetadataClassStubBase create(@Nullable String var1, @Nullable StubElement var2, @NotNull JsonObject var3, @NotNull JsonObject var4);
    }
}

