/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.css;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.css.resolve.CssInclusionContext;
import com.intellij.psi.css.resolve.CssResolveManager;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.AstLoadingFilter;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import org.angular2.cli.AngularCliUtil;
import org.angular2.cli.config.AngularConfigProvider;
import org.angular2.cli.config.AngularProject;
import org.angular2.entities.Angular2Component;
import org.angular2.entities.Angular2ComponentLocator;
import org.angular2.entities.Angular2EntitiesProvider;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Angular2CssInclusionContext
extends CssInclusionContext {
    @NonNls
    private static final Key<CachedValue<ComponentCssContext>> COMPONENT_CONTEXT_KEY = new Key("ng.component.context");

    public PsiFile @NotNull [] getContextFiles(@NotNull PsiFile current) {
        ComponentCssContext componentContext;
        if (current == null) {
            Angular2CssInclusionContext.$$$reportNull$$$0(0);
        }
        if ((componentContext = Angular2CssInclusionContext.getComponentContext((PsiElement)current)) != null) {
            PsiFile[] psiFileArray = componentContext.getCssFiles();
            if (psiFileArray == null) {
                Angular2CssInclusionContext.$$$reportNull$$$0(1);
            }
            return psiFileArray;
        }
        if (PsiFile.EMPTY_ARRAY == null) {
            Angular2CssInclusionContext.$$$reportNull$$$0(2);
        }
        return PsiFile.EMPTY_ARRAY;
    }

    public boolean processAllCssFilesOnResolving(@NotNull PsiElement context) {
        ComponentCssContext componentContext;
        if (context == null) {
            Angular2CssInclusionContext.$$$reportNull$$$0(3);
        }
        return (componentContext = Angular2CssInclusionContext.getComponentContext(context)) != null && !componentContext.isAngularCli();
    }

    public PsiFile @NotNull [] getLocalUseScope(@NotNull PsiFile file) {
        Angular2Component component;
        if (file == null) {
            Angular2CssInclusionContext.$$$reportNull$$$0(4);
        }
        if (file instanceof StylesheetFile && (component = Angular2EntitiesProvider.getComponent((PsiElement)Angular2ComponentLocator.findComponentClass((PsiElement)file))) != null) {
            ArrayList<PsiFile> files = new ArrayList<PsiFile>(component.getCssFiles());
            ObjectUtils.doIfNotNull((Object)component.getTemplateFile(), files::add);
            PsiFile[] psiFileArray = files.toArray(PsiFile.EMPTY_ARRAY);
            if (psiFileArray == null) {
                Angular2CssInclusionContext.$$$reportNull$$$0(5);
            }
            return psiFileArray;
        }
        if (PsiFile.EMPTY_ARRAY == null) {
            Angular2CssInclusionContext.$$$reportNull$$$0(6);
        }
        return PsiFile.EMPTY_ARRAY;
    }

    @Nullable
    private static ComponentCssContext getComponentContext(@NotNull PsiElement context) {
        if (context == null) {
            Angular2CssInclusionContext.$$$reportNull$$$0(7);
        }
        PsiFile file = context.getContainingFile();
        return (ComponentCssContext)CachedValuesManager.getCachedValue((PsiElement)file, COMPONENT_CONTEXT_KEY, () -> {
            Angular2Component component = Angular2EntitiesProvider.getComponent((PsiElement)Angular2ComponentLocator.findComponentClass((PsiElement)file));
            if (component != null) {
                ComponentCssContext componentCssContext = new ComponentCssContext(component, file);
                return CachedValueProvider.Result.create((Object)componentCssContext, (Object[])componentCssContext.getDependencies());
            }
            return CachedValueProvider.Result.create(null, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS});
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "current";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/angular2/css/Angular2CssInclusionContext";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/angular2/css/Angular2CssInclusionContext";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextFiles";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalUseScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getContextFiles";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processAllCssFilesOnResolving";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getLocalUseScope";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getComponentContext";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class ComponentCssContext {
        private final Angular2Component myComponent;
        private final VirtualFile myAngularCliJson;

        private ComponentCssContext(Angular2Component component, PsiFile file) {
            this.myComponent = component;
            PsiFile original = InjectedLanguageManager.getInstance((Project)file.getProject()).getTopLevelFile(CompletionUtil.getOriginalOrSelf((PsiElement)file));
            VirtualFile angularCliFolder = AngularCliUtil.findAngularCliFolder(file.getProject(), original.getOriginalFile().getViewProvider().getVirtualFile());
            this.myAngularCliJson = AngularCliUtil.findCliJson(angularCliFolder);
        }

        public Object[] getDependencies() {
            return ContainerUtil.packNullables((Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS, this.myAngularCliJson}).toArray();
        }

        public PsiFile[] getCssFiles() {
            AngularProject ngProject;
            Project project = this.myComponent.getSourceElement().getProject();
            ArrayList<PsiFile> cssFilesList = new ArrayList<PsiFile>(this.myComponent.getCssFiles());
            if (this.myAngularCliJson != null && (ngProject = AngularConfigProvider.getAngularProject(project, this.myAngularCliJson)) != null) {
                PsiManager psiManager = PsiManager.getInstance((Project)project);
                PsiFile html = (PsiFile)ObjectUtils.doIfNotNull((Object)ngProject.getIndexHtmlFile(), arg_0 -> ((PsiManager)psiManager).findFile(arg_0));
                if (html instanceof XmlFile) {
                    AstLoadingFilter.forceAllowTreeLoading((PsiFile)html, () -> cssFilesList.addAll(Arrays.asList(CssResolveManager.getInstance().getNewResolver().resolveStyleSheets((XmlFile)html, null))));
                }
                cssFilesList.addAll(ContainerUtil.mapNotNull(ngProject.getGlobalStyleSheets(), file -> (StylesheetFile)ObjectUtils.tryCast((Object)psiManager.findFile(file), StylesheetFile.class)));
            }
            return cssFilesList.toArray(PsiFile.EMPTY_ARRAY);
        }

        public boolean isAngularCli() {
            return this.myAngularCliJson != null;
        }
    }
}

