/*
 * Decompiled with CFR 0.152.
 */
package libcore.util;

public class FP16 {
    public static final int SIZE = 16;
    public static final short EPSILON = 5120;
    public static final int MAX_EXPONENT = 15;
    public static final int MIN_EXPONENT = -14;
    public static final short LOWEST_VALUE = -1025;
    public static final short MAX_VALUE = 31743;
    public static final short MIN_NORMAL = 1024;
    public static final short MIN_VALUE = 1;
    public static final short NaN = 32256;
    public static final short NEGATIVE_INFINITY = -1024;
    public static final short NEGATIVE_ZERO = Short.MIN_VALUE;
    public static final short POSITIVE_INFINITY = 31744;
    public static final short POSITIVE_ZERO = 0;
    public static final int SIGN_SHIFT = 15;
    public static final int EXPONENT_SHIFT = 10;
    public static final int SIGN_MASK = 32768;
    public static final int SHIFTED_EXPONENT_MASK = 31;
    public static final int SIGNIFICAND_MASK = 1023;
    public static final int EXPONENT_SIGNIFICAND_MASK = Short.MAX_VALUE;
    public static final int EXPONENT_BIAS = 15;
    private static final int FP32_SIGN_SHIFT = 31;
    private static final int FP32_EXPONENT_SHIFT = 23;
    private static final int FP32_SHIFTED_EXPONENT_MASK = 255;
    private static final int FP32_SIGNIFICAND_MASK = 0x7FFFFF;
    private static final int FP32_EXPONENT_BIAS = 127;
    private static final int FP32_QNAN_MASK = 0x400000;
    private static final int FP32_DENORMAL_MAGIC = 0x3F000000;
    private static final float FP32_DENORMAL_FLOAT = Float.intBitsToFloat(0x3F000000);

    private FP16() {
    }

    public static int compare(short x, short y) {
        int yBits;
        if (FP16.less(x, y)) {
            return -1;
        }
        if (FP16.greater(x, y)) {
            return 1;
        }
        int xBits = FP16.isNaN(x) ? 32256 : (int)x;
        int n = yBits = FP16.isNaN(y) ? 32256 : (int)y;
        return xBits == yBits ? 0 : (xBits < yBits ? -1 : 1);
    }

    public static short rint(short h) {
        int bits = h & 0xFFFF;
        int abs = bits & Short.MAX_VALUE;
        int result = bits;
        if (abs < 15360) {
            result &= 0x8000;
            if (abs > 14336) {
                result |= 0x3C00;
            }
        } else if (abs < 25600) {
            int exp = 25 - (abs >> 10);
            int mask = (1 << exp) - 1;
            result += (1 << exp - 1) - (~(abs >> exp) & 1);
            result &= ~mask;
        }
        if (FP16.isNaN((short)result)) {
            result |= 0x7E00;
        }
        return (short)result;
    }

    public static short ceil(short h) {
        int bits = h & 0xFFFF;
        int abs = bits & Short.MAX_VALUE;
        int result = bits;
        if (abs < 15360) {
            result &= 0x8000;
            result |= 0x3C00 & -(~(bits >> 15) & (abs != 0 ? 1 : 0));
        } else if (abs < 25600) {
            abs = 25 - (abs >> 10);
            int mask = (1 << abs) - 1;
            result += mask & (bits >> 15) - 1;
            result &= ~mask;
        }
        if (FP16.isNaN((short)result)) {
            result |= 0x7E00;
        }
        return (short)result;
    }

    public static short floor(short h) {
        int bits = h & 0xFFFF;
        int abs = bits & Short.MAX_VALUE;
        int result = bits;
        if (abs < 15360) {
            result &= 0x8000;
            result |= 0x3C00 & (bits > 32768 ? 65535 : 0);
        } else if (abs < 25600) {
            abs = 25 - (abs >> 10);
            int mask = (1 << abs) - 1;
            result += mask & -(bits >> 15);
            result &= ~mask;
        }
        if (FP16.isNaN((short)result)) {
            result |= 0x7E00;
        }
        return (short)result;
    }

    public static short trunc(short h) {
        int bits = h & 0xFFFF;
        int abs = bits & Short.MAX_VALUE;
        int result = bits;
        if (abs < 15360) {
            result &= 0x8000;
        } else if (abs < 25600) {
            abs = 25 - (abs >> 10);
            int mask = (1 << abs) - 1;
            result &= ~mask;
        }
        return (short)result;
    }

    public static short min(short x, short y) {
        if (FP16.isNaN(x)) {
            return 32256;
        }
        if (FP16.isNaN(y)) {
            return 32256;
        }
        if ((x & Short.MAX_VALUE) == 0 && (y & Short.MAX_VALUE) == 0) {
            return (x & 0x8000) != 0 ? x : y;
        }
        return ((x & 0x8000) != 0 ? 32768 - (x & 0xFFFF) : x & 0xFFFF) < ((y & 0x8000) != 0 ? 32768 - (y & 0xFFFF) : y & 0xFFFF) ? x : y;
    }

    public static short max(short x, short y) {
        if (FP16.isNaN(x)) {
            return 32256;
        }
        if (FP16.isNaN(y)) {
            return 32256;
        }
        if ((x & Short.MAX_VALUE) == 0 && (y & Short.MAX_VALUE) == 0) {
            return (x & 0x8000) != 0 ? y : x;
        }
        return ((x & 0x8000) != 0 ? 32768 - (x & 0xFFFF) : x & 0xFFFF) > ((y & 0x8000) != 0 ? 32768 - (y & 0xFFFF) : y & 0xFFFF) ? x : y;
    }

    public static boolean less(short x, short y) {
        if (FP16.isNaN(x)) {
            return false;
        }
        if (FP16.isNaN(y)) {
            return false;
        }
        return ((x & 0x8000) != 0 ? 32768 - (x & 0xFFFF) : x & 0xFFFF) < ((y & 0x8000) != 0 ? 32768 - (y & 0xFFFF) : y & 0xFFFF);
    }

    public static boolean lessEquals(short x, short y) {
        if (FP16.isNaN(x)) {
            return false;
        }
        if (FP16.isNaN(y)) {
            return false;
        }
        return ((x & 0x8000) != 0 ? 32768 - (x & 0xFFFF) : x & 0xFFFF) <= ((y & 0x8000) != 0 ? 32768 - (y & 0xFFFF) : y & 0xFFFF);
    }

    public static boolean greater(short x, short y) {
        if (FP16.isNaN(x)) {
            return false;
        }
        if (FP16.isNaN(y)) {
            return false;
        }
        return ((x & 0x8000) != 0 ? 32768 - (x & 0xFFFF) : x & 0xFFFF) > ((y & 0x8000) != 0 ? 32768 - (y & 0xFFFF) : y & 0xFFFF);
    }

    public static boolean greaterEquals(short x, short y) {
        if (FP16.isNaN(x)) {
            return false;
        }
        if (FP16.isNaN(y)) {
            return false;
        }
        return ((x & 0x8000) != 0 ? 32768 - (x & 0xFFFF) : x & 0xFFFF) >= ((y & 0x8000) != 0 ? 32768 - (y & 0xFFFF) : y & 0xFFFF);
    }

    public static boolean equals(short x, short y) {
        if (FP16.isNaN(x)) {
            return false;
        }
        if (FP16.isNaN(y)) {
            return false;
        }
        return x == y || ((x | y) & Short.MAX_VALUE) == 0;
    }

    public static boolean isInfinite(short h) {
        return (h & Short.MAX_VALUE) == 31744;
    }

    public static boolean isNaN(short h) {
        return (h & Short.MAX_VALUE) > 31744;
    }

    public static boolean isNormalized(short h) {
        return (h & 0x7C00) != 0 && (h & 0x7C00) != 31744;
    }

    public static float toFloat(short h) {
        int bits = h & 0xFFFF;
        int s = bits & 0x8000;
        int e = bits >>> 10 & 0x1F;
        int m = bits & 0x3FF;
        int outE = 0;
        int outM = 0;
        if (e == 0) {
            if (m != 0) {
                float o = Float.intBitsToFloat(0x3F000000 + m);
                return s == 0 ? o : -(o -= FP32_DENORMAL_FLOAT);
            }
        } else {
            outM = m << 13;
            if (e == 31) {
                outE = 255;
                if (outM != 0) {
                    outM |= 0x400000;
                }
            } else {
                outE = e - 15 + 127;
            }
        }
        int out = s << 16 | outE << 23 | outM;
        return Float.intBitsToFloat(out);
    }

    public static short toHalf(float f) {
        int bits = Float.floatToRawIntBits(f);
        int s = bits >>> 31;
        int e = bits >>> 23 & 0xFF;
        int m = bits & 0x7FFFFF;
        int outE = 0;
        int outM = 0;
        if (e == 255) {
            outE = 31;
            outM = m != 0 ? 512 : 0;
        } else if ((e = e - 127 + 15) >= 31) {
            outE = 31;
        } else if (e <= 0) {
            int hway;
            int shift;
            int lowm;
            if (e >= -10 && (lowm = (m |= 0x800000) & (1 << (shift = 14 - e)) - 1) + ((outM = m >> shift) & 1) > (hway = 1 << shift - 1)) {
                ++outM;
            }
        } else {
            outE = e;
            outM = m >> 13;
            if ((m & 0x1FFF) + (outM & 1) > 4096) {
                ++outM;
            }
        }
        return (short)(s << 15 | (outE << 10) + outM);
    }

    public static String toHexString(short h) {
        StringBuilder o = new StringBuilder();
        int bits = h & 0xFFFF;
        int s = bits >>> 15;
        int e = bits >>> 10 & 0x1F;
        int m = bits & 0x3FF;
        if (e == 31) {
            if (m == 0) {
                if (s != 0) {
                    o.append('-');
                }
                o.append("Infinity");
            } else {
                o.append("NaN");
            }
        } else {
            if (s == 1) {
                o.append('-');
            }
            if (e == 0) {
                if (m == 0) {
                    o.append("0x0.0p0");
                } else {
                    o.append("0x0.");
                    String significand = Integer.toHexString(m);
                    o.append(significand.replaceFirst("0{2,}$", ""));
                    o.append("p-14");
                }
            } else {
                o.append("0x1.");
                String significand = Integer.toHexString(m);
                o.append(significand.replaceFirst("0{2,}$", ""));
                o.append('p');
                o.append(Integer.toString(e - 15));
            }
        }
        return o.toString();
    }
}

