/*
 * Decompiled with CFR 0.152.
 */
package libcore.icu;

import android.compat.annotation.UnsupportedAppUsage;
import android.icu.impl.ICUResourceBundle;
import android.icu.text.NumberingSystem;
import android.icu.util.UResourceBundle;
import com.android.layoutlib.bridge.android.AndroidLocale;
import dalvik.system.VMRuntime;
import java.text.DateFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import libcore.icu.ICU;
import libcore.util.Objects;

public class LocaleData {
    private static final Locale LOCALE_EN_US_POSIX = new Locale("en", "US", "POSIX");
    public static final long USE_REAL_ROOT_LOCALE = 159047832L;
    private static final HashMap<String, LocaleData> localeDataCache = new HashMap();
    @UnsupportedAppUsage
    public Integer firstDayOfWeek;
    @UnsupportedAppUsage
    public Integer minimalDaysInFirstWeek;
    public String[] amPm;
    public String[] eras;
    public String[] longMonthNames;
    @UnsupportedAppUsage
    public String[] shortMonthNames;
    public String[] tinyMonthNames;
    public String[] longStandAloneMonthNames;
    @UnsupportedAppUsage
    public String[] shortStandAloneMonthNames;
    public String[] tinyStandAloneMonthNames;
    public String[] longWeekdayNames;
    public String[] shortWeekdayNames;
    public String[] tinyWeekdayNames;
    @UnsupportedAppUsage
    public String[] longStandAloneWeekdayNames;
    @UnsupportedAppUsage
    public String[] shortStandAloneWeekdayNames;
    public String[] tinyStandAloneWeekdayNames;
    public String yesterday;
    @UnsupportedAppUsage
    public String today;
    @UnsupportedAppUsage
    public String tomorrow;
    public String fullTimeFormat;
    public String longTimeFormat;
    public String mediumTimeFormat;
    public String shortTimeFormat;
    public String fullDateFormat;
    public String longDateFormat;
    public String mediumDateFormat;
    public String shortDateFormat;
    public String narrowAm;
    public String narrowPm;
    @UnsupportedAppUsage
    public String timeFormat_hm;
    @UnsupportedAppUsage
    public String timeFormat_Hm;
    public String timeFormat_hms;
    public String timeFormat_Hms;
    @UnsupportedAppUsage
    public char zeroDigit;
    public char decimalSeparator;
    public char groupingSeparator;
    public char patternSeparator;
    public String percent;
    public String perMill;
    public char monetarySeparator;
    public String minusSign;
    public String exponentSeparator;
    public String infinity;
    public String NaN;
    public String currencySymbol;
    public String internationalCurrencySymbol;
    public String numberPattern;
    public String integerPattern;
    public String currencyPattern;
    public String percentPattern;

    private LocaleData() {
    }

    @UnsupportedAppUsage
    public static Locale mapInvalidAndNullLocales(Locale locale) {
        if (locale == null) {
            return AndroidLocale.getDefault();
        }
        if ("und".equals(locale.toLanguageTag())) {
            return Locale.ROOT;
        }
        return locale;
    }

    public static Locale getCompatibleLocaleForBug159514442(Locale locale) {
        int targetSdkVersion;
        if (Locale.ROOT.equals(locale) && (targetSdkVersion = VMRuntime.getRuntime().getTargetSdkVersion()) <= 29) {
            locale = LOCALE_EN_US_POSIX;
        }
        return locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public static LocaleData get(Locale locale) {
        if (locale == null) {
            throw new NullPointerException("locale == null");
        }
        locale = LocaleData.getCompatibleLocaleForBug159514442(locale);
        String languageTag = locale.toLanguageTag();
        HashMap<String, LocaleData> hashMap = localeDataCache;
        synchronized (hashMap) {
            LocaleData localeData = localeDataCache.get(languageTag);
            if (localeData != null) {
                return localeData;
            }
        }
        LocaleData newLocaleData = LocaleData.initLocaleData(locale);
        HashMap<String, LocaleData> hashMap2 = localeDataCache;
        synchronized (hashMap2) {
            LocaleData localeData = localeDataCache.get(languageTag);
            if (localeData != null) {
                return localeData;
            }
            localeDataCache.put(languageTag, newLocaleData);
            return newLocaleData;
        }
    }

    public String toString() {
        return Objects.toString(this);
    }

    public String getDateFormat(int style2) {
        switch (style2) {
            case 3: {
                return this.shortDateFormat;
            }
            case 2: {
                return this.mediumDateFormat;
            }
            case 1: {
                return this.longDateFormat;
            }
            case 0: {
                return this.fullDateFormat;
            }
        }
        throw new AssertionError();
    }

    public String getTimeFormat(int style2) {
        switch (style2) {
            case 3: {
                if (DateFormat.is24Hour == null) {
                    return this.shortTimeFormat;
                }
                return DateFormat.is24Hour != false ? this.timeFormat_Hm : this.timeFormat_hm;
            }
            case 2: {
                if (DateFormat.is24Hour == null) {
                    return this.mediumTimeFormat;
                }
                return DateFormat.is24Hour != false ? this.timeFormat_Hms : this.timeFormat_hms;
            }
            case 1: {
                return this.longTimeFormat;
            }
            case 0: {
                return this.fullTimeFormat;
            }
        }
        throw new AssertionError();
    }

    private static LocaleData initLocaleData(Locale locale) {
        LocaleData localeData = new LocaleData();
        if (!ICU.initLocaleDataNative(locale.toLanguageTag(), localeData)) {
            throw new AssertionError((Object)("couldn't initialize LocaleData for locale " + locale));
        }
        LocaleData.initializePatternSeparator(localeData, locale);
        localeData.timeFormat_hm = ICU.getBestDateTimePattern("hm", locale);
        localeData.timeFormat_Hm = ICU.getBestDateTimePattern("Hm", locale);
        localeData.timeFormat_hms = ICU.getBestDateTimePattern("hms", locale);
        localeData.timeFormat_Hms = ICU.getBestDateTimePattern("Hms", locale);
        if (localeData.fullTimeFormat != null) {
            localeData.fullTimeFormat = localeData.fullTimeFormat.replace('v', 'z');
        }
        if (localeData.numberPattern != null) {
            localeData.integerPattern = localeData.numberPattern.replaceAll("\\.[#,]*", "");
        }
        return localeData;
    }

    private static void initializePatternSeparator(LocaleData localeData, Locale locale) {
        NumberingSystem ns = NumberingSystem.getInstance(locale);
        String nsName = ns != null && ns.getRadix() == 10 && !ns.isAlgorithmic() ? ns.getName() : "latn";
        ICUResourceBundle rb = (ICUResourceBundle)UResourceBundle.getBundleInstance("android/icu/impl/data/icudt66b", locale);
        String patternSeparator = null;
        if (!"latn".equals(nsName)) {
            try {
                patternSeparator = rb.getStringWithFallback("NumberElements/" + nsName + "/symbols/list");
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (patternSeparator == null) {
            try {
                patternSeparator = rb.getStringWithFallback("NumberElements/latn/symbols/list");
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (patternSeparator == null || patternSeparator.isEmpty()) {
            patternSeparator = ";";
        }
        localeData.patternSeparator = patternSeparator.charAt(0);
    }

    static {
        LocaleData.get(Locale.ROOT);
        LocaleData.get(Locale.US);
        LocaleData.get(AndroidLocale.getDefault());
    }
}

