/*
 * Decompiled with CFR 0.152.
 */
package dalvik.system;

import android.compat.annotation.UnsupportedAppUsage;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.annotation.optimization.CriticalNative;
import dalvik.annotation.optimization.FastNative;
import dalvik.system.VMRuntime_Delegate;
import java.lang.ref.FinalizerReference;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;

public class VMRuntime {
    private static final VMRuntime THE_ONE = new VMRuntime();
    private static final Map<String, String> ABI_TO_INSTRUCTION_SET_MAP = new HashMap<String, String>(16);
    private static final long PREVENT_META_REFLECTION_BLACKLIST_ACCESS = 142365358L;
    private static final long HIDE_MAXTARGETSDK_P_HIDDEN_APIS = 149997251L;
    private static final long HIDE_MAXTARGETSDK_Q_HIDDEN_APIS = 149994052L;
    static HiddenApiUsageLogger hiddenApiUsageLogger;
    public static final int SDK_VERSION_CUR_DEVELOPMENT = 10000;
    private static Consumer<String> nonSdkApiUsageConsumer;
    private int targetSdkVersion = 10000;
    private int notifyNativeInterval;
    private final AtomicInteger allocationCount = new AtomicInteger(0);
    private long[] disabledCompatChanges = new long[0];

    public static void setHiddenApiUsageLogger(HiddenApiUsageLogger hiddenApiUsageLogger) {
        VMRuntime.hiddenApiUsageLogger = hiddenApiUsageLogger;
    }

    private static void hiddenApiUsed(int sampledValue, String appPackageName, String signature, int accessType, boolean accessDenied) {
        if (hiddenApiUsageLogger != null) {
            hiddenApiUsageLogger.hiddenApiUsed(sampledValue, appPackageName, signature, accessType, accessDenied);
        }
    }

    private VMRuntime() {
    }

    @UnsupportedAppUsage
    public static VMRuntime getRuntime() {
        return THE_ONE;
    }

    public String[] properties() {
        return (String[])OverrideMethod.invokeA("dalvik.system.VMRuntime#properties()[Ljava/lang/String;", true, this);
    }

    public String bootClassPath() {
        return (String)OverrideMethod.invokeA("dalvik.system.VMRuntime#bootClassPath()Ljava/lang/String;", true, this);
    }

    public String classPath() {
        return (String)OverrideMethod.invokeA("dalvik.system.VMRuntime#classPath()Ljava/lang/String;", true, this);
    }

    public String vmVersion() {
        return (String)OverrideMethod.invokeA("dalvik.system.VMRuntime#vmVersion()Ljava/lang/String;", true, this);
    }

    @UnsupportedAppUsage
    public String vmLibrary() {
        return (String)OverrideMethod.invokeA("dalvik.system.VMRuntime#vmLibrary()Ljava/lang/String;", true, this);
    }

    @UnsupportedAppUsage
    public String vmInstructionSet() {
        return (String)OverrideMethod.invokeA("dalvik.system.VMRuntime#vmInstructionSet()Ljava/lang/String;", true, this);
    }

    @UnsupportedAppUsage
    @FastNative
    public boolean is64Bit() {
        return OverrideMethod.invokeI("dalvik.system.VMRuntime#is64Bit()Z", true, this) != 0;
    }

    @FastNative
    public boolean isCheckJniEnabled() {
        return OverrideMethod.invokeI("dalvik.system.VMRuntime#isCheckJniEnabled()Z", true, this) != 0;
    }

    public float getTargetHeapUtilization() {
        return OverrideMethod.invokeF("dalvik.system.VMRuntime#getTargetHeapUtilization()F", true, this);
    }

    public long getFinalizerTimeoutMs() {
        return OverrideMethod.invokeL("dalvik.system.VMRuntime#getFinalizerTimeoutMs()J", true, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public float setTargetHeapUtilization(float newTarget) {
        if (newTarget <= 0.0f || newTarget >= 1.0f) {
            throw new IllegalArgumentException(newTarget + " out of range (0,1)");
        }
        if (newTarget < 0.1f) {
            newTarget = 0.1f;
        }
        VMRuntime vMRuntime = this;
        synchronized (vMRuntime) {
            float oldTarget = this.getTargetHeapUtilization();
            this.nativeSetTargetHeapUtilization(newTarget);
            return oldTarget;
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=0, publicAlternatives="Use the {@code targetSdkVersion} attribute in the {@code uses-sdk} manifest tag instead.")
    public synchronized void setTargetSdkVersion(int targetSdkVersion) {
        this.targetSdkVersion = targetSdkVersion;
        this.setTargetSdkVersionNative(this.targetSdkVersion);
    }

    public synchronized void setDisabledCompatChanges(long[] disabledCompatChanges) {
        this.disabledCompatChanges = disabledCompatChanges;
        this.setDisabledCompatChangesNative(this.disabledCompatChanges);
    }

    public synchronized int getTargetSdkVersion() {
        return this.targetSdkVersion;
    }

    private void setTargetSdkVersionNative(int n) {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#setTargetSdkVersionNative(I)V", true, this);
    }

    private void setDisabledCompatChangesNative(long[] lArray) {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#setDisabledCompatChangesNative([J)V", true, this);
    }

    @Deprecated
    @UnsupportedAppUsage
    public long getMinimumHeapSize() {
        return 0L;
    }

    @Deprecated
    @UnsupportedAppUsage
    public long setMinimumHeapSize(long size) {
        return 0L;
    }

    @Deprecated
    @UnsupportedAppUsage
    public void gcSoftReferences() {
    }

    @Deprecated
    @UnsupportedAppUsage
    public void runFinalizationSync() {
        System.runFinalization();
    }

    private void nativeSetTargetHeapUtilization(float f) {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#nativeSetTargetHeapUtilization(F)V", true, this);
    }

    @Deprecated
    @UnsupportedAppUsage
    public boolean trackExternalAllocation(long size) {
        return true;
    }

    @Deprecated
    @UnsupportedAppUsage
    public void trackExternalFree(long size) {
    }

    @Deprecated
    @UnsupportedAppUsage
    public long getExternalBytesAllocated() {
        return 0L;
    }

    public void startJitCompilation() {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#startJitCompilation()V", true, this);
    }

    public void disableJitCompilation() {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#disableJitCompilation()V", true, this);
    }

    public void setHiddenApiExemptions(String[] stringArray) {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#setHiddenApiExemptions([Ljava/lang/String;)V", true, this);
    }

    public void setHiddenApiAccessLogSamplingRate(int n) {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#setHiddenApiAccessLogSamplingRate(I)V", true, this);
    }

    @UnsupportedAppUsage
    @FastNative
    public Object newNonMovableArray(Class<?> clazz, int n) {
        return OverrideMethod.invokeA("dalvik.system.VMRuntime#newNonMovableArray(Ljava/lang/Class;I)Ljava/lang/Object;", true, this);
    }

    @LayoutlibDelegate
    @FastNative
    public Object newUnpaddedArray(Class<?> clazz, int n) {
        return VMRuntime_Delegate.newUnpaddedArray(this, clazz, n);
    }

    @UnsupportedAppUsage
    @FastNative
    public long addressOf(Object object) {
        return OverrideMethod.invokeL("dalvik.system.VMRuntime#addressOf(Ljava/lang/Object;)J", true, this);
    }

    @UnsupportedAppUsage
    public void clearGrowthLimit() {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#clearGrowthLimit()V", true, this);
    }

    public void clampGrowthLimit() {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#clampGrowthLimit()V", true, this);
    }

    @FastNative
    public boolean isNativeDebuggable() {
        return OverrideMethod.invokeI("dalvik.system.VMRuntime#isNativeDebuggable()Z", true, this) != 0;
    }

    public boolean isJavaDebuggable() {
        return OverrideMethod.invokeI("dalvik.system.VMRuntime#isJavaDebuggable()Z", true, this) != 0;
    }

    @UnsupportedAppUsage
    public void registerNativeAllocation(long l) {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#registerNativeAllocation(J)V", true, this);
    }

    @Deprecated
    @UnsupportedAppUsage
    public void registerNativeAllocation(int bytes) {
        this.registerNativeAllocation((long)bytes);
    }

    @UnsupportedAppUsage
    public void registerNativeFree(long l) {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#registerNativeFree(J)V", true, this);
    }

    @Deprecated
    @UnsupportedAppUsage
    public void registerNativeFree(int bytes) {
        this.registerNativeFree((long)bytes);
    }

    @LayoutlibDelegate
    private static int getNotifyNativeInterval() {
        return VMRuntime_Delegate.getNotifyNativeInterval();
    }

    public void notifyNativeAllocation() {
        int myNotifyNativeInterval = this.notifyNativeInterval;
        if (myNotifyNativeInterval == 0) {
            myNotifyNativeInterval = this.notifyNativeInterval = VMRuntime.getNotifyNativeInterval();
        }
        if (this.allocationCount.addAndGet(1) % myNotifyNativeInterval == 0) {
            this.notifyNativeAllocationsInternal();
        }
    }

    public void notifyNativeAllocationsInternal() {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#notifyNativeAllocationsInternal()V", true, this);
    }

    @UnsupportedAppUsage
    public static void runFinalization(long timeout) {
        try {
            FinalizerReference.finalizeAllEnqueued((long)timeout);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void requestConcurrentGC() {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#requestConcurrentGC()V", true, this);
    }

    public void concurrentGC() {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#concurrentGC()V", true, this);
    }

    public void requestHeapTrim() {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#requestHeapTrim()V", true, this);
    }

    public void trimHeap() {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#trimHeap()V", true, this);
    }

    public void startHeapTaskProcessor() {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#startHeapTaskProcessor()V", true, this);
    }

    public void stopHeapTaskProcessor() {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#stopHeapTaskProcessor()V", true, this);
    }

    public void runHeapTasks() {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#runHeapTasks()V", true, this);
    }

    public void updateProcessState(int n) {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#updateProcessState(I)V", true, this);
    }

    public void notifyStartupCompleted() {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#notifyStartupCompleted()V", true, this);
    }

    public void preloadDexCaches() {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#preloadDexCaches()V", true, this);
    }

    public static void registerAppInfo(String string2, String[] stringArray) {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#registerAppInfo(Ljava/lang/String;[Ljava/lang/String;)V", true, null);
    }

    @UnsupportedAppUsage
    public static String getInstructionSet(String abi) {
        String instructionSet = ABI_TO_INSTRUCTION_SET_MAP.get(abi);
        if (instructionSet == null) {
            throw new IllegalArgumentException("Unsupported ABI: " + abi);
        }
        return instructionSet;
    }

    public static boolean is64BitInstructionSet(String instructionSet) {
        return "arm64".equals(instructionSet) || "x86_64".equals(instructionSet) || "mips64".equals(instructionSet);
    }

    @UnsupportedAppUsage
    public static boolean is64BitAbi(String abi) {
        return VMRuntime.is64BitInstructionSet(VMRuntime.getInstructionSet(abi));
    }

    @CriticalNative
    public static void doNotInitializeInAot() {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#doNotInitializeInAot()V", true, null);
    }

    public static boolean isBootClassPathOnDisk(String string2) {
        return OverrideMethod.invokeI("dalvik.system.VMRuntime#isBootClassPathOnDisk(Ljava/lang/String;)Z", true, null) != 0;
    }

    @FastNative
    public static boolean hasBootImageSpaces() {
        return OverrideMethod.invokeI("dalvik.system.VMRuntime#hasBootImageSpaces()Z", true, null) != 0;
    }

    public static void bootCompleted() {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#bootCompleted()V", true, null);
    }

    public static void resetJitCounters() {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#resetJitCounters()V", true, null);
    }

    @UnsupportedAppUsage
    public static String getCurrentInstructionSet() {
        return (String)OverrideMethod.invokeA("dalvik.system.VMRuntime#getCurrentInstructionSet()Ljava/lang/String;", true, null);
    }

    public static boolean didPruneDalvikCache() {
        return OverrideMethod.invokeI("dalvik.system.VMRuntime#didPruneDalvikCache()Z", true, null) != 0;
    }

    public static void registerSensitiveThread() {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#registerSensitiveThread()V", true, null);
    }

    public static void setSystemDaemonThreadPriority() {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#setSystemDaemonThreadPriority()V", true, null);
    }

    public static void setNonSdkApiUsageConsumer(Consumer<String> consumer) {
        nonSdkApiUsageConsumer = consumer;
    }

    public static void setDedupeHiddenApiWarnings(boolean bl) {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#setDedupeHiddenApiWarnings(Z)V", true, null);
    }

    public static void setProcessPackageName(String string2) {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#setProcessPackageName(Ljava/lang/String;)V", true, null);
    }

    public static void setProcessDataDirectory(String string2) {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#setProcessDataDirectory(Ljava/lang/String;)V", true, null);
    }

    public static boolean isValidClassLoaderContext(String string2) {
        return OverrideMethod.invokeI("dalvik.system.VMRuntime#isValidClassLoaderContext(Ljava/lang/String;)Z", true, null) != 0;
    }

    static {
        ABI_TO_INSTRUCTION_SET_MAP.put("armeabi", "arm");
        ABI_TO_INSTRUCTION_SET_MAP.put("armeabi-v7a", "arm");
        ABI_TO_INSTRUCTION_SET_MAP.put("mips", "mips");
        ABI_TO_INSTRUCTION_SET_MAP.put("mips64", "mips64");
        ABI_TO_INSTRUCTION_SET_MAP.put("x86", "x86");
        ABI_TO_INSTRUCTION_SET_MAP.put("x86_64", "x86_64");
        ABI_TO_INSTRUCTION_SET_MAP.put("arm64-v8a", "arm64");
        ABI_TO_INSTRUCTION_SET_MAP.put("arm64-v8a-hwasan", "arm64");
        nonSdkApiUsageConsumer = null;
    }

    public static interface HiddenApiUsageLogger {
        public static final int ACCESS_METHOD_NONE = 0;
        public static final int ACCESS_METHOD_REFLECTION = 1;
        public static final int ACCESS_METHOD_JNI = 2;
        public static final int ACCESS_METHOD_LINKING = 3;

        public void hiddenApiUsed(int var1, String var2, String var3, int var4, boolean var5);
    }
}

