/*
 * Decompiled with CFR 0.152.
 */
package dalvik.system;

import android.compat.annotation.UnsupportedAppUsage;
import android.system.ErrnoException;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.annotation.optimization.ReachabilitySensitive;
import dalvik.system.DexPathList;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import libcore.io.Libcore;

@Deprecated
public class DexFile {
    @ReachabilitySensitive
    @UnsupportedAppUsage
    private Object mCookie;
    @UnsupportedAppUsage
    private Object mInternalCookie;
    @UnsupportedAppUsage
    private final String mFileName;
    public static final int NO_DEXOPT_NEEDED = 0;
    public static final int DEX2OAT_FROM_SCRATCH = 1;
    public static final int DEX2OAT_FOR_BOOT_IMAGE = 2;
    public static final int DEX2OAT_FOR_FILTER = 3;

    @Deprecated
    public DexFile(File file) throws IOException {
        this(file.getPath());
    }

    DexFile(File file, ClassLoader loader, DexPathList.Element[] elements) throws IOException {
        this(file.getPath(), loader, elements);
    }

    @Deprecated
    public DexFile(String fileName) throws IOException {
        this(fileName, null, null);
    }

    DexFile(String fileName, ClassLoader loader, DexPathList.Element[] elements) throws IOException {
        this.mInternalCookie = this.mCookie = DexFile.openDexFile(fileName, null, 0, loader, elements);
        this.mFileName = fileName;
    }

    DexFile(ByteBuffer[] bufs, ClassLoader loader, DexPathList.Element[] elements) throws IOException {
        this.mInternalCookie = this.mCookie = DexFile.openInMemoryDexFiles(bufs, loader, elements);
        this.mFileName = null;
    }

    private DexFile(String sourceName, String outputName, int flags, ClassLoader loader, DexPathList.Element[] elements) throws IOException {
        if (outputName != null) {
            try {
                String parent = new File(outputName).getParent();
                if (Libcore.os.getuid() != Libcore.os.stat((String)parent).st_uid) {
                    throw new IllegalArgumentException("Optimized data directory " + parent + " is not owned by the current user. Shared storage cannot protect your application from code injection attacks.");
                }
            }
            catch (ErrnoException errnoException) {
                // empty catch block
            }
        }
        this.mInternalCookie = this.mCookie = DexFile.openDexFile(sourceName, outputName, flags, loader, elements);
        this.mFileName = sourceName;
    }

    @Deprecated
    public static DexFile loadDex(String sourcePathName, String outputPathName, int flags) throws IOException {
        return DexFile.loadDex(sourcePathName, outputPathName, flags, null, null);
    }

    @UnsupportedAppUsage
    static DexFile loadDex(String sourcePathName, String outputPathName, int flags, ClassLoader loader, DexPathList.Element[] elements) throws IOException {
        return new DexFile(sourcePathName, outputPathName, flags, loader, elements);
    }

    public String getName() {
        return this.mFileName;
    }

    public String toString() {
        if (this.mFileName != null) {
            return this.getName();
        }
        return "InMemoryDexFile[cookie=" + Arrays.toString((long[])this.mCookie) + "]";
    }

    public void close() throws IOException {
        if (this.mInternalCookie != null) {
            if (DexFile.closeDexFile(this.mInternalCookie)) {
                this.mInternalCookie = null;
            }
            this.mCookie = null;
        }
    }

    public Class loadClass(String name, ClassLoader loader) {
        String slashName = name.replace('.', '/');
        return this.loadClassBinaryName(slashName, loader, null);
    }

    @UnsupportedAppUsage
    public Class loadClassBinaryName(String name, ClassLoader loader, List<Throwable> suppressed) {
        return DexFile.defineClass(name, loader, this.mCookie, this, suppressed);
    }

    private static Class defineClass(String name, ClassLoader loader, Object cookie, DexFile dexFile, List<Throwable> suppressed) {
        Class result;
        block4: {
            result = null;
            try {
                result = DexFile.defineClassNative(name, loader, cookie, dexFile);
            }
            catch (NoClassDefFoundError e) {
                if (suppressed != null) {
                    suppressed.add(e);
                }
            }
            catch (ClassNotFoundException e) {
                if (suppressed == null) break block4;
                suppressed.add(e);
            }
        }
        return result;
    }

    public Enumeration<String> entries() {
        return new DFEnum(this);
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mInternalCookie != null && !DexFile.closeDexFile(this.mInternalCookie)) {
                throw new AssertionError((Object)"Failed to close dex file in finalizer.");
            }
            this.mInternalCookie = null;
            this.mCookie = null;
        }
        finally {
            super.finalize();
        }
    }

    @UnsupportedAppUsage
    private static Object openDexFile(String sourceName, String outputName, int flags, ClassLoader loader, DexPathList.Element[] elements) throws IOException {
        return DexFile.openDexFileNative(new File(sourceName).getAbsolutePath(), outputName == null ? null : new File(outputName).getAbsolutePath(), flags, loader, elements);
    }

    private static Object openInMemoryDexFiles(ByteBuffer[] bufs, ClassLoader loader, DexPathList.Element[] elements) throws IOException {
        byte[][] arrays = new byte[bufs.length][];
        int[] starts = new int[bufs.length];
        int[] ends = new int[bufs.length];
        for (int i = 0; i < bufs.length; ++i) {
            arrays[i] = bufs[i].isDirect() ? null : bufs[i].array();
            starts[i] = bufs[i].position();
            ends[i] = bufs[i].limit();
        }
        return DexFile.openInMemoryDexFilesNative(bufs, arrays, starts, ends, loader, elements);
    }

    private static Object openInMemoryDexFilesNative(ByteBuffer[] byteBufferArray, byte[][] byArray, int[] nArray, int[] nArray2, ClassLoader classLoader, DexPathList.Element[] elementArray) {
        return OverrideMethod.invokeA("dalvik.system.DexFile#openInMemoryDexFilesNative([Ljava/nio/ByteBuffer;[[B[I[ILjava/lang/ClassLoader;[Ldalvik/system/DexPathList$Element;)Ljava/lang/Object;", true, null);
    }

    void verifyInBackground(ClassLoader classLoader, String classLoaderContext) {
        DexFile.verifyInBackgroundNative(this.mCookie, classLoader, classLoaderContext);
    }

    private static void verifyInBackgroundNative(Object object, ClassLoader classLoader, String string2) {
        OverrideMethod.invokeV("dalvik.system.DexFile#verifyInBackgroundNative(Ljava/lang/Object;Ljava/lang/ClassLoader;Ljava/lang/String;)V", true, null);
    }

    static String getClassLoaderContext(ClassLoader classLoader, DexPathList.Element[] elementArray) {
        return (String)OverrideMethod.invokeA("dalvik.system.DexFile#getClassLoaderContext(Ljava/lang/ClassLoader;[Ldalvik/system/DexPathList$Element;)Ljava/lang/String;", true, null);
    }

    @UnsupportedAppUsage
    boolean isBackedByOatFile() {
        return DexFile.isBackedByOatFile(this.mCookie);
    }

    void setTrusted() {
        DexFile.setTrusted(this.mCookie);
    }

    private static boolean closeDexFile(Object object) {
        return OverrideMethod.invokeI("dalvik.system.DexFile#closeDexFile(Ljava/lang/Object;)Z", true, null) != 0;
    }

    private static Class defineClassNative(String string2, ClassLoader classLoader, Object object, DexFile dexFile) throws ClassNotFoundException, NoClassDefFoundError {
        return (Class)OverrideMethod.invokeA("dalvik.system.DexFile#defineClassNative(Ljava/lang/String;Ljava/lang/ClassLoader;Ljava/lang/Object;Ldalvik/system/DexFile;)Ljava/lang/Class;", true, null);
    }

    @UnsupportedAppUsage
    private static String[] getClassNameList(Object object) {
        return (String[])OverrideMethod.invokeA("dalvik.system.DexFile#getClassNameList(Ljava/lang/Object;)[Ljava/lang/String;", true, null);
    }

    private static boolean isBackedByOatFile(Object object) {
        return OverrideMethod.invokeI("dalvik.system.DexFile#isBackedByOatFile(Ljava/lang/Object;)Z", true, null) != 0;
    }

    private static void setTrusted(Object object) {
        OverrideMethod.invokeV("dalvik.system.DexFile#setTrusted(Ljava/lang/Object;)V", true, null);
    }

    @UnsupportedAppUsage
    private static Object openDexFileNative(String string2, String string3, int n, ClassLoader classLoader, DexPathList.Element[] elementArray) {
        return OverrideMethod.invokeA("dalvik.system.DexFile#openDexFileNative(Ljava/lang/String;Ljava/lang/String;ILjava/lang/ClassLoader;[Ldalvik/system/DexPathList$Element;)Ljava/lang/Object;", true, null);
    }

    public static boolean isDexOptNeeded(String string2) throws FileNotFoundException, IOException {
        return OverrideMethod.invokeI("dalvik.system.DexFile#isDexOptNeeded(Ljava/lang/String;)Z", true, null) != 0;
    }

    public static int getDexOptNeeded(String fileName, String instructionSet, String compilerFilter, boolean newProfile, boolean downgrade) throws FileNotFoundException, IOException {
        return DexFile.getDexOptNeeded(fileName, instructionSet, compilerFilter, null, newProfile, downgrade);
    }

    public static int getDexOptNeeded(String string2, String string3, String string4, String string5, boolean bl, boolean bl2) throws FileNotFoundException, IOException {
        return OverrideMethod.invokeI("dalvik.system.DexFile#getDexOptNeeded(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZZ)I", true, null);
    }

    public static String getDexFileStatus(String string2, String string3) throws FileNotFoundException {
        return (String)OverrideMethod.invokeA("dalvik.system.DexFile#getDexFileStatus(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", true, null);
    }

    public static OptimizationInfo getDexFileOptimizationInfo(String fileName, String instructionSet) throws FileNotFoundException {
        String[] status = DexFile.getDexFileOptimizationStatus(fileName, instructionSet);
        return new OptimizationInfo(status[0], status[1]);
    }

    private static String[] getDexFileOptimizationStatus(String string2, String string3) throws FileNotFoundException {
        return (String[])OverrideMethod.invokeA("dalvik.system.DexFile#getDexFileOptimizationStatus(Ljava/lang/String;Ljava/lang/String;)[Ljava/lang/String;", true, null);
    }

    public static String[] getDexFileOutputPaths(String string2, String string3) throws FileNotFoundException {
        return (String[])OverrideMethod.invokeA("dalvik.system.DexFile#getDexFileOutputPaths(Ljava/lang/String;Ljava/lang/String;)[Ljava/lang/String;", true, null);
    }

    public static boolean isValidCompilerFilter(String string2) {
        return OverrideMethod.invokeI("dalvik.system.DexFile#isValidCompilerFilter(Ljava/lang/String;)Z", true, null) != 0;
    }

    public static boolean isProfileGuidedCompilerFilter(String string2) {
        return OverrideMethod.invokeI("dalvik.system.DexFile#isProfileGuidedCompilerFilter(Ljava/lang/String;)Z", true, null) != 0;
    }

    public static String getNonProfileGuidedCompilerFilter(String string2) {
        return (String)OverrideMethod.invokeA("dalvik.system.DexFile#getNonProfileGuidedCompilerFilter(Ljava/lang/String;)Ljava/lang/String;", true, null);
    }

    public static String getSafeModeCompilerFilter(String string2) {
        return (String)OverrideMethod.invokeA("dalvik.system.DexFile#getSafeModeCompilerFilter(Ljava/lang/String;)Ljava/lang/String;", true, null);
    }

    public long getStaticSizeOfDexFile() {
        return DexFile.getStaticSizeOfDexFile(this.mCookie);
    }

    private static long getStaticSizeOfDexFile(Object object) {
        return OverrideMethod.invokeL("dalvik.system.DexFile#getStaticSizeOfDexFile(Ljava/lang/Object;)J", true, null);
    }

    public static class OptimizationInfo {
        private final String status;
        private final String reason;

        private OptimizationInfo(String status, String reason) {
            this.status = status;
            this.reason = reason;
        }

        public String getStatus() {
            return this.status;
        }

        public String getReason() {
            return this.reason;
        }
    }

    private static class DFEnum
    implements Enumeration<String> {
        private int mIndex = 0;
        @UnsupportedAppUsage
        private String[] mNameList;

        DFEnum(DexFile df) {
            this.mNameList = DexFile.getClassNameList(df.mCookie);
        }

        @Override
        public boolean hasMoreElements() {
            return this.mIndex < this.mNameList.length;
        }

        @Override
        public String nextElement() {
            return this.mNameList[this.mIndex++];
        }
    }
}

