/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework.uielement;

import android.content.Context;
import android.os.Parcel;
import android.os._Original_Build;
import android.view.WindowManager;
import com.android.layoutlib.bridge.android.AndroidLocale;
import com.google.android.apps.common.testing.accessibility.framework.uielement.DeviceState;
import com.google.android.apps.common.testing.accessibility.framework.uielement.DisplayInfoAndroid;
import com.google.android.apps.common.testing.accessibility.framework.uielement.proto.AccessibilityHierarchyProtos;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Locale;

public class DeviceStateAndroid
extends DeviceState {
    private final DisplayInfoAndroid defaultDisplayInfo;

    private DeviceStateAndroid(int sdkVersion, Locale locale, DisplayInfoAndroid defaultDisplayInfo) {
        super(sdkVersion, locale);
        this.defaultDisplayInfo = defaultDisplayInfo;
    }

    @Override
    public DisplayInfoAndroid getDefaultDisplayInfo() {
        return this.defaultDisplayInfo;
    }

    void writeToParcel(Parcel out, int flags) {
        this.defaultDisplayInfo.writeToParcel(out, flags);
        out.writeInt(this.sdkVersion);
        out.writeString(this.getLanguageTag());
    }

    @Override
    AccessibilityHierarchyProtos.DeviceStateProto toProto() {
        AccessibilityHierarchyProtos.DeviceStateProto.Builder builder = AccessibilityHierarchyProtos.DeviceStateProto.newBuilder();
        builder.setSdkVersion(this.sdkVersion);
        builder.setDefaultDisplayInfo(this.defaultDisplayInfo.toProto());
        builder.setLocale(this.getLanguageTag());
        return (AccessibilityHierarchyProtos.DeviceStateProto)builder.build();
    }

    private String getLanguageTag() {
        if (_Original_Build.VERSION.SDK_INT >= 21) {
            return this.locale.toLanguageTag();
        }
        return DeviceStateAndroid.getStringFromLocale(this.locale);
    }

    private static Locale getLocaleFromLanguageTag(String languageTag) {
        if (_Original_Build.VERSION.SDK_INT >= 21) {
            return Locale.forLanguageTag(languageTag);
        }
        return DeviceStateAndroid.getLocaleFromString(languageTag);
    }

    static Builder newBuilder(Context context) {
        return new Builder(context);
    }

    static Builder newBuilder(Parcel fromParcel) {
        return new Builder(fromParcel);
    }

    static Builder newBuilder(AccessibilityHierarchyProtos.DeviceStateProto fromProto) {
        return new Builder((AccessibilityHierarchyProtos.DeviceStateProto)Preconditions.checkNotNull((Object)fromProto));
    }

    @VisibleForTesting
    static String getStringFromLocale(Locale locale) {
        return locale.toString().replace('_', '-');
    }

    @VisibleForTesting
    static Locale getLocaleFromString(String str) {
        List parts = HYPHEN_SPLITTER.splitToList((CharSequence)str);
        switch (parts.size()) {
            case 1: {
                return new Locale((String)parts.get(0));
            }
            case 2: {
                return new Locale((String)parts.get(0), (String)parts.get(1));
            }
            case 3: {
                return new Locale((String)parts.get(0), (String)parts.get(1), (String)parts.get(2));
            }
        }
        throw new IllegalArgumentException("Unsupported locale string: " + str);
    }

    public static class Builder {
        private final int sdkVersion;
        private final Locale locale;
        private final DisplayInfoAndroid defaultDisplayInfo;

        Builder(Context context) {
            WindowManager wm = (WindowManager)context.getSystemService("window");
            this.defaultDisplayInfo = new DisplayInfoAndroid(wm.getDefaultDisplay());
            this.sdkVersion = _Original_Build.VERSION.SDK_INT;
            this.locale = AndroidLocale.getDefault();
        }

        Builder(Parcel fromParcel) {
            this.defaultDisplayInfo = new DisplayInfoAndroid(fromParcel);
            this.sdkVersion = fromParcel.readInt();
            this.locale = DeviceStateAndroid.getLocaleFromLanguageTag((String)Preconditions.checkNotNull((Object)fromParcel.readString()));
        }

        Builder(AccessibilityHierarchyProtos.DeviceStateProto fromProto) {
            this.sdkVersion = fromProto.getSdkVersion();
            this.defaultDisplayInfo = new DisplayInfoAndroid(fromProto.getDefaultDisplayInfo());
            String languageTag = fromProto.getLocale();
            this.locale = languageTag.isEmpty() ? AndroidLocale.getDefault() : DeviceStateAndroid.getLocaleFromLanguageTag(languageTag);
        }

        public DeviceStateAndroid build() {
            return new DeviceStateAndroid(this.sdkVersion, this.locale, this.defaultDisplayInfo);
        }
    }
}

