/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework.checks;

import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheck;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityHierarchyCheck;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityHierarchyCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityHierarchyCheckResultWithImage;
import com.google.android.apps.common.testing.accessibility.framework.HashMapResultMetadata;
import com.google.android.apps.common.testing.accessibility.framework.Parameters;
import com.google.android.apps.common.testing.accessibility.framework.ResultMetadata;
import com.google.android.apps.common.testing.accessibility.framework.ViewHierarchyElementUtils;
import com.google.android.apps.common.testing.accessibility.framework.replacements.Rect;
import com.google.android.apps.common.testing.accessibility.framework.strings.StringManager;
import com.google.android.apps.common.testing.accessibility.framework.uielement.AccessibilityHierarchy;
import com.google.android.apps.common.testing.accessibility.framework.uielement.ViewHierarchyElement;
import com.google.android.apps.common.testing.accessibility.framework.utils.contrast.ContrastSwatch;
import com.google.android.apps.common.testing.accessibility.framework.utils.contrast.Image;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ImageContrastCheck
extends AccessibilityHierarchyCheck {
    public static final int RESULT_ID_NOT_VISIBLE = 1;
    public static final int RESULT_ID_NOT_IMAGEVIEW = 2;
    public static final int RESULT_ID_NO_SCREENCAPTURE = 3;
    public static final int RESULT_ID_VIEW_NOT_WITHIN_SCREENCAPTURE = 4;
    public static final int RESULT_ID_IMAGE_CONTRAST_NOT_SUFFICIENT = 5;
    public static final int RESULT_ID_NOT_ENABLED = 6;
    public static final int RESULT_ID_SCREENCAPTURE_DATA_HIDDEN = 7;
    public static final int RESULT_ID_CUSTOMIZED_IMAGE_CONTRAST_NOT_SUFFICIENT = 8;
    public static final int RESULT_ID_SCREENCAPTURE_UNIFORM_COLOR = 9;
    public static final String KEY_BACKGROUND_COLOR = "KEY_BACKGROUND_COLOR";
    public static final String KEY_CONTRAST_RATIO = "KEY_CONTRAST_RATIO";
    public static final String KEY_FOREGROUND_COLOR = "KEY_FOREGROUND_COLOR";
    public static final String KEY_SCREENSHOT_BOUNDS_STRING = "KEY_SCREENSHOT_BOUNDS_STRING";
    public static final String KEY_VIEW_BOUNDS_STRING = "KEY_VIEW_BOUNDS_STRING";
    public static final String KEY_CUSTOMIZED_HEURISTIC_CONTRAST_RATIO = "KEY_CUSTOMIZED_HEURISTIC_CONTRAST_RATIO";
    public static final String KEY_IS_POTENTIALLY_OBSCURED = "KEY_IS_POTENTIALLY_OBSCURED";
    public static final String KEY_IS_AGAINST_SCROLLABLE_EDGE = "KEY_IS_AGAINST_SCROLLABLE_EDGE";
    public static final String KEY_ADDITIONAL_FOREGROUND_COLORS = "KEY_ADDITIONAL_FOREGROUND_COLORS";
    public static final String KEY_ADDITIONAL_CONTRAST_RATIOS = "KEY_ADDITIONAL_CONTRAST_RATIOS";
    private static final double CONTRAST_TOLERANCE = 0.01;
    private static final Class<? extends AccessibilityHierarchyCheck> CHECK_CLASS = ImageContrastCheck.class;

    @Override
    protected String getHelpTopic() {
        return "7158390";
    }

    @Override
    public AccessibilityCheck.Category getCategory() {
        return AccessibilityCheck.Category.LOW_CONTRAST;
    }

    @Override
    public List<AccessibilityHierarchyCheckResult> runCheckOnHierarchy(AccessibilityHierarchy hierarchy, @Nullable ViewHierarchyElement fromRoot, @Nullable Parameters parameters) {
        ArrayList<AccessibilityHierarchyCheckResult> results = new ArrayList<AccessibilityHierarchyCheckResult>();
        List<? extends ViewHierarchyElement> viewsToEval = ImageContrastCheck.getElementsToEvaluate(fromRoot, hierarchy);
        for (ViewHierarchyElement viewHierarchyElement : viewsToEval) {
            if (!Boolean.TRUE.equals(viewHierarchyElement.isVisibleToUser())) {
                results.add(new AccessibilityHierarchyCheckResult(CHECK_CLASS, AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, viewHierarchyElement, 1, null));
                continue;
            }
            if (!viewHierarchyElement.checkInstanceOf("android.widget.ImageView")) {
                results.add(new AccessibilityHierarchyCheckResult(CHECK_CLASS, AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, viewHierarchyElement, 2, null));
                continue;
            }
            if (!viewHierarchyElement.isEnabled()) {
                results.add(new AccessibilityHierarchyCheckResult(CHECK_CLASS, AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, viewHierarchyElement, 6, null));
                continue;
            }
            AccessibilityHierarchyCheckResult heavyweightResult = this.attemptHeavyweightEval(viewHierarchyElement, parameters);
            if (heavyweightResult == null) continue;
            results.add(heavyweightResult);
        }
        return results;
    }

    private @Nullable AccessibilityHierarchyCheckResult attemptHeavyweightEval(ViewHierarchyElement view, @Nullable Parameters parameters) {
        Double customizedHeuristicContrastRatio;
        Image screenCapture;
        Image image = screenCapture = parameters == null ? null : parameters.getScreenCapture();
        if (screenCapture == null) {
            return new AccessibilityHierarchyCheckResult(CHECK_CLASS, AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, view, 3, null);
        }
        Rect screenCaptureBounds = new Rect(0, 0, screenCapture.getWidth(), screenCapture.getHeight());
        Rect viewBounds = view.getBoundsInScreen();
        if (viewBounds.isEmpty() || !screenCaptureBounds.contains(viewBounds)) {
            HashMapResultMetadata resultMetadata = new HashMapResultMetadata();
            resultMetadata.putString(KEY_VIEW_BOUNDS_STRING, viewBounds.toShortString());
            resultMetadata.putString(KEY_SCREENSHOT_BOUNDS_STRING, screenCaptureBounds.toShortString());
            return new AccessibilityHierarchyCheckResult(CHECK_CLASS, AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, view, 4, resultMetadata);
        }
        Image viewImage = ImageContrastCheck.crop(screenCapture, viewBounds);
        ContrastSwatch contrastSwatch = this.getContrastSwatch(viewImage, parameters == null ? null : parameters.getEnableEnhancedContrastEvaluation());
        HashMapResultMetadata resultMetadata = new HashMapResultMetadata();
        if (view.isAgainstScrollableEdge()) {
            resultMetadata.putBoolean(KEY_IS_AGAINST_SCROLLABLE_EDGE, true);
        }
        int foreground = (Integer)contrastSwatch.getForegroundColors().get(0);
        int background = contrastSwatch.getBackgroundColor();
        if (background == foreground) {
            return new AccessibilityHierarchyCheckResult(CHECK_CLASS, AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, view, foreground == -16777216 ? 7 : 9, resultMetadata);
        }
        ImmutableList<Integer> foregroundColors = contrastSwatch.getForegroundColors();
        ImmutableList<Double> contrastRatios = contrastSwatch.getContrastRatios();
        ArrayList<Integer> lowForegroundColors = new ArrayList<Integer>();
        ArrayList<Double> lowContrastRatios = new ArrayList<Double>();
        Double d = customizedHeuristicContrastRatio = parameters == null ? null : parameters.getCustomContrastRatio();
        if (customizedHeuristicContrastRatio != null) {
            for (int i = 0; i < contrastRatios.size(); ++i) {
                if (!(customizedHeuristicContrastRatio - (Double)contrastRatios.get(i) > 0.01)) continue;
                lowForegroundColors.add((Integer)foregroundColors.get(i));
                lowContrastRatios.add((Double)contrastRatios.get(i));
            }
            if (!lowContrastRatios.isEmpty()) {
                if (ViewHierarchyElementUtils.isPotentiallyObscured(view)) {
                    resultMetadata.putBoolean(KEY_IS_POTENTIALLY_OBSCURED, true);
                }
                resultMetadata.putDouble(KEY_CUSTOMIZED_HEURISTIC_CONTRAST_RATIO, customizedHeuristicContrastRatio);
                ImageContrastCheck.storeColorsAndContrastRatios(resultMetadata, background, lowForegroundColors, lowContrastRatios);
                return ImageContrastCheck.resultPossiblyWithImage(AccessibilityCheckResult.AccessibilityCheckResultType.WARNING, view, 8, resultMetadata, parameters, viewImage);
            }
        } else {
            for (int i = 0; i < contrastRatios.size(); ++i) {
                if (!(3.0 - (Double)contrastRatios.get(i) > 0.01)) continue;
                lowForegroundColors.add((Integer)foregroundColors.get(i));
                lowContrastRatios.add((Double)contrastRatios.get(i));
            }
            if (!lowContrastRatios.isEmpty()) {
                if (ViewHierarchyElementUtils.isPotentiallyObscured(view)) {
                    resultMetadata.putBoolean(KEY_IS_POTENTIALLY_OBSCURED, true);
                }
                ImageContrastCheck.storeColorsAndContrastRatios(resultMetadata, background, lowForegroundColors, lowContrastRatios);
                return ImageContrastCheck.resultPossiblyWithImage(AccessibilityCheckResult.AccessibilityCheckResultType.WARNING, view, 5, resultMetadata, parameters, viewImage);
            }
        }
        return null;
    }

    @Override
    public String getMessageForResultData(Locale locale, int resultId, @Nullable ResultMetadata metadata) {
        String generated = ImageContrastCheck.generateMessageForResultId(locale, resultId);
        if (generated != null) {
            return generated;
        }
        Preconditions.checkNotNull((Object)metadata);
        switch (resultId) {
            case 4: {
                return String.format(locale, StringManager.getString(locale, "result_message_view_not_within_screencapture"), metadata.getString(KEY_VIEW_BOUNDS_STRING), metadata.getString(KEY_SCREENSHOT_BOUNDS_STRING));
            }
            case 5: {
                StringBuilder builder = new StringBuilder(String.format(locale, StringManager.getString(locale, "result_message_image_contrast_not_sufficient"), metadata.getDouble(KEY_CONTRAST_RATIO), 3.0, metadata.getInt(KEY_FOREGROUND_COLOR) & 0xFFFFFF, metadata.getInt(KEY_BACKGROUND_COLOR) & 0xFFFFFF));
                ImageContrastCheck.appendMetadataStringsToMessageIfNeeded(locale, metadata, builder);
                return builder.toString();
            }
            case 8: {
                StringBuilder builder = new StringBuilder(String.format(locale, StringManager.getString(locale, "result_message_image_customized_contrast_not_sufficient"), metadata.getDouble(KEY_CONTRAST_RATIO), metadata.getDouble(KEY_CUSTOMIZED_HEURISTIC_CONTRAST_RATIO), metadata.getInt(KEY_FOREGROUND_COLOR) & 0xFFFFFF, metadata.getInt(KEY_BACKGROUND_COLOR) & 0xFFFFFF));
                ImageContrastCheck.appendMetadataStringsToMessageIfNeeded(locale, metadata, builder);
                return builder.toString();
            }
        }
        throw new IllegalStateException("Unsupported result id");
    }

    @Override
    public String getShortMessageForResultData(Locale locale, int resultId, @Nullable ResultMetadata metadata) {
        String generated = ImageContrastCheck.generateMessageForResultId(locale, resultId);
        if (generated != null) {
            return generated;
        }
        switch (resultId) {
            case 4: {
                return StringManager.getString(locale, "result_message_no_screencapture");
            }
            case 5: 
            case 8: {
                return StringManager.getString(locale, "result_message_brief_image_contrast_not_sufficient");
            }
        }
        throw new IllegalStateException("Unsupported result id");
    }

    @Override
    public @Nullable Double getSecondaryPriority(AccessibilityHierarchyCheckResult result) {
        ResultMetadata metadata = result.getMetadata();
        switch (result.getResultId()) {
            case 5: {
                return 3.0 - ((ResultMetadata)Preconditions.checkNotNull((Object)metadata)).getDouble(KEY_CONTRAST_RATIO, 0.0);
            }
            case 8: {
                return ((ResultMetadata)Preconditions.checkNotNull((Object)metadata)).getDouble(KEY_CUSTOMIZED_HEURISTIC_CONTRAST_RATIO, 0.0) - ((ResultMetadata)Preconditions.checkNotNull((Object)metadata)).getDouble(KEY_CONTRAST_RATIO, 0.0);
            }
        }
        return null;
    }

    @Override
    public String getTitleMessage(Locale locale) {
        return StringManager.getString(locale, "check_title_image_contrast");
    }

    @VisibleForTesting
    ContrastSwatch getContrastSwatch(Image image, @Nullable Boolean enableEnhancedContrastEvaluation) {
        return new ContrastSwatch(image, enableEnhancedContrastEvaluation == null ? false : enableEnhancedContrastEvaluation);
    }

    private static Image crop(Image screenCapture, Rect viewBounds) {
        return screenCapture.crop(viewBounds.getLeft(), viewBounds.getTop(), viewBounds.getWidth(), viewBounds.getHeight());
    }

    private static AccessibilityHierarchyCheckResult resultPossiblyWithImage(AccessibilityCheckResult.AccessibilityCheckResultType type, ViewHierarchyElement view, int resultId, ResultMetadata metadata, @Nullable Parameters parameters, @Nullable Image viewImage) {
        if (viewImage != null && parameters != null && Boolean.TRUE.equals(parameters.getSaveViewImages())) {
            return new AccessibilityHierarchyCheckResultWithImage(CHECK_CLASS, type, view, resultId, metadata, viewImage);
        }
        return new AccessibilityHierarchyCheckResult(CHECK_CLASS, type, view, resultId, metadata);
    }

    private static void storeColorsAndContrastRatios(ResultMetadata resultMetadata, int background, List<Integer> foregroundColors, List<Double> contrastRatios) {
        resultMetadata.putInt(KEY_BACKGROUND_COLOR, background);
        ImageContrastCheck.storeForegroundColors(resultMetadata, foregroundColors);
        ImageContrastCheck.storeContrastRatios(resultMetadata, contrastRatios);
    }

    private static void storeForegroundColors(ResultMetadata resultMetadata, List<Integer> foregroundColors) {
        resultMetadata.putInt(KEY_FOREGROUND_COLOR, foregroundColors.get(0));
        if (foregroundColors.size() > 1) {
            resultMetadata.putStringList(KEY_ADDITIONAL_FOREGROUND_COLORS, Lists.transform(foregroundColors.subList(1, foregroundColors.size()), integer2 -> integer2.toString()));
        }
    }

    private static void storeContrastRatios(ResultMetadata resultMetadata, List<Double> contrastRatios) {
        resultMetadata.putDouble(KEY_CONTRAST_RATIO, contrastRatios.get(0));
        if (contrastRatios.size() > 1) {
            resultMetadata.putStringList(KEY_ADDITIONAL_CONTRAST_RATIOS, Lists.transform(contrastRatios.subList(1, contrastRatios.size()), ratio -> ratio.toString()));
        }
    }

    private static void appendMetadataStringsToMessageIfNeeded(Locale locale, ResultMetadata resultMetadata, StringBuilder builder) {
        if (resultMetadata.getBoolean(KEY_IS_POTENTIALLY_OBSCURED, false)) {
            builder.append(' ').append(StringManager.getString(locale, "result_message_addendum_view_potentially_obscured"));
        }
        if (resultMetadata.getBoolean(KEY_IS_AGAINST_SCROLLABLE_EDGE, false)) {
            builder.append(' ').append(StringManager.getString(locale, "result_message_addendum_against_scrollable_edge"));
        }
    }

    private static @Nullable String generateMessageForResultId(Locale locale, int resultId) {
        switch (resultId) {
            case 1: {
                return StringManager.getString(locale, "result_message_not_visible");
            }
            case 2: {
                return StringManager.getString(locale, "result_message_not_imageview");
            }
            case 6: {
                return StringManager.getString(locale, "result_message_not_enabled");
            }
            case 3: {
                return StringManager.getString(locale, "result_message_no_screencapture");
            }
            case 7: {
                return StringManager.getString(locale, "result_message_screencapture_data_hidden");
            }
            case 9: {
                return StringManager.getString(locale, "result_message_screencapture_uniform_color");
            }
        }
        return null;
    }
}

