/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework;

import com.google.android.apps.common.testing.accessibility.framework.AnswerType;
import com.google.android.apps.common.testing.accessibility.framework.HashMapResultMetadata;
import com.google.android.apps.common.testing.accessibility.framework.Question;
import com.google.android.apps.common.testing.accessibility.framework.ResultMetadata;
import com.google.android.apps.common.testing.accessibility.framework.proto.AccessibilityEvaluationProtos;
import com.google.android.apps.common.testing.accessibility.framework.uielement.AccessibilityHierarchy;
import com.google.common.annotations.Beta;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

@Beta
public class Answer {
    private final Class<? extends AnswerType> answerTypeClass;
    private final Question question;
    private final ResultMetadata metadata;

    public Answer(Class<? extends AnswerType> answerTypeClass, Question question, ResultMetadata metadata) {
        this.answerTypeClass = answerTypeClass;
        this.question = question;
        this.metadata = metadata;
    }

    public Class<? extends AnswerType> getAnswerTypeClass() {
        return this.answerTypeClass;
    }

    public Question getQuestion() {
        return this.question;
    }

    public ResultMetadata getMetadata() {
        return this.metadata;
    }

    public AccessibilityEvaluationProtos.AnswerProto toProto() {
        AccessibilityEvaluationProtos.AnswerProto.Builder builder = AccessibilityEvaluationProtos.AnswerProto.newBuilder();
        builder.setAnswerTypeClass(this.getAnswerTypeClass().getName());
        builder.setQuestion(this.getQuestion().toProto());
        if (this.getMetadata() instanceof HashMapResultMetadata) {
            builder.setMetadata(((HashMapResultMetadata)this.getMetadata()).toProto());
        }
        return (AccessibilityEvaluationProtos.AnswerProto)builder.build();
    }

    public static Answer fromProto(AccessibilityEvaluationProtos.AnswerProto proto, AccessibilityHierarchy associatedHierarchy) {
        Class<AnswerType> answerTypeClass = null;
        try {
            answerTypeClass = Class.forName(proto.getAnswerTypeClass()).asSubclass(AnswerType.class);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
        Question question = Question.fromProto(proto.getQuestion(), associatedHierarchy);
        HashMapResultMetadata metadata = HashMapResultMetadata.fromProto(proto.getMetadata());
        return new Answer(answerTypeClass, question, metadata);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Answer)) {
            return false;
        }
        Answer that = (Answer)o;
        if (this.getAnswerTypeClass() != that.getAnswerTypeClass()) {
            return false;
        }
        if (!this.getQuestion().equals(that.getQuestion())) {
            return false;
        }
        return Objects.equals(this.getMetadata(), that.getMetadata());
    }

    public int hashCode() {
        return Objects.hash(this.getAnswerTypeClass(), this.getQuestion(), this.getMetadata());
    }
}

