/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework;

import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckPreset;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityHierarchyCheck;
import com.google.android.apps.common.testing.accessibility.framework.Answer;
import com.google.android.apps.common.testing.accessibility.framework.HashMapResultMetadata;
import com.google.android.apps.common.testing.accessibility.framework.ResultMetadata;
import com.google.android.apps.common.testing.accessibility.framework.proto.AccessibilityEvaluationProtos;
import com.google.android.apps.common.testing.accessibility.framework.uielement.AccessibilityHierarchy;
import com.google.android.apps.common.testing.accessibility.framework.uielement.ViewHierarchyElement;
import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Locale;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;
import org.jsoup.Jsoup;

public class AccessibilityHierarchyCheckResult
extends AccessibilityCheckResult {
    private final int resultId;
    private final @Nullable ViewHierarchyElement element;
    private final @Nullable ResultMetadata metadata;
    private final ImmutableList<Answer> answers;

    @Beta
    public AccessibilityHierarchyCheckResult(Class<? extends AccessibilityHierarchyCheck> checkClass, AccessibilityCheckResult.AccessibilityCheckResultType type, @Nullable ViewHierarchyElement element, int resultId, @Nullable ResultMetadata metadata, ImmutableList<Answer> answers) {
        super((Class)Preconditions.checkNotNull(checkClass), (AccessibilityCheckResult.AccessibilityCheckResultType)((Object)Preconditions.checkNotNull((Object)((Object)type))), null);
        this.element = element;
        this.resultId = resultId;
        this.metadata = metadata;
        this.answers = answers;
    }

    public AccessibilityHierarchyCheckResult(Class<? extends AccessibilityHierarchyCheck> checkClass, AccessibilityCheckResult.AccessibilityCheckResultType type, @Nullable ViewHierarchyElement element, int resultId, @Nullable ResultMetadata metadata) {
        this(checkClass, type, element, resultId, metadata, (ImmutableList<Answer>)ImmutableList.of());
    }

    public AccessibilityHierarchyCheckResult getSuppressedResultCopy() {
        return new AccessibilityHierarchyCheckResult(this.getSourceCheckClass().asSubclass(AccessibilityHierarchyCheck.class), AccessibilityCheckResult.AccessibilityCheckResultType.SUPPRESSED, this.getElement(), this.resultId, this.metadata, this.answers);
    }

    public static AccessibilityHierarchyCheckResult fromProto(AccessibilityEvaluationProtos.AccessibilityHierarchyCheckResultProto proto, AccessibilityHierarchy associatedHierarchy) {
        AccessibilityHierarchyCheck check = AccessibilityCheckPreset.getHierarchyCheckForClassName(proto.getSourceCheckClass());
        Preconditions.checkNotNull((Object)check, (String)"Failed to resolve check class: %s", (Object)proto.getSourceCheckClass());
        int resultId = proto.getResultId();
        AccessibilityCheckResult.AccessibilityCheckResultType type = AccessibilityCheckResult.AccessibilityCheckResultType.fromProto(proto.getResultType());
        HashMapResultMetadata metadata = proto.hasMetadata() ? HashMapResultMetadata.fromProto(proto.getMetadata()) : null;
        ViewHierarchyElement element = proto.hasHierarchySourceId() ? associatedHierarchy.getViewById(proto.getHierarchySourceId()) : null;
        ImmutableList.Builder answersBuilder = ImmutableList.builder();
        for (AccessibilityEvaluationProtos.AnswerProto answer : proto.getAnswersList()) {
            answersBuilder.add((Object)Answer.fromProto(answer, associatedHierarchy));
        }
        return new AccessibilityHierarchyCheckResult(check.getClass(), type, element, resultId, metadata, (ImmutableList<Answer>)answersBuilder.build());
    }

    public String getRawTitleMessage(Locale locale) {
        return this.getCheck().getTitleMessage(locale);
    }

    public CharSequence getTitleMessage(Locale locale) {
        return Jsoup.parse(this.getRawTitleMessage(locale)).text();
    }

    public String getRawMessage(Locale locale) {
        return this.getCheck().getMessageForResult(locale, this);
    }

    @Override
    public CharSequence getMessage(Locale locale) {
        return Jsoup.parse(this.getRawMessage(locale)).text();
    }

    public String getRawShortMessage(Locale locale) {
        return this.getCheck().getShortMessageForResult(locale, this);
    }

    public CharSequence getShortMessage(Locale locale) {
        return Jsoup.parse(this.getRawShortMessage(locale)).text();
    }

    public int getResultId() {
        return this.resultId;
    }

    @Beta
    public ImmutableList<Answer> getAnswers() {
        return this.answers;
    }

    @Pure
    public @Nullable ResultMetadata getMetadata() {
        return this.metadata;
    }

    @Pure
    public @Nullable ViewHierarchyElement getElement() {
        return this.element;
    }

    public @Nullable Double getSecondaryPriority() {
        return this.getCheck().getSecondaryPriority(this);
    }

    public AccessibilityEvaluationProtos.AccessibilityHierarchyCheckResultProto toProto() {
        AccessibilityEvaluationProtos.AccessibilityHierarchyCheckResultProto.Builder builder = AccessibilityEvaluationProtos.AccessibilityHierarchyCheckResultProto.newBuilder();
        builder.setResultId(this.getResultId());
        if (this.getSourceCheckClass() != null) {
            builder.setSourceCheckClass(this.getSourceCheckClass().getName());
        }
        if (this.getType() != null) {
            builder.setResultType(this.getType().toProto());
        }
        if (this.getMetadata() instanceof HashMapResultMetadata) {
            builder.setMetadata(((HashMapResultMetadata)this.getMetadata()).toProto());
        }
        if (this.getElement() != null) {
            builder.setHierarchySourceId(this.getElement().getCondensedUniqueId());
        }
        for (Answer answer : this.getAnswers()) {
            builder.addAnswers(answer.toProto());
        }
        return (AccessibilityEvaluationProtos.AccessibilityHierarchyCheckResultProto)builder.build();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AccessibilityHierarchyCheckResult)) {
            return false;
        }
        AccessibilityHierarchyCheckResult that = (AccessibilityHierarchyCheckResult)o;
        if (this.getType() != that.getType()) {
            return false;
        }
        if (this.getResultId() != that.getResultId()) {
            return false;
        }
        if (this.getSourceCheckClass() != that.getSourceCheckClass()) {
            return false;
        }
        ViewHierarchyElement thatElement = that.getElement();
        if (this.getElement() != null ? thatElement == null || this.getElement().getCondensedUniqueId() != thatElement.getCondensedUniqueId() : thatElement != null) {
            return false;
        }
        if (!Objects.equals(this.getMetadata(), that.getMetadata())) {
            return false;
        }
        return this.getAnswers().equals(that.getAnswers());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getType(), this.getResultId(), this.getSourceCheckClass(), this.getElement(), this.getMetadata(), this.getAnswers()});
    }

    @Override
    public String toString() {
        return String.format("AccessibilityHierarchyCheckResult %s %s %s %s %s num_answers:%d", new Object[]{this.getType(), this.getSourceCheckClass().getSimpleName(), this.getResultId(), this.getElement(), this.getMetadata(), this.getAnswers().size()});
    }

    private AccessibilityHierarchyCheck getCheck() {
        AccessibilityHierarchyCheck check = AccessibilityCheckPreset.getHierarchyCheckForClass(this.getSourceCheckClass());
        return (AccessibilityHierarchyCheck)Preconditions.checkNotNull((Object)check, (String)"Failed to resolve check class: %s", this.getSourceCheckClass());
    }
}

