/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.validator;

import android.view.View;
import com.android.tools.idea.validator.ValidatorData;
import com.android.tools.idea.validator.ValidatorResult;
import com.android.tools.idea.validator.accessibility.AccessibilityValidator;
import java.awt.image.BufferedImage;
import java.util.EnumSet;

public class LayoutValidator {
    public static final ValidatorData.Policy DEFAULT_POLICY;
    private static ValidatorData.Policy sPolicy;

    public static ValidatorResult validate(View view, BufferedImage image) {
        if (view.isAttachedToWindow()) {
            return AccessibilityValidator.validateAccessibility(view, image, sPolicy);
        }
        return new ValidatorResult.Builder().build();
    }

    public static void updatePolicy(ValidatorData.Policy policy) {
        sPolicy = policy;
    }

    static {
        sPolicy = DEFAULT_POLICY = new ValidatorData.Policy(EnumSet.of(ValidatorData.Type.ACCESSIBILITY, ValidatorData.Type.RENDER), EnumSet.of(ValidatorData.Level.ERROR, ValidatorData.Level.WARNING));
    }
}

