/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.impl;

import android.graphics.BlendComposite;
import android.graphics.PorterDuff;
import com.android.layoutlib.bridge.Bridge;
import java.awt.AlphaComposite;
import java.awt.Composite;

public final class PorterDuffUtility {
    private static final int MODES_COUNT = PorterDuff.Mode.values().length;

    private PorterDuffUtility() {
    }

    public static PorterDuff.Mode getPorterDuffMode(int porterDuffMode) {
        if (porterDuffMode >= 0 && porterDuffMode < MODES_COUNT) {
            return PorterDuff.intToMode(porterDuffMode);
        }
        Bridge.getLog().error("broken", String.format("Unknown PorterDuff.Mode: %1$d", porterDuffMode), null, null);
        assert (false);
        return PorterDuff.Mode.SRC_OVER;
    }

    public static Composite getComposite(PorterDuff.Mode mode, int alpha255) {
        float alpha1 = alpha255 != 255 ? (float)alpha255 / 255.0f : 1.0f;
        switch (mode) {
            case CLEAR: {
                return AlphaComposite.getInstance(1, alpha1);
            }
            case SRC: {
                return AlphaComposite.getInstance(2, alpha1);
            }
            case DST: {
                return AlphaComposite.getInstance(9, alpha1);
            }
            case SRC_OVER: {
                return AlphaComposite.getInstance(3, alpha1);
            }
            case DST_OVER: {
                return AlphaComposite.getInstance(4, alpha1);
            }
            case SRC_IN: {
                return AlphaComposite.getInstance(5, alpha1);
            }
            case DST_IN: {
                return AlphaComposite.getInstance(6, alpha1);
            }
            case SRC_OUT: {
                return AlphaComposite.getInstance(7, alpha1);
            }
            case DST_OUT: {
                return AlphaComposite.getInstance(8, alpha1);
            }
            case SRC_ATOP: {
                return AlphaComposite.getInstance(10, alpha1);
            }
            case DST_ATOP: {
                return AlphaComposite.getInstance(11, alpha1);
            }
            case XOR: {
                return AlphaComposite.getInstance(12, alpha1);
            }
            case DARKEN: {
                return BlendComposite.getInstance(BlendComposite.BlendingMode.DARKEN, alpha1);
            }
            case LIGHTEN: {
                return BlendComposite.getInstance(BlendComposite.BlendingMode.LIGHTEN, alpha1);
            }
            case MULTIPLY: {
                return BlendComposite.getInstance(BlendComposite.BlendingMode.MULTIPLY, alpha1);
            }
            case SCREEN: {
                return BlendComposite.getInstance(BlendComposite.BlendingMode.SCREEN, alpha1);
            }
            case ADD: {
                return BlendComposite.getInstance(BlendComposite.BlendingMode.ADD, alpha1);
            }
            case OVERLAY: {
                return BlendComposite.getInstance(BlendComposite.BlendingMode.OVERLAY, alpha1);
            }
        }
        Bridge.getLog().fidelityWarning("broken", String.format("Unsupported PorterDuff Mode: %1$s", mode.name()), null, null, null);
        return AlphaComposite.getInstance(3, alpha1);
    }
}

