/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.android.layoutlib.bridge.android.BridgeLayoutParamsMapAttributes;
import java.util.HashMap;

public class MockView
extends FrameLayout {
    private final TextView mView;

    public MockView(Context context) {
        this(context, null);
    }

    public MockView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MockView(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public MockView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("layout_width", "match_parent");
        attributes.put("layout_height", "match_parent");
        this.mView = new TextView(context, new BridgeLayoutParamsMapAttributes(attributes));
        this.mView.setTextColor(-16777216);
        this.setGravity(17);
        this.setText(this.getClass().getSimpleName());
        this.addView(this.mView);
        this.setBackgroundColor(-8421505);
    }

    @Override
    public void addView(View child) {
        if (child == this.mView) {
            super.addView(child);
        }
    }

    @Override
    public void addView(View child, int index) {
        if (child == this.mView) {
            super.addView(child, index);
        }
    }

    @Override
    public void addView(View child, int width, int height) {
        if (child == this.mView) {
            super.addView(child, width, height);
        }
    }

    @Override
    public void addView(View child, ViewGroup.LayoutParams params) {
        if (child == this.mView) {
            super.addView(child, params);
        }
    }

    @Override
    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        if (child == this.mView) {
            super.addView(child, index, params);
        }
    }

    public void setText(CharSequence text) {
        this.mView.setText(text);
    }

    public void setGravity(int gravity) {
        this.mView.setGravity(gravity);
    }
}

