/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.util.IntProperty;
import android.view.View;
import android.view.animation.Interpolator;
import android.view.animation.PathInterpolator;
import com.android.internal.widget.MessagingLayout;
import com.android.internal.widget.MessagingLinearLayout;
import com.android.internal.widget.ViewClippingUtil;

public class MessagingPropertyAnimator
implements View.OnLayoutChangeListener {
    private static final long APPEAR_ANIMATION_LENGTH = 210L;
    public static final Interpolator ALPHA_IN = new PathInterpolator(0.4f, 0.0f, 1.0f, 1.0f);
    public static final Interpolator ALPHA_OUT = new PathInterpolator(0.0f, 0.0f, 0.8f, 1.0f);
    private static final int TAG_TOP_ANIMATOR = 16909500;
    private static final int TAG_TOP = 16909501;
    private static final int TAG_LAYOUT_TOP = 16909499;
    private static final int TAG_FIRST_LAYOUT = 16909498;
    private static final int TAG_ALPHA_ANIMATOR = 16909497;
    private static final ViewClippingUtil.ClippingParameters CLIPPING_PARAMETERS = view -> view.getId() == 16909239;
    private static final IntProperty<View> TOP = new IntProperty<View>("top"){

        @Override
        public void setValue(View object, int value) {
            MessagingPropertyAnimator.setTop(object, value);
        }

        @Override
        public Integer get(View object) {
            return MessagingPropertyAnimator.getTop(object);
        }
    };

    @Override
    public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
        MessagingPropertyAnimator.setLayoutTop(v, top);
        if (MessagingPropertyAnimator.isFirstLayout(v)) {
            MessagingPropertyAnimator.setFirstLayout(v, false);
            MessagingPropertyAnimator.setTop(v, top);
            return;
        }
        MessagingPropertyAnimator.startTopAnimation(v, MessagingPropertyAnimator.getTop(v), top, MessagingLayout.FAST_OUT_SLOW_IN);
    }

    private static boolean isFirstLayout(View view) {
        Boolean tag = (Boolean)view.getTag(16909498);
        if (tag == null) {
            return true;
        }
        return tag;
    }

    public static void recycle(View view) {
        MessagingPropertyAnimator.setFirstLayout(view, true);
    }

    private static void setFirstLayout(View view, boolean first) {
        view.setTagInternal(16909498, first);
    }

    private static void setLayoutTop(View view, int top) {
        view.setTagInternal(16909499, top);
    }

    public static int getLayoutTop(View view) {
        Integer tag = (Integer)view.getTag(16909499);
        if (tag == null) {
            return MessagingPropertyAnimator.getTop(view);
        }
        return tag;
    }

    public static void startLocalTranslationFrom(View view, int startTranslation, Interpolator interpolator2) {
        MessagingPropertyAnimator.startTopAnimation(view, MessagingPropertyAnimator.getTop(view) + startTranslation, MessagingPropertyAnimator.getLayoutTop(view), interpolator2);
    }

    public static void startLocalTranslationTo(View view, int endTranslation, Interpolator interpolator2) {
        int top = MessagingPropertyAnimator.getTop(view);
        MessagingPropertyAnimator.startTopAnimation(view, top, top + endTranslation, interpolator2);
    }

    public static int getTop(View v) {
        Integer tag = (Integer)v.getTag(16909501);
        if (tag == null) {
            return v.getTop();
        }
        return tag;
    }

    private static void setTop(View v, int value) {
        v.setTagInternal(16909501, value);
        MessagingPropertyAnimator.updateTopAndBottom(v);
    }

    private static void updateTopAndBottom(View v) {
        int top = MessagingPropertyAnimator.getTop(v);
        int height = v.getHeight();
        v.setTop(top);
        v.setBottom(height + top);
    }

    private static void startTopAnimation(final View v, int start, int end, Interpolator interpolator2) {
        ObjectAnimator existing = (ObjectAnimator)v.getTag(16909500);
        if (existing != null) {
            existing.cancel();
        }
        if (!v.isShown() || start == end || MessagingLinearLayout.isGone(v) && !MessagingPropertyAnimator.isHidingAnimated(v)) {
            MessagingPropertyAnimator.setTop(v, end);
            return;
        }
        ObjectAnimator animator2 = ObjectAnimator.ofInt(v, TOP, start, end);
        MessagingPropertyAnimator.setTop(v, start);
        animator2.setInterpolator(interpolator2);
        animator2.setDuration(210L);
        animator2.addListener(new AnimatorListenerAdapter(){
            public boolean mCancelled;

            @Override
            public void onAnimationEnd(Animator animation) {
                v.setTagInternal(16909500, null);
                MessagingPropertyAnimator.setClippingDeactivated(v, false);
            }

            @Override
            public void onAnimationCancel(Animator animation) {
                this.mCancelled = true;
            }
        });
        MessagingPropertyAnimator.setClippingDeactivated(v, true);
        v.setTagInternal(16909500, animator2);
        animator2.start();
    }

    private static boolean isHidingAnimated(View v) {
        if (v instanceof MessagingLinearLayout.MessagingChild) {
            return ((MessagingLinearLayout.MessagingChild)((Object)v)).isHidingAnimated();
        }
        return false;
    }

    public static void fadeIn(final View v) {
        ObjectAnimator existing = (ObjectAnimator)v.getTag(16909497);
        if (existing != null) {
            existing.cancel();
        }
        if (v.getVisibility() == 4) {
            v.setVisibility(0);
        }
        ObjectAnimator animator2 = ObjectAnimator.ofFloat(v, View.ALPHA, 0.0f, 1.0f);
        v.setAlpha(0.0f);
        animator2.setInterpolator(ALPHA_IN);
        animator2.setDuration(210L);
        animator2.addListener(new AnimatorListenerAdapter(){

            @Override
            public void onAnimationEnd(Animator animation) {
                v.setTagInternal(16909497, null);
                MessagingPropertyAnimator.updateLayerType(v, false);
            }
        });
        MessagingPropertyAnimator.updateLayerType(v, true);
        v.setTagInternal(16909497, animator2);
        animator2.start();
    }

    private static void updateLayerType(View view, boolean animating) {
        if (view.hasOverlappingRendering() && animating) {
            view.setLayerType(2, null);
        } else if (view.getLayerType() == 2) {
            view.setLayerType(0, null);
        }
    }

    public static void fadeOut(final View view, final Runnable endAction) {
        ObjectAnimator existing = (ObjectAnimator)view.getTag(16909497);
        if (existing != null) {
            existing.cancel();
        }
        if (!view.isShown() || MessagingLinearLayout.isGone(view) && !MessagingPropertyAnimator.isHidingAnimated(view)) {
            view.setAlpha(0.0f);
            if (endAction != null) {
                endAction.run();
            }
            return;
        }
        ObjectAnimator animator2 = ObjectAnimator.ofFloat(view, View.ALPHA, view.getAlpha(), 0.0f);
        animator2.setInterpolator(ALPHA_OUT);
        animator2.setDuration(210L);
        animator2.addListener(new AnimatorListenerAdapter(){

            @Override
            public void onAnimationEnd(Animator animation) {
                view.setTagInternal(16909497, null);
                MessagingPropertyAnimator.updateLayerType(view, false);
                if (endAction != null) {
                    endAction.run();
                }
            }
        });
        MessagingPropertyAnimator.updateLayerType(view, true);
        view.setTagInternal(16909497, animator2);
        animator2.start();
    }

    public static void setClippingDeactivated(View transformedView, boolean deactivated) {
        ViewClippingUtil.setClippingDeactivated(transformedView, deactivated, CLIPPING_PARAMETERS);
    }

    public static boolean isAnimatingTranslation(View v) {
        return v.getTag(16909500) != null;
    }

    public static boolean isAnimatingAlpha(View v) {
        return v.getTag(16909497) != null;
    }

    public static void setToLaidOutPosition(View view) {
        MessagingPropertyAnimator.setTop(view, MessagingPropertyAnimator.getLayoutTop(view));
    }
}

