/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ViewAnimator;
import java.util.ArrayList;

public class DialogViewAnimator
extends ViewAnimator {
    private final ArrayList<View> mMatchParentChildren = new ArrayList(1);

    public DialogViewAnimator(Context context) {
        super(context);
    }

    public DialogViewAnimator(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        boolean measureMatchParentChildren = View.MeasureSpec.getMode(widthMeasureSpec) != 0x40000000 || View.MeasureSpec.getMode(heightMeasureSpec) != 0x40000000;
        int maxHeight = 0;
        int maxWidth = 0;
        int childState = 0;
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            boolean matchHeight;
            View child = this.getChildAt(i);
            if (!this.getMeasureAllChildren() && child.getVisibility() == 8) continue;
            FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)child.getLayoutParams();
            boolean matchWidth = lp.width == -1;
            boolean bl = matchHeight = lp.height == -1;
            if (measureMatchParentChildren && (matchWidth || matchHeight)) {
                this.mMatchParentChildren.add(child);
            }
            this.measureChildWithMargins(child, widthMeasureSpec, 0, heightMeasureSpec, 0);
            int state = 0;
            if (measureMatchParentChildren && !matchWidth) {
                maxWidth = Math.max(maxWidth, child.getMeasuredWidth() + lp.leftMargin + lp.rightMargin);
                state |= child.getMeasuredWidthAndState() & 0xFF000000;
            }
            if (measureMatchParentChildren && !matchHeight) {
                maxHeight = Math.max(maxHeight, child.getMeasuredHeight() + lp.topMargin + lp.bottomMargin);
                state |= child.getMeasuredHeightAndState() >> 16 & 0xFFFFFF00;
            }
            childState = DialogViewAnimator.combineMeasuredStates(childState, state);
        }
        maxWidth += this.getPaddingLeft() + this.getPaddingRight();
        maxHeight += this.getPaddingTop() + this.getPaddingBottom();
        maxHeight = Math.max(maxHeight, this.getSuggestedMinimumHeight());
        maxWidth = Math.max(maxWidth, this.getSuggestedMinimumWidth());
        Drawable drawable2 = this.getForeground();
        if (drawable2 != null) {
            maxHeight = Math.max(maxHeight, drawable2.getMinimumHeight());
            maxWidth = Math.max(maxWidth, drawable2.getMinimumWidth());
        }
        this.setMeasuredDimension(DialogViewAnimator.resolveSizeAndState(maxWidth, widthMeasureSpec, childState), DialogViewAnimator.resolveSizeAndState(maxHeight, heightMeasureSpec, childState << 16));
        int matchCount = this.mMatchParentChildren.size();
        for (int i = 0; i < matchCount; ++i) {
            View child = this.mMatchParentChildren.get(i);
            ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
            int childWidthMeasureSpec = lp.width == -1 ? View.MeasureSpec.makeMeasureSpec(this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight() - lp.leftMargin - lp.rightMargin, 0x40000000) : DialogViewAnimator.getChildMeasureSpec(widthMeasureSpec, this.getPaddingLeft() + this.getPaddingRight() + lp.leftMargin + lp.rightMargin, lp.width);
            int childHeightMeasureSpec = lp.height == -1 ? View.MeasureSpec.makeMeasureSpec(this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom() - lp.topMargin - lp.bottomMargin, 0x40000000) : DialogViewAnimator.getChildMeasureSpec(heightMeasureSpec, this.getPaddingTop() + this.getPaddingBottom() + lp.topMargin + lp.bottomMargin, lp.height);
            child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
        }
        this.mMatchParentChildren.clear();
    }
}

