/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.widget.LinearLayout;
import com.android.internal.R;

public class ButtonBarLayout
extends LinearLayout {
    private static final int PEEK_BUTTON_DP = 16;
    private boolean mAllowStacking;
    private int mLastWidthSize = -1;
    private int mMinimumHeight = 0;

    @UnsupportedAppUsage
    public ButtonBarLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.ButtonBarLayout);
        this.mAllowStacking = ta.getBoolean(0, true);
        ta.recycle();
    }

    public void setAllowStacking(boolean allowStacking) {
        if (this.mAllowStacking != allowStacking) {
            this.mAllowStacking = allowStacking;
            if (!this.mAllowStacking && this.getOrientation() == 1) {
                this.setStacked(false);
            }
            this.requestLayout();
        }
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int measuredWidth;
        int measuredWidthState;
        int initialWidthMeasureSpec;
        int widthSize = View.MeasureSpec.getSize(widthMeasureSpec);
        if (this.mAllowStacking) {
            if (widthSize > this.mLastWidthSize && this.isStacked()) {
                this.setStacked(false);
            }
            this.mLastWidthSize = widthSize;
        }
        boolean needsRemeasure = false;
        if (!this.isStacked() && View.MeasureSpec.getMode(widthMeasureSpec) == 0x40000000) {
            initialWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec(widthSize, Integer.MIN_VALUE);
            needsRemeasure = true;
        } else {
            initialWidthMeasureSpec = widthMeasureSpec;
        }
        super.onMeasure(initialWidthMeasureSpec, heightMeasureSpec);
        if (this.mAllowStacking && !this.isStacked() && (measuredWidthState = (measuredWidth = this.getMeasuredWidthAndState()) & 0xFF000000) == 0x1000000) {
            this.setStacked(true);
            needsRemeasure = true;
        }
        if (needsRemeasure) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
        int minHeight = 0;
        int firstVisible = this.getNextVisibleChildIndex(0);
        if (firstVisible >= 0) {
            View firstButton = this.getChildAt(firstVisible);
            LinearLayout.LayoutParams firstParams = (LinearLayout.LayoutParams)firstButton.getLayoutParams();
            minHeight += this.getPaddingTop() + firstButton.getMeasuredHeight() + firstParams.topMargin + firstParams.bottomMargin;
            if (this.isStacked()) {
                int secondVisible = this.getNextVisibleChildIndex(firstVisible + 1);
                if (secondVisible >= 0) {
                    minHeight = (int)((float)minHeight + ((float)this.getChildAt(secondVisible).getPaddingTop() + 16.0f * this.getResources().getDisplayMetrics().density));
                }
            } else {
                minHeight += this.getPaddingBottom();
            }
        }
        if (this.getMinimumHeight() != minHeight) {
            this.setMinimumHeight(minHeight);
        }
    }

    private int getNextVisibleChildIndex(int index) {
        int count = this.getChildCount();
        for (int i = index; i < count; ++i) {
            if (this.getChildAt(i).getVisibility() != 0) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getMinimumHeight() {
        return Math.max(this.mMinimumHeight, super.getMinimumHeight());
    }

    private void setStacked(boolean stacked) {
        this.setOrientation(stacked ? 1 : 0);
        this.setGravity(stacked ? 0x800005 : 80);
        Object spacer = this.findViewById(16909456);
        if (spacer != null) {
            ((View)spacer).setVisibility(stacked ? 8 : 4);
        }
        int childCount = this.getChildCount();
        for (int i = childCount - 2; i >= 0; --i) {
            this.bringChildToFront(this.getChildAt(i));
        }
    }

    private boolean isStacked() {
        return this.getOrientation() == 1;
    }
}

