/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.BatteryStats;
import com.android.internal.os.BatterySipper;
import com.android.internal.os.PowerCalculator;
import com.android.internal.os.PowerProfile;

public class CameraPowerCalculator
extends PowerCalculator {
    private final double mCameraPowerOnAvg;

    public CameraPowerCalculator(PowerProfile profile) {
        this.mCameraPowerOnAvg = profile.getAveragePower("camera.avg");
    }

    @Override
    public void calculateApp(BatterySipper app, BatteryStats.Uid u, long rawRealtimeUs, long rawUptimeUs, int statsType) {
        BatteryStats.Timer timer = u.getCameraTurnedOnTimer();
        if (timer != null) {
            long totalTime;
            app.cameraTimeMs = totalTime = timer.getTotalTimeLocked(rawRealtimeUs, statsType) / 1000L;
            app.cameraPowerMah = (double)totalTime * this.mCameraPowerOnAvg / 3600000.0;
        } else {
            app.cameraTimeMs = 0L;
            app.cameraPowerMah = 0.0;
        }
    }
}

