/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.android.internal.widget.ViewPager;

public class ResolverViewPager
extends ViewPager {
    private boolean mSwipingEnabled = true;

    public ResolverViewPager(Context context) {
        super(context);
    }

    public ResolverViewPager(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public ResolverViewPager(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public ResolverViewPager(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (View.MeasureSpec.getMode(heightMeasureSpec) != Integer.MIN_VALUE) {
            return;
        }
        widthMeasureSpec = View.MeasureSpec.makeMeasureSpec(this.getMeasuredWidth(), 0x40000000);
        int height = this.getMeasuredHeight();
        int maxHeight = 0;
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            child.measure(widthMeasureSpec, View.MeasureSpec.makeMeasureSpec(height, Integer.MIN_VALUE));
            if (maxHeight >= child.getMeasuredHeight()) continue;
            maxHeight = child.getMeasuredHeight();
        }
        if (maxHeight > 0) {
            height = maxHeight;
        }
        heightMeasureSpec = View.MeasureSpec.makeMeasureSpec(height, 0x40000000);
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    void setSwipingEnabled(boolean swipingEnabled) {
        this.mSwipingEnabled = swipingEnabled;
    }

    @Override
    public boolean onInterceptTouchEvent(MotionEvent ev) {
        return !this.isLayoutRtl() && this.mSwipingEnabled && super.onInterceptTouchEvent(ev);
    }
}

